/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Group {
    @JsonValue
    private final Map<String, String> values;

    public static Group of(String ... pathsAndValues) {
        if (pathsAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Number of values should be even");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(pathsAndValues.length / 2);
        for (int i = 0; i < pathsAndValues.length; i += 2) {
            map.put(pathsAndValues[i], pathsAndValues[i + 1]);
        }
        return new Group(map);
    }

    @JsonCreator
    public Group(Map<String, String> values2) {
        this.values = values2;
    }

    public String get(String path) {
        return this.values.get(path);
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        Map<String, String> this$values = this.getValues();
        Map<String, String> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "Group(values=" + String.valueOf(this.getValues()) + ")";
    }
}

