/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.search.constraints;

import io.fluxcapacitor.common.api.search.Constraint;
import io.fluxcapacitor.common.api.search.NoOpConstraint;
import io.fluxcapacitor.common.search.Document;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public final class AllConstraint
implements Constraint {
    private final List<Constraint> all;
    private final AtomicReference<Object> decompose = new AtomicReference();

    public static Constraint all(Constraint ... constraints) {
        return AllConstraint.all(Arrays.asList(constraints));
    }

    public static Constraint all(Collection<Constraint> constraints) {
        List<Constraint> list = constraints.stream().distinct().collect(Collectors.toList());
        return switch (list.size()) {
            case 0 -> NoOpConstraint.instance;
            case 1 -> (Constraint)list.get(0);
            default -> new AllConstraint(list);
        };
    }

    @Override
    public boolean matches(Document document) {
        return this.all.stream().allMatch(c -> c.matches(document));
    }

    @Override
    public boolean hasPathConstraint() {
        return this.all.stream().anyMatch(Constraint::hasPathConstraint);
    }

    public List<Constraint> getAll() {
        return this.all;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllConstraint)) {
            return false;
        }
        AllConstraint other = (AllConstraint)o;
        List<Constraint> this$all = this.getAll();
        List<Constraint> other$all = other.getAll();
        return !(this$all == null ? other$all != null : !((Object)this$all).equals(other$all));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Constraint> $all = this.getAll();
        result = result * 59 + ($all == null ? 43 : ((Object)$all).hashCode());
        return result;
    }

    public String toString() {
        return "AllConstraint(all=" + String.valueOf(this.getAll()) + ")";
    }

    @ConstructorProperties(value={"all"})
    private AllConstraint(List<Constraint> all) {
        this.all = all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constraint decompose() {
        Object value = this.decompose.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.decompose;
            synchronized (atomicReference) {
                value = this.decompose.get();
                if (value == null) {
                    Constraint actualValue = AllConstraint.all(this.getAll().stream().map(Constraint::decompose).collect(Collectors.toList()));
                    value = actualValue == null ? this.decompose : actualValue;
                    this.decompose.set(value);
                }
            }
        }
        return (Constraint)(value == this.decompose ? null : value);
    }
}

