/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.api.tracking;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Command;
import java.beans.ConstructorProperties;
import java.util.Arrays;

public final class StorePosition
extends Command {
    private final MessageType messageType;
    private final String consumer;
    private final int[] segment;
    private final long lastIndex;
    private final Guarantee guarantee;

    @Override
    public String routingKey() {
        return "%s_%s".formatted(new Object[]{this.messageType, this.consumer});
    }

    @ConstructorProperties(value={"messageType", "consumer", "segment", "lastIndex", "guarantee"})
    public StorePosition(MessageType messageType, String consumer, int[] segment, long lastIndex, Guarantee guarantee) {
        this.messageType = messageType;
        this.consumer = consumer;
        this.segment = segment;
        this.lastIndex = lastIndex;
        this.guarantee = guarantee;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public int[] getSegment() {
        return this.segment;
    }

    public long getLastIndex() {
        return this.lastIndex;
    }

    @Override
    public Guarantee getGuarantee() {
        return this.guarantee;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorePosition)) {
            return false;
        }
        StorePosition other = (StorePosition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastIndex() != other.getLastIndex()) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        String this$consumer = this.getConsumer();
        String other$consumer = other.getConsumer();
        if (this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer)) {
            return false;
        }
        if (!Arrays.equals(this.getSegment(), other.getSegment())) {
            return false;
        }
        Guarantee this$guarantee = this.getGuarantee();
        Guarantee other$guarantee = other.getGuarantee();
        return !(this$guarantee == null ? other$guarantee != null : !((Object)((Object)this$guarantee)).equals((Object)other$guarantee));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StorePosition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastIndex = this.getLastIndex();
        result = result * 59 + (int)($lastIndex >>> 32 ^ $lastIndex);
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        String $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSegment());
        Guarantee $guarantee = this.getGuarantee();
        result = result * 59 + ($guarantee == null ? 43 : ((Object)((Object)$guarantee)).hashCode());
        return result;
    }

    public String toString() {
        return "StorePosition(messageType=" + String.valueOf((Object)this.getMessageType()) + ", consumer=" + this.getConsumer() + ", segment=" + Arrays.toString(this.getSegment()) + ", lastIndex=" + this.getLastIndex() + ", guarantee=" + String.valueOf((Object)this.getGuarantee()) + ")";
    }
}

