/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.application;

import io.fluxcapacitor.common.FileUtils;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.application.DecryptingPropertySource;
import io.fluxcapacitor.common.encryption.Encryption;
import java.util.Optional;
import java.util.Properties;

public class ApplicationEnvironmentPropertiesSource
extends DecryptingPropertySource {
    public ApplicationEnvironmentPropertiesSource(Encryption encryption) {
        this(ApplicationEnvironmentPropertiesSource.getEnvironment(), encryption);
    }

    public ApplicationEnvironmentPropertiesSource(String environment, Encryption encryption) {
        super(ApplicationEnvironmentPropertiesSource.loadProperties(environment), encryption);
    }

    protected static Properties loadProperties(String environment) {
        return Optional.ofNullable(environment).map(e -> String.format("/application-%s.properties", e)).flatMap(FileUtils::tryLoadFile).map(ObjectUtils::asProperties).orElseGet(Properties::new);
    }

    protected static String getEnvironment() {
        return Optional.ofNullable(System.getenv("ENVIRONMENT")).or(() -> Optional.ofNullable(System.getenv("environment"))).or(() -> Optional.ofNullable(System.getProperty("ENVIRONMENT"))).or(() -> Optional.ofNullable(System.getProperty("environment"))).orElse(null);
    }
}

