/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.caching;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.caching.CacheEvictionEvent;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Cache
extends AutoCloseable {
    public Object put(Object var1, Object var2);

    public Object putIfAbsent(Object var1, Object var2);

    public <T> T computeIfAbsent(Object var1, Function<? super Object, T> var2);

    public <T> T computeIfPresent(Object var1, BiFunction<? super Object, ? super T, ? extends T> var2);

    public <T> T compute(Object var1, BiFunction<? super Object, ? super T, ? extends T> var2);

    public <T> T get(Object var1);

    default public <T> T getOrDefault(Object id, T defaultValue) {
        return Optional.ofNullable(this.get(id)).orElse(defaultValue);
    }

    public boolean containsKey(Object var1);

    public <T> T remove(Object var1);

    public void clear();

    public int size();

    default public boolean isEmpty() {
        return this.size() < 1;
    }

    public Registration registerEvictionListener(Consumer<CacheEvictionEvent> var1);

    @Override
    public void close();
}

