/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.caching;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.caching.Cache;
import io.fluxcapacitor.common.caching.CacheEvictionEvent;
import java.beans.ConstructorProperties;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.NonNull;

public class NamedCache
implements Cache {
    private final Cache delegate;
    private final UnaryOperator<Object> idFunction;

    @Override
    public Object put(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.delegate.put(this.idFunction.apply(id), value);
    }

    @Override
    public Object putIfAbsent(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.delegate.putIfAbsent(this.idFunction.apply(id), value);
    }

    @Override
    public <T> T computeIfAbsent(Object id, Function<? super Object, T> mappingFunction) {
        return this.delegate.computeIfAbsent(this.idFunction.apply(id), mappingFunction);
    }

    @Override
    public <T> T computeIfPresent(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return this.delegate.computeIfPresent(this.idFunction.apply(id), mappingFunction);
    }

    @Override
    public <T> T compute(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return this.delegate.compute(this.idFunction.apply(id), mappingFunction);
    }

    @Override
    public <T> T get(Object id) {
        return this.delegate.get(this.idFunction.apply(id));
    }

    @Override
    public boolean containsKey(Object id) {
        return this.delegate.containsKey(this.idFunction.apply(id));
    }

    @Override
    public <T> T remove(Object id) {
        return this.delegate.remove(this.idFunction.apply(id));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Registration registerEvictionListener(Consumer<CacheEvictionEvent> listener) {
        return this.delegate.registerEvictionListener(listener);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @ConstructorProperties(value={"delegate", "idFunction"})
    public NamedCache(Cache delegate, UnaryOperator<Object> idFunction) {
        this.delegate = delegate;
        this.idFunction = idFunction;
    }
}

