/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.handling;

import java.lang.reflect.Executable;
import java.util.Optional;
import lombok.NonNull;

@FunctionalInterface
public interface MessageFilter<M> {
    public boolean test(M var1, Executable var2);

    default public Optional<Class<?>> getLeastSpecificAllowedClass(Executable executable) {
        return Optional.empty();
    }

    default public MessageFilter<M> and(final @NonNull MessageFilter<? super M> second) {
        if (second == null) {
            throw new NullPointerException("second is marked non-null but is null");
        }
        final MessageFilter first = this;
        return new MessageFilter<M>(this){

            @Override
            public boolean test(M m, Executable e) {
                return first.test(m, e) && second.test(m, e);
            }

            @Override
            public Optional<Class<?>> getLeastSpecificAllowedClass(Executable executable) {
                return first.getLeastSpecificAllowedClass(executable).or(() -> second.getLeastSpecificAllowedClass(executable));
            }
        };
    }
}

