/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.tracking;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.ThrowingRunnable;
import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.common.tracking.TaskScheduler;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTaskScheduler
implements TaskScheduler {
    private static final Logger log = LoggerFactory.getLogger(InMemoryTaskScheduler.class);
    private final ScheduledExecutorService executorService;
    private final Set<Task> tasks = new CopyOnWriteArraySet<Task>();

    public InMemoryTaskScheduler() {
        this("InMemoryScheduler");
    }

    public InMemoryTaskScheduler(String threadName) {
        this(100, threadName);
    }

    public InMemoryTaskScheduler(int delay, String threadName) {
        this.executorService = Executors.newSingleThreadScheduledExecutor(ObjectUtils.newThreadFactory(threadName));
        this.executorService.scheduleWithFixedDelay(this::executeExpiredTasks, delay, delay, TimeUnit.MILLISECONDS);
    }

    private void executeExpiredTasks() {
        this.tasks.forEach(task -> {
            if (TimingUtils.isMissedDeadline(task.deadline) && this.tasks.remove(task)) {
                try {
                    task.runnable.run();
                }
                catch (Throwable e) {
                    log.error("Failed to execute scheduled task", e);
                }
            }
        });
    }

    @Override
    public Registration schedule(long deadline, ThrowingRunnable task) {
        Task schedulerTask = new Task(task, deadline);
        this.tasks.add(schedulerTask);
        return () -> this.tasks.remove(schedulerTask);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    private static class Task {
        private final ThrowingRunnable runnable;
        private final long deadline;

        public Task(ThrowingRunnable runnable, long deadline) {
            this.runnable = runnable;
            this.deadline = deadline;
        }
    }
}

