/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.common.tracking;

import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.api.tracking.Position;
import io.fluxcapacitor.common.tracking.Tracker;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Consumer;

public final class SimpleTracker
implements Tracker {
    private final String consumerName;
    private final int maxSize;
    private final Consumer<MessageBatch> handler;
    private final long maxTimeout = 6000L;
    private final long deadline = System.currentTimeMillis() + 6000L;
    private final Long lastTrackerIndex;

    public SimpleTracker(String consumerName, int maxSize, Consumer<MessageBatch> handler) {
        this(consumerName, maxSize, handler, 0L);
    }

    @Override
    public boolean ignoreSegment() {
        return false;
    }

    @Override
    public boolean clientControlledIndex() {
        return false;
    }

    @Override
    public String getTrackerId() {
        return this.consumerName;
    }

    @Override
    public String getClientId() {
        return this.consumerName;
    }

    @Override
    public Long getPurgeDelay() {
        return null;
    }

    @Override
    public void send(MessageBatch batch, Position position) {
        this.handler.accept(batch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTracker that = (SimpleTracker)o;
        return Objects.equals(this.consumerName, that.consumerName);
    }

    public int hashCode() {
        return Objects.hash(this.consumerName);
    }

    public String toString() {
        return "SimpleTracker{consumerName='" + this.consumerName + "'}";
    }

    private static int $default$maxSize() {
        return 1024;
    }

    private static Long $default$lastTrackerIndex() {
        return 0L;
    }

    public static SimpleTrackerBuilder builder() {
        return new SimpleTrackerBuilder();
    }

    public SimpleTrackerBuilder toBuilder() {
        return new SimpleTrackerBuilder().consumerName(this.consumerName).maxSize(this.maxSize).handler(this.handler).lastTrackerIndex(this.lastTrackerIndex);
    }

    @Override
    public String getConsumerName() {
        return this.consumerName;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    public Consumer<MessageBatch> getHandler() {
        return this.handler;
    }

    @Override
    public long maxTimeout() {
        return this.maxTimeout;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public Long getLastTrackerIndex() {
        return this.lastTrackerIndex;
    }

    @ConstructorProperties(value={"consumerName", "maxSize", "handler", "lastTrackerIndex"})
    public SimpleTracker(String consumerName, int maxSize, Consumer<MessageBatch> handler, Long lastTrackerIndex) {
        this.consumerName = consumerName;
        this.maxSize = maxSize;
        this.handler = handler;
        this.lastTrackerIndex = lastTrackerIndex;
    }

    @Override
    public SimpleTracker withLastTrackerIndex(Long lastTrackerIndex) {
        return this.lastTrackerIndex == lastTrackerIndex ? this : new SimpleTracker(this.consumerName, this.maxSize, this.handler, lastTrackerIndex);
    }

    public static class SimpleTrackerBuilder {
        private String consumerName;
        private boolean maxSize$set;
        private int maxSize$value;
        private Consumer<MessageBatch> handler;
        private boolean lastTrackerIndex$set;
        private Long lastTrackerIndex$value;

        SimpleTrackerBuilder() {
        }

        public SimpleTrackerBuilder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public SimpleTrackerBuilder maxSize(int maxSize) {
            this.maxSize$value = maxSize;
            this.maxSize$set = true;
            return this;
        }

        public SimpleTrackerBuilder handler(Consumer<MessageBatch> handler) {
            this.handler = handler;
            return this;
        }

        public SimpleTrackerBuilder lastTrackerIndex(Long lastTrackerIndex) {
            this.lastTrackerIndex$value = lastTrackerIndex;
            this.lastTrackerIndex$set = true;
            return this;
        }

        public SimpleTracker build() {
            int maxSize$value = this.maxSize$value;
            if (!this.maxSize$set) {
                maxSize$value = SimpleTracker.$default$maxSize();
            }
            Long lastTrackerIndex$value = this.lastTrackerIndex$value;
            if (!this.lastTrackerIndex$set) {
                lastTrackerIndex$value = SimpleTracker.$default$lastTrackerIndex();
            }
            return new SimpleTracker(this.consumerName, maxSize$value, this.handler, lastTrackerIndex$value);
        }

        public String toString() {
            return "SimpleTracker.SimpleTrackerBuilder(consumerName=" + this.consumerName + ", maxSize$value=" + this.maxSize$value + ", handler=" + String.valueOf(this.handler) + ", lastTrackerIndex$value=" + this.lastTrackerIndex$value + ")";
        }
    }
}

