/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common;

import io.fluxcapacitor.common.MemoizingBiFunction;
import io.fluxcapacitor.common.MemoizingFunction;
import io.fluxcapacitor.common.MemoizingSupplier;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.ThrowingRunnable;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.modeling.SearchParameters;
import io.fluxcapacitor.javaclient.modeling.Searchable;
import io.fluxcapacitor.javaclient.tracking.TrackSelf;
import io.fluxcapacitor.javaclient.tracking.handling.LocalHandler;
import java.lang.reflect.Executable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);
    private static final BiFunction<Class<?>, Executable, Optional<LocalHandler>> localHandlerCache = ClientUtils.memoize((T target, U method) -> ReflectionUtils.getAnnotation(method, LocalHandler.class).or(() -> Optional.ofNullable((LocalHandler)ReflectionUtils.getTypeAnnotation(target, LocalHandler.class))).or(() -> ReflectionUtils.getPackageAnnotation(target.getPackage(), LocalHandler.class)));
    private static final BiFunction<Class<?>, Executable, Optional<TrackSelf>> trackSelfCache = ClientUtils.memoize((T target, U method) -> ReflectionUtils.getAnnotation(method, TrackSelf.class).or(() -> Optional.ofNullable((TrackSelf)ReflectionUtils.getTypeAnnotation(target, TrackSelf.class))).or(() -> ReflectionUtils.getPackageAnnotation(target.getPackage(), TrackSelf.class)));
    private static final Function<Class<?>, SearchParameters> searchParametersCache = ClientUtils.memoize((K type2) -> ReflectionUtils.getAnnotationAs(type2, Searchable.class, SearchParameters.class).map(p -> p.getCollection() == null ? p.withCollection(type2.getSimpleName()) : p).orElseGet(() -> new SearchParameters(true, type2.getSimpleName(), null, null)));

    public static void waitForResults(Duration maxDuration, Collection<? extends Future<?>> futures) {
        Instant deadline = Instant.now().plus(maxDuration);
        for (Future<?> f : futures) {
            try {
                f.get(Math.max(0L, Duration.between(Instant.now(), deadline).toMillis()), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Thread was interrupted before receiving all expected results", e);
                return;
            }
            catch (TimeoutException e) {
                log.warn("Timed out before having received all expected results", e);
                return;
            }
            catch (ExecutionException executionException) {
            }
        }
    }

    public static void tryRun(Runnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            log.warn("Task {} failed", (Object)task, (Object)e);
        }
    }

    public static void runSilently(ThrowingRunnable runnable) {
        runnable.run();
    }

    public static boolean isSelfTracking(Class<?> target, Executable method) {
        return trackSelfCache.apply(target, method).isPresent();
    }

    public static Optional<TrackSelf> getTrackSelfAnnotation(Class<?> target, Executable method) {
        return trackSelfCache.apply(target, method);
    }

    public static Optional<LocalHandler> getLocalHandlerAnnotation(Class<?> target, Executable method) {
        return localHandlerCache.apply(target, method);
    }

    public static boolean isLocalHandler(Class<?> target, Executable method) {
        return ClientUtils.getLocalHandlerAnnotation(target, method).map(LocalHandler::value).orElse(false);
    }

    public static boolean isLocalHandler(HandlerInvoker invoker) {
        return invoker.getMethod() != null && ClientUtils.isLocalHandler(invoker.getTargetClass(), invoker.getMethod());
    }

    public static boolean isTrackingHandler(Class<?> target, Executable method) {
        return ClientUtils.getLocalHandlerAnnotation(target, method).map(l -> !l.value() || l.allowExternalMessages()).orElse(true);
    }

    public static <T> MemoizingSupplier<T> memoize(Supplier<T> supplier) {
        return ObjectUtils.memoize(supplier);
    }

    public static <K, V> MemoizingFunction<K, V> memoize(Function<K, V> supplier) {
        return ObjectUtils.memoize(supplier);
    }

    public static <T, U, R> MemoizingBiFunction<T, U, R> memoize(BiFunction<T, U, R> supplier) {
        return ObjectUtils.memoize(supplier);
    }

    public static <T> MemoizingSupplier<T> memoize(Supplier<T> supplier, Duration lifespan) {
        return new MemoizingSupplier<T>(supplier, lifespan, FluxCapacitor::currentClock);
    }

    public static <K, V> MemoizingFunction<K, V> memoize(Function<K, V> supplier, Duration lifespan) {
        return new MemoizingFunction<K, V>(supplier, lifespan, FluxCapacitor::currentClock);
    }

    public static <T, U, R> MemoizingBiFunction<T, U, R> memoize(BiFunction<T, U, R> supplier, Duration lifespan) {
        return new MemoizingBiFunction<T, U, R>(supplier, lifespan, FluxCapacitor::currentClock);
    }

    public static SearchParameters getSearchParameters(Class<?> type2) {
        return searchParametersCache.apply(type2);
    }
}

