/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.casting;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.reflection.DefaultMemberInvoker;
import io.fluxcapacitor.common.reflection.MemberInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.serialization.DeserializationException;
import io.fluxcapacitor.javaclient.common.serialization.casting.AnnotatedCaster;
import io.fluxcapacitor.javaclient.common.serialization.casting.Cast;
import io.fluxcapacitor.javaclient.common.serialization.casting.CastParameters;
import io.fluxcapacitor.javaclient.common.serialization.casting.CasterChain;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CastInspector {
    public static boolean hasCasterMethods(Class<?> type2) {
        return ReflectionUtils.getAllMethods(type2).stream().anyMatch(m -> ReflectionUtils.has(Cast.class, m));
    }

    public static <T> List<AnnotatedCaster<T>> getCasters(Class<? extends Annotation> castAnnotation, Collection<?> candidateTargets, Class<T> dataType, Comparator<AnnotatedCaster<?>> casterComparator) {
        ArrayList result = new ArrayList();
        for (Object caster : candidateTargets) {
            ReflectionUtils.getAllMethods(caster.getClass()).forEach(m -> CastInspector.createCaster(caster, m, dataType, castAnnotation).ifPresent(result::add));
        }
        result.sort(casterComparator);
        return result;
    }

    private static <T> Optional<AnnotatedCaster<T>> createCaster(Object target, Method m, Class<T> dataType, Class<? extends Annotation> castAnnotation) {
        if (!ReflectionUtils.has(castAnnotation, m)) {
            return Optional.empty();
        }
        return ReflectionUtils.getAnnotationAs(m, Cast.class, CastParameters.class).map(params -> CastInspector.createCaster(params, m, target, dataType));
    }

    private static <T> AnnotatedCaster<T> createCaster(CastParameters castParameters, Method method, Object target, Class<T> dataType) {
        if (ReflectionUtils.ensureAccessible(method).getReturnType().equals(Void.TYPE)) {
            return new AnnotatedCaster(method, castParameters, i -> Stream.empty());
        }
        Function invokeFunction = CastInspector.invokeFunction(method, target, dataType);
        BiFunction resultMapper = CastInspector.mapResult(castParameters, method, dataType);
        return new AnnotatedCaster(method, castParameters, d -> (Stream)resultMapper.apply((SerializedObject)d, () -> invokeFunction.apply((SerializedObject)d)));
    }

    private static <T> Function<SerializedObject<T, ?>, Object> invokeFunction(Method method, Object target, Class<T> dataType) {
        List<Function> parameterFunctions = Arrays.stream(method.getGenericParameterTypes()).map(pt -> {
            if (pt instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)pt;
                if (parameterizedType.getRawType().equals(Data.class) && dataType.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0])) {
                    return SerializedObject::data;
                }
                if (dataType.isAssignableFrom((Class)parameterizedType.getRawType())) {
                    return s -> s.data().getValue();
                }
            } else if (pt instanceof Class) {
                Class c = (Class)pt;
                if (dataType.isAssignableFrom(c)) {
                    return s -> s.data().getValue();
                }
                if (SerializedMessage.class.isAssignableFrom(c)) {
                    return s -> {
                        SerializedMessage m;
                        CasterChain.ConvertingSerializedObject i;
                        SerializedObject<byte[], ?> patt0$temp;
                        return s instanceof CasterChain.ConvertingSerializedObject && (patt0$temp = (i = (CasterChain.ConvertingSerializedObject)s).getSource()) instanceof SerializedMessage ? (m = (SerializedMessage)patt0$temp) : null;
                    };
                }
            }
            throw new DeserializationException(String.format("Parameter in upcaster method '%s' is of unexpected type. Expected Data<%s> or %s.", method, dataType.getName(), dataType.getName()));
        }).toList();
        MemberInvoker invoker = DefaultMemberInvoker.asInvoker(method);
        try {
            return s -> invoker.invoke(target, parameterFunctions.size(), i -> ((Function)parameterFunctions.get(i)).apply(s));
        }
        catch (Throwable e) {
            throw new DeserializationException("Exception while upcasting using method: " + String.valueOf(invoker.getMember()), e);
        }
    }

    private static <T> BiFunction<SerializedObject<T, ?>, Supplier<Object>, Stream<SerializedObject<T, ?>>> mapResult(CastParameters annotation, Method method, Class<T> dataType) {
        if (dataType.isAssignableFrom(method.getReturnType())) {
            return (s, o) -> Stream.of(s.withData(new Data(o, annotation.type(), annotation.revision() + annotation.revisionDelta(), s.data().getFormat())));
        }
        if (method.getReturnType().equals(Data.class)) {
            return (s, o) -> Stream.of(s.withData((Data)o.get()));
        }
        if (method.getReturnType().equals(Optional.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            Type type2 = parameterizedType.getActualTypeArguments()[0];
            if (type2 instanceof Class) {
                Class typeParameter = (Class)type2;
                if (dataType.isAssignableFrom(typeParameter)) {
                    return (s, o) -> {
                        Optional result = (Optional)o.get();
                        return result.stream().map(t -> s.withData(new Data<Object>(t, annotation.type(), annotation.revision() + annotation.revisionDelta(), s.data().getFormat())));
                    };
                }
            } else if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && ((ParameterizedType)parameterizedType.getActualTypeArguments()[0]).getRawType().equals(Data.class)) {
                return (s, o) -> ((Optional)o.get()).stream().map(s::withData);
            }
        }
        if (method.getReturnType().equals(Stream.class)) {
            return (s, o) -> ((Stream)o.get()).map(s::withData);
        }
        throw new DeserializationException(String.format("Unexpected return type of upcaster method '%s'. Expected Data<%s>, %s, Optional<Data<%s>>, Optional<%s>, Stream<Data<%s>> or void", method, dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName(), dataType.getName()));
    }
}

