/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.spring;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringBeanParameterResolver
implements ParameterResolver<Object> {
    private static final Logger log = LoggerFactory.getLogger(SpringBeanParameterResolver.class);
    private final Function<Parameter, UnaryOperator<Object>> resolverFunction = ObjectUtils.memoize(this::computeParameterResolver);
    private final ApplicationContext applicationContext;

    public UnaryOperator<Object> resolve(Parameter p, Annotation methodAnnotation) {
        return this.resolverFunction.apply(p);
    }

    @Override
    public boolean matches(Parameter parameter, Annotation methodAnnotation, Object value) {
        return ReflectionUtils.has(Autowired.class, parameter);
    }

    protected UnaryOperator<Object> computeParameterResolver(Parameter p) {
        String[] beanNames = this.applicationContext.getBeanNamesForType(p.getType());
        return switch (beanNames.length) {
            case 0 -> v -> null;
            case 1 -> {
                String beanName = beanNames[0];
                yield v -> this.applicationContext.getAutowireCapableBeanFactory().getBean(beanName);
            }
            default -> {
                AutowireCapableBeanFactory var4_5 = this.applicationContext.getAutowireCapableBeanFactory();
                if (var4_5 instanceof ConfigurableListableBeanFactory) {
                    ConfigurableListableBeanFactory f = (ConfigurableListableBeanFactory)var4_5;
                    Qualifier qualifier = p.getAnnotation(Qualifier.class);
                    if (qualifier != null) {
                        for (String beanName : beanNames) {
                            if (!BeanFactoryAnnotationUtils.isQualifierMatch(qualifier.value()::equals, (String)beanName, (BeanFactory)f)) continue;
                            yield v -> f.getBean(beanName);
                        }
                    }
                    for (String beanName : beanNames) {
                        if (!f.containsBeanDefinition(beanName) || !f.getBeanDefinition(beanName).isPrimary()) continue;
                        yield v -> f.getBean(beanName);
                    }
                }
                log.warn("{} beans of type {} were detected. However, none of them were designated as primary, and the parameter lacks @Qualifier. Consequently, this parameter will not be injected.", (Object)beanNames.length, (Object)p.getType().getSimpleName());
                yield v -> null;
            }
        };
    }

    @ConstructorProperties(value={"applicationContext"})
    public SpringBeanParameterResolver(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

