/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.spring;

import io.fluxcapacitor.javaclient.configuration.spring.FluxPrototype;
import io.fluxcapacitor.javaclient.tracking.TrackSelf;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class TrackSelfPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(TrackSelfPostProcessor.class);
    private Environment environment;

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            throw new NullPointerException("beanFactory is marked non-null but is null");
        }
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            log.warn("Cannot register Spring beans dynamically! @TrackSelf annotations will be ignored.");
            return;
        }
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(this, false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isIndependent();
            }
        };
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(TrackSelf.class));
        Arrays.stream(beanFactory.getBeanNamesForAnnotation(ComponentScan.class)).map(arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getType(arg_0)).filter(Objects::nonNull).flatMap(c -> {
            List basePackages = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)c, ComponentScan.class).stream().flatMap(scan -> Stream.concat(Arrays.stream(scan.basePackages()), Arrays.stream(scan.basePackageClasses()).map(Class::getPackageName))).distinct().toList();
            if (basePackages.isEmpty()) {
                return Stream.of(c.getPackageName());
            }
            return basePackages.stream();
        }).flatMap(p -> {
            Set candidateComponents = provider.findCandidateComponents(p);
            return candidateComponents.stream();
        }).map(this::extractBeanClass).filter(Objects::nonNull).distinct().forEach(type2 -> {
            FluxPrototype prototype = new FluxPrototype((Class<?>)type2);
            registry.registerBeanDefinition(type2.getName() + "$$SelfTracked", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(FluxPrototype.class, () -> prototype).getBeanDefinition());
        });
    }

    protected Class<?> extractBeanClass(BeanDefinition beanDefinition) {
        try {
            return ((ScannedGenericBeanDefinition)beanDefinition).resolveBeanClass(Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void postProcessBeanDefinitionRegistry(@NonNull BeanDefinitionRegistry registry) throws BeansException {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

