/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.HasMetadata;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.Aggregate;
import io.fluxcapacitor.javaclient.modeling.AssertLegal;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityHelper;
import io.fluxcapacitor.javaclient.modeling.HasEntity;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.Apply;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.InterceptApply;
import io.fluxcapacitor.javaclient.tracking.handling.Invocation;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public class DefaultEntityHelper
implements EntityHelper {
    private static final Aggregate defaultAggregateAnnotation = DefaultAggregate.class.getAnnotation(Aggregate.class);
    private static final Function<Class<?>, Aggregate> annotationCache = ObjectUtils.memoize(type2 -> Optional.ofNullable((Aggregate)ReflectionUtils.getTypeAnnotation(type2, Aggregate.class)).orElse(defaultAggregateAnnotation));
    private final Function<Class<?>, HandlerMatcher<Object, HasMessage>> interceptMatchers = ObjectUtils.memoize(type2 -> HandlerInspector.inspect(type2, parameterResolvers, InterceptApply.class));
    private final Function<Class<?>, HandlerMatcher<Object, DeserializingMessage>> applyMatchers = ObjectUtils.memoize(type2 -> HandlerInspector.inspect(type2, parameterResolvers, Apply.class));
    private final Function<Class<?>, HandlerMatcher<Object, HasMessage>> assertLegalMatchers = ObjectUtils.memoize(type2 -> HandlerInspector.inspect(type2, parameterResolvers, HandlerConfiguration.builder().methodAnnotation(AssertLegal.class).invokeMultipleMethods(true).build()));
    private final boolean disablePayloadValidation;

    public static Aggregate getRootAnnotation(Class<?> type2) {
        return annotationCache.apply(type2);
    }

    public DefaultEntityHelper(List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, boolean disablePayloadValidation) {
        this.disablePayloadValidation = disablePayloadValidation;
    }

    @Override
    public Stream<?> intercept(Object value, Entity<?> entity) {
        Object payload = Optional.ofNullable(DeserializingMessage.getCurrent()).map(DeserializingMessage::getMetadata).map(currentMetadata -> {
            if (value instanceof HasMessage) {
                Message result = Message.asMessage(value);
                return result.withMetadata(currentMetadata.with(result.getMetadata()));
            }
            return new Message(value, (Metadata)currentMetadata);
        }).orElse(value);
        MessageWithEntity m = new MessageWithEntity(payload, entity);
        return this.getInterceptInvoker(m).map(i -> ObjectUtils.asStream(i.invoke()).flatMap(v -> {
            Message message = Message.asMessage(v);
            if ((message = message.withMetadata(m.getMetadata().with(message.getMetadata()))).getPayloadClass().equals(m.getPayloadClass())) {
                return Stream.of(message);
            }
            return this.intercept(message, entity);
        })).orElseGet(() -> Stream.of(value));
    }

    protected Optional<HandlerInvoker> getInterceptInvoker(MessageWithEntity m) {
        return this.interceptMatchers.apply(m.getPayloadClass()).getInvoker(m.getPayload(), m).or(() -> {
            for (Entity<?> child : m.getEntity().possibleTargets(m.getPayload())) {
                Optional<HandlerInvoker> childInvoker = this.getInterceptInvoker(m.withEntity(child));
                if (!childInvoker.isPresent()) continue;
                return childInvoker;
            }
            return Optional.empty();
        });
    }

    @Override
    public Optional<HandlerInvoker> applyInvoker(DeserializingMessage event, final Entity<?> entity) {
        final DeserializingMessageWithEntity message = new DeserializingMessageWithEntity(event, entity);
        Class<?> entityType = entity.type();
        return this.applyMatchers.apply(entityType).getInvoker(entity.get(), message).or(() -> this.applyMatchers.apply(message.getPayloadClass()).getInvoker(message.getPayload(), message).filter(i -> {
            if (i.getMethod() instanceof Method) {
                Class<?> returnType = ((Method)i.getMethod()).getReturnType();
                return entityType.isAssignableFrom(returnType) || returnType.isAssignableFrom(entityType) || returnType.equals(Void.TYPE);
            }
            return false;
        })).map(i -> new HandlerInvoker.DelegatingHandlerInvoker(this, (HandlerInvoker)i){

            @Override
            public Object invoke(BiFunction<Object, Object, Object> combiner) {
                return message.apply(m -> {
                    boolean wasApplying = Entity.isApplying();
                    try {
                        Entity.applying.set(true);
                        Object result = this.delegate.invoke();
                        if (result == null && !this.delegate.expectResult()) {
                            Object t = entity.get();
                            return t;
                        }
                        Object object = result;
                        return object;
                    }
                    finally {
                        Entity.applying.set(wasApplying);
                    }
                });
            }
        });
    }

    @Override
    public <E extends Exception> void assertLegal(Object value, Entity<?> entity) throws E {
        this.assertLegal(value, entity, false);
        Invocation.whenHandlerCompletes((r, e) -> {
            if (e == null) {
                this.assertLegal(value, entity, true);
            }
        });
    }

    private void assertLegal(Object value, Entity<?> entity, boolean afterHandler) {
        Object object;
        if (value == null) {
            return;
        }
        if (!this.disablePayloadValidation && !afterHandler) {
            Object object2;
            if (value instanceof HasMessage) {
                HasMessage hasMessage = (HasMessage)value;
                object2 = hasMessage.getPayload();
            } else {
                object2 = value;
            }
            ValidationUtils.assertValid(object2, new Class[0]);
        }
        if (value instanceof HasMessage) {
            HasMessage hasMessage = (HasMessage)value;
            object = hasMessage.getPayload();
        } else {
            object = value;
        }
        Object payload = object;
        this.assertLegalValue(payload.getClass(), payload, value, entity, afterHandler);
        entity.possibleTargets(payload).forEach(e -> this.assertLegalValue(payload.getClass(), payload, value, (Entity<?>)e, afterHandler));
        this.assertLegalValue(entity.type(), entity.get(), value, entity, afterHandler);
        entity.possibleTargets(payload).forEach(e -> this.assertLegalValue(e.type(), e.get(), value, (Entity<?>)e, afterHandler));
    }

    private void assertLegalValue(Class<?> targetType, Object target, Object value, Entity<?> entity, boolean afterHandler) {
        if (value == null) {
            return;
        }
        MessageWithEntity message = new MessageWithEntity(value, entity);
        HashSet<Object> additionalProperties = new HashSet<Object>(ReflectionUtils.getAnnotatedPropertyValues(target, AssertLegal.class));
        this.assertLegalMatchers.apply(targetType).getInvoker(target, message).filter(i -> ReflectionUtils.getAnnotation(i.getMethod(), AssertLegal.class).map(a -> a.afterHandler() == afterHandler).orElse(false)).ifPresent(s -> {
            Object additionalObject = s.invoke();
            if (additionalObject instanceof Collection) {
                additionalProperties.addAll((Collection)additionalObject);
            } else {
                additionalProperties.add(additionalObject);
            }
        });
        additionalProperties.stream().filter(Objects::nonNull).forEach(p -> this.assertLegalValue(p.getClass(), p, value, entity, afterHandler));
    }

    @Override
    public <E extends Exception> Optional<E> checkLegality(Object value, Entity<?> entity) {
        try {
            this.assertLegal(value, entity);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    @Override
    public boolean isLegal(Object value, Entity<?> entity) {
        return this.checkLegality(value, entity).isEmpty();
    }

    protected static final class MessageWithEntity
    implements HasMessage,
    HasEntity {
        private final Entity<?> entity;
        private final Object payload;

        public MessageWithEntity(Object payload, Entity<?> entity) {
            this.payload = payload;
            this.entity = entity;
        }

        public MessageWithEntity withEntity(Entity<?> entity) {
            return new MessageWithEntity(this.payload, entity);
        }

        @Override
        public Metadata getMetadata() {
            return this.payload instanceof HasMetadata ? ((HasMetadata)this.payload).getMetadata() : Metadata.empty();
        }

        @Override
        public Message toMessage() {
            return Message.asMessage(this.payload);
        }

        @Override
        public <R> R getPayload() {
            return (R)(this.payload instanceof HasMessage ? ((HasMessage)this.payload).getPayload() : this.payload);
        }

        @Override
        public Entity<?> getEntity() {
            return this.entity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageWithEntity)) {
                return false;
            }
            MessageWithEntity other = (MessageWithEntity)o;
            Entity<?> this$entity = this.getEntity();
            Entity<?> other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            Object this$payload = this.getPayload();
            Object other$payload = other.getPayload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Entity<?> $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            Object $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultEntityHelper.MessageWithEntity(entity=" + String.valueOf(this.getEntity()) + ", payload=" + String.valueOf(this.getPayload()) + ")";
        }
    }

    protected static final class DeserializingMessageWithEntity
    extends DeserializingMessage
    implements HasEntity {
        private final Entity<?> entity;

        public DeserializingMessageWithEntity(DeserializingMessage message, Entity<?> entity) {
            super(message);
            this.entity = entity;
        }

        @Override
        public Entity<?> getEntity() {
            return this.entity;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeserializingMessageWithEntity)) {
                return false;
            }
            DeserializingMessageWithEntity other = (DeserializingMessageWithEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Entity<?> this$entity = this.getEntity();
            Entity<?> other$entity = other.getEntity();
            return !(this$entity == null ? other$entity != null : !this$entity.equals(other$entity));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof DeserializingMessageWithEntity;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Entity<?> $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DefaultEntityHelper.DeserializingMessageWithEntity(entity=" + String.valueOf(this.getEntity()) + ")";
        }
    }

    @Aggregate
    static class DefaultAggregate {
        DefaultAggregate() {
        }
    }
}

