/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.keyvalue.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.BooleanResult;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.keyvalue.DeleteValue;
import io.fluxcapacitor.common.api.keyvalue.GetValue;
import io.fluxcapacitor.common.api.keyvalue.GetValueResult;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import io.fluxcapacitor.common.api.keyvalue.StoreValueIfAbsent;
import io.fluxcapacitor.common.api.keyvalue.StoreValues;
import io.fluxcapacitor.common.api.keyvalue.StoreValuesAndWait;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import jakarta.websocket.ClientEndpoint;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ClientEndpoint
public class WebsocketKeyValueClient
extends AbstractWebsocketClient
implements KeyValueClient {
    public WebsocketKeyValueClient(String endPointUrl, WebSocketClient client) {
        this(URI.create(endPointUrl), client);
    }

    public WebsocketKeyValueClient(URI endpointUri, WebSocketClient client) {
        this(endpointUri, client, true);
    }

    public WebsocketKeyValueClient(URI endpointUri, WebSocketClient client, boolean sendMetrics) {
        super(endpointUri, client, sendMetrics, client.getClientConfig().getKeyValueSessions());
    }

    @Override
    public CompletableFuture<Void> putValue(String key, Data<byte[]> value, Guarantee guarantee) {
        return switch (guarantee) {
            case Guarantee.NONE, Guarantee.SENT -> this.sendCommand(new StoreValues(List.of(new KeyValuePair(key, value)), guarantee));
            default -> this.sendCommand(new StoreValuesAndWait(List.of(new KeyValuePair(key, value))));
        };
    }

    @Override
    public CompletableFuture<Boolean> putValueIfAbsent(String key, Data<byte[]> value) {
        return this.send(new StoreValueIfAbsent(new KeyValuePair(key, value))).thenApply(r -> ((BooleanResult)r).isSuccess());
    }

    @Override
    public Data<byte[]> getValue(String key) {
        GetValueResult result = (GetValueResult)this.sendAndWait(new GetValue(key));
        return result.getValue();
    }

    @Override
    public CompletableFuture<Void> deleteValue(String key, Guarantee guarantee) {
        return this.sendCommand(new DeleteValue(key, guarantee));
    }
}

