/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.search.CreateAuditTrail;
import io.fluxcapacitor.common.api.search.DocumentStats;
import io.fluxcapacitor.common.api.search.DocumentUpdate;
import io.fluxcapacitor.common.api.search.FacetEntry;
import io.fluxcapacitor.common.api.search.FacetStats;
import io.fluxcapacitor.common.api.search.GetDocument;
import io.fluxcapacitor.common.api.search.GetSearchHistogram;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InMemorySearchStore
implements SearchClient {
    protected static final Function<Document, String> identifier = d -> InMemorySearchStore.asIdentifier(d.getCollection(), d.getId());
    private final Map<String, Document> documents = new ConcurrentHashMap<String, Document>();

    protected static String asIdentifier(String collection, String documentId) {
        return collection + "/" + documentId;
    }

    @Override
    public CompletableFuture<Void> index(List<SerializedDocument> documents, Guarantee guarantee, boolean ifNotExists) {
        Map updates = documents.stream().map(SerializedDocument::deserializeDocument).collect(Collectors.toMap(identifier, Function.identity(), (a, b) -> b, LinkedHashMap::new));
        if (ifNotExists) {
            updates.keySet().removeAll(this.documents.keySet());
            this.documents.putAll(updates);
        } else {
            this.documents.putAll(updates);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Stream<SearchHit<SerializedDocument>> search(SearchDocuments searchDocuments, int fetchSize) {
        SearchQuery query = searchDocuments.getQuery();
        Stream<Document> documentStream = this.documents.values().stream().filter(query::matches);
        documentStream = documentStream.sorted(Document.createComparator(searchDocuments));
        if (!searchDocuments.getPathFilters().isEmpty()) {
            Predicate<Document.Path> pathFilter = searchDocuments.computePathFilter();
            documentStream = documentStream.map(d -> d.filterPaths(pathFilter));
        }
        if (searchDocuments.getSkip() > 0) {
            documentStream = documentStream.skip(searchDocuments.getSkip());
        }
        if (searchDocuments.getLastHit() != null) {
            documentStream = documentStream.dropWhile(d -> !d.getId().equals(searchDocuments.getLastHit().getId())).skip(1L);
        }
        if (searchDocuments.getMaxSize() != null) {
            documentStream = documentStream.limit(searchDocuments.getMaxSize().intValue());
        }
        return documentStream.map(d -> new SearchHit<SerializedDocument>(d.getId(), d.getCollection(), d.getTimestamp(), d.getEnd(), () -> new SerializedDocument((Document)d)));
    }

    @Override
    public Optional<SerializedDocument> fetch(GetDocument r) {
        return Optional.ofNullable(this.documents.get(InMemorySearchStore.asIdentifier(r.getCollection(), r.getId()))).map(SerializedDocument::new);
    }

    @Override
    public CompletableFuture<Void> delete(SearchQuery query, Guarantee guarantee) {
        this.documents.values().removeIf(query::matches);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> delete(String documentId, String collection, Guarantee guarantee) {
        this.documents.remove(InMemorySearchStore.asIdentifier(collection, documentId));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> createAuditTrail(CreateAuditTrail request) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> deleteCollection(String collection, Guarantee guarantee) {
        this.documents.values().removeIf(d -> Objects.equals(collection, d.getCollection()));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public List<DocumentStats> fetchStatistics(SearchQuery query, List<String> fields2, List<String> groupBy) {
        return DocumentStats.compute(this.documents.values().stream().filter(query::matches), fields2, groupBy);
    }

    @Override
    public SearchHistogram fetchHistogram(GetSearchHistogram request) {
        SearchQuery query = request.getQuery();
        List<Long> results = IntStream.range(0, request.getResolution()).mapToLong(i -> 0L).boxed().collect(Collectors.toList());
        if (query.getSince() == null) {
            return new SearchHistogram(query.getSince(), query.getBefore(), results);
        }
        if (query.getBefore() == null) {
            query = query.toBuilder().before(Instant.now()).build();
        }
        long min = query.getSince().toEpochMilli();
        long delta = query.getBefore().toEpochMilli() - min;
        long step = Math.min(1L, delta / (long)request.getResolution());
        this.search(SearchDocuments.builder().query(query).build(), -1).map(h -> ((SerializedDocument)h.getValue()).deserializeDocument()).collect(Collectors.groupingBy(d -> (d.getTimestamp().toEpochMilli() - min) / step)).forEach((bucket, hits) -> results.set(bucket.intValue(), Long.valueOf(hits.size())));
        return new SearchHistogram(query.getSince(), query.getBefore(), results);
    }

    @Override
    public List<FacetStats> fetchFacetStats(SearchQuery query) {
        return this.documents.values().stream().filter(query::matches).flatMap(d -> d.getFacets().stream()).collect(Collectors.groupingBy(Function.identity(), TreeMap::new, Collectors.toList())).values().stream().map(group -> {
            FacetEntry first = (FacetEntry)group.get(0);
            return new FacetStats(first.getName(), first.getValue(), group.size());
        }).sorted(Comparator.comparing(FacetStats::getCount).reversed()).toList();
    }

    @Override
    public CompletableFuture<Void> bulkUpdate(Collection<DocumentUpdate> updates, Guarantee guarantee) {
        updates.stream().collect(Collectors.groupingBy(DocumentUpdate::getType)).forEach((type2, list) -> {
            switch (type2) {
                case delete: {
                    list.forEach(u -> this.delete(u.getId(), u.getCollection(), guarantee));
                    break;
                }
                case index: {
                    this.index(list.stream().map(DocumentUpdate::getObject).toList(), guarantee, false);
                    break;
                }
                case indexIfNotExists: {
                    this.index(list.stream().map(DocumentUpdate::getObject).toList(), guarantee, true);
                }
            }
        });
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void close() {
    }
}

