/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.search.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.search.BulkUpdateDocuments;
import io.fluxcapacitor.common.api.search.CreateAuditTrail;
import io.fluxcapacitor.common.api.search.DeleteCollection;
import io.fluxcapacitor.common.api.search.DeleteDocumentById;
import io.fluxcapacitor.common.api.search.DeleteDocuments;
import io.fluxcapacitor.common.api.search.DocumentStats;
import io.fluxcapacitor.common.api.search.DocumentUpdate;
import io.fluxcapacitor.common.api.search.FacetStats;
import io.fluxcapacitor.common.api.search.GetDocument;
import io.fluxcapacitor.common.api.search.GetDocumentResult;
import io.fluxcapacitor.common.api.search.GetDocumentStats;
import io.fluxcapacitor.common.api.search.GetDocumentStatsResult;
import io.fluxcapacitor.common.api.search.GetFacetStats;
import io.fluxcapacitor.common.api.search.GetFacetStatsResult;
import io.fluxcapacitor.common.api.search.GetSearchHistogram;
import io.fluxcapacitor.common.api.search.GetSearchHistogramResult;
import io.fluxcapacitor.common.api.search.IndexDocuments;
import io.fluxcapacitor.common.api.search.SearchDocuments;
import io.fluxcapacitor.common.api.search.SearchDocumentsResult;
import io.fluxcapacitor.common.api.search.SearchHistogram;
import io.fluxcapacitor.common.api.search.SearchQuery;
import io.fluxcapacitor.common.api.search.SerializedDocument;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.persisting.search.SearchHit;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import jakarta.websocket.ClientEndpoint;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

@ClientEndpoint
public class WebSocketSearchClient
extends AbstractWebsocketClient
implements SearchClient {
    public WebSocketSearchClient(String endPointUrl, WebSocketClient client) {
        this(URI.create(endPointUrl), client);
    }

    public WebSocketSearchClient(URI endpointUri, WebSocketClient client) {
        this(endpointUri, client, true);
    }

    public WebSocketSearchClient(URI endpointUri, WebSocketClient client, boolean sendMetrics) {
        super(endpointUri, client, sendMetrics, client.getClientConfig().getSearchSessions());
    }

    @Override
    public CompletableFuture<Void> index(List<SerializedDocument> documents, Guarantee guarantee, boolean ifNotExists) {
        return this.sendCommand(new IndexDocuments(documents, ifNotExists, guarantee));
    }

    @Override
    public CompletableFuture<Void> bulkUpdate(Collection<DocumentUpdate> batch, Guarantee guarantee) {
        return this.sendCommand(new BulkUpdateDocuments(batch, guarantee));
    }

    @Override
    public Stream<SearchHit<SerializedDocument>> search(SearchDocuments searchDocuments, int fetchSize) {
        AtomicInteger count = new AtomicInteger();
        Integer maxSize = searchDocuments.getMaxSize();
        int maxFetchSize = maxSize == null ? fetchSize : Math.min(maxSize, fetchSize);
        SearchDocuments request = searchDocuments.toBuilder().maxSize(maxFetchSize).build();
        Stream<SearchHit> documentStream = ObjectUtils.iterate((SearchDocumentsResult)this.sendAndWait(request), result -> (SearchDocumentsResult)this.sendAndWait(request.toBuilder().maxSize(maxSize == null ? maxFetchSize : Math.min(maxSize - count.get(), maxFetchSize)).lastHit(result.lastMatch()).build()), result -> result.size() < maxFetchSize || maxSize != null && count.addAndGet(result.size()) >= maxSize).flatMap(r -> r.getMatches().stream());
        if (maxSize != null) {
            documentStream = documentStream.limit(maxSize.intValue());
        }
        return documentStream.map(d -> new SearchHit<SerializedDocument>(d.getId(), d.getCollection(), d.getTimestamp() == null ? null : Instant.ofEpochMilli(d.getTimestamp()), d.getEnd() == null ? null : Instant.ofEpochMilli(d.getEnd()), () -> d));
    }

    @Override
    public Optional<SerializedDocument> fetch(GetDocument request) {
        return Optional.ofNullable(((GetDocumentResult)this.sendAndWait(request)).getDocument());
    }

    @Override
    public List<DocumentStats> fetchStatistics(SearchQuery query, List<String> fields2, List<String> groupBy) {
        GetDocumentStatsResult result = (GetDocumentStatsResult)this.sendAndWait(new GetDocumentStats(query, fields2, groupBy));
        return result.getDocumentStats();
    }

    @Override
    public SearchHistogram fetchHistogram(GetSearchHistogram request) {
        GetSearchHistogramResult result = (GetSearchHistogramResult)this.sendAndWait(request);
        return result.getHistogram();
    }

    @Override
    public List<FacetStats> fetchFacetStats(SearchQuery query) {
        GetFacetStatsResult result = (GetFacetStatsResult)this.sendAndWait(new GetFacetStats(query));
        return result.getStats();
    }

    @Override
    public CompletableFuture<Void> delete(SearchQuery query, Guarantee guarantee) {
        return this.sendCommand(new DeleteDocuments(query, guarantee));
    }

    @Override
    public CompletableFuture<Void> delete(String documentId, String collection, Guarantee guarantee) {
        return this.sendCommand(new DeleteDocumentById(collection, documentId, guarantee));
    }

    @Override
    public CompletableFuture<Void> deleteCollection(String collection, Guarantee guarantee) {
        return this.sendCommand(new DeleteCollection(collection, guarantee));
    }

    @Override
    public CompletableFuture<Void> createAuditTrail(CreateAuditTrail request) {
        return this.sendCommand(request);
    }
}

