/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;

public class AdhocDispatchInterceptor
implements DispatchInterceptor {
    private static final ThreadLocal<Map<MessageType, DispatchInterceptor>> delegates = new ThreadLocal();

    public static Optional<? extends DispatchInterceptor> getAdhocInterceptor(MessageType messageType) {
        return Optional.ofNullable(delegates.get()).map(map -> (DispatchInterceptor)map.get((Object)messageType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runWithAdhocInterceptor(Callable<T> task, DispatchInterceptor adhocInterceptor, MessageType ... messageTypes) {
        Map<MessageType, DispatchInterceptor> previous = delegates.get();
        Map merged = Optional.ofNullable(previous).orElseGet(HashMap::new);
        Stream<MessageType> typeStream = messageTypes.length == 0 ? EnumSet.allOf(MessageType.class).stream() : Arrays.stream(messageTypes);
        typeStream.forEach(messageType -> merged.compute(messageType, (t, i) -> i == null ? adhocInterceptor : i.andThen(adhocInterceptor)));
        try {
            delegates.set(merged);
            T t = task.call();
            return t;
        }
        finally {
            delegates.set(previous);
        }
    }

    public static void runWithAdhocInterceptor(Runnable task, DispatchInterceptor adhocInterceptor, MessageType ... messageTypes) {
        AdhocDispatchInterceptor.runWithAdhocInterceptor(() -> {
            task.run();
            return null;
        }, adhocInterceptor, messageTypes);
    }

    @Override
    public Message interceptDispatch(Message message, MessageType messageType) {
        Optional<? extends DispatchInterceptor> adhocInterceptor = AdhocDispatchInterceptor.getAdhocInterceptor(messageType);
        return adhocInterceptor.isPresent() ? adhocInterceptor.get().interceptDispatch(message, messageType) : message;
    }

    @Override
    public void monitorDispatch(Message message, MessageType messageType) {
        AdhocDispatchInterceptor.getAdhocInterceptor(messageType).ifPresent(i -> i.monitorDispatch(message, messageType));
    }

    @Override
    public SerializedMessage modifySerializedMessage(SerializedMessage serializedMessage, Message message, MessageType messageType) {
        Optional<? extends DispatchInterceptor> adhocInterceptor = AdhocDispatchInterceptor.getAdhocInterceptor(messageType);
        return adhocInterceptor.isPresent() ? adhocInterceptor.get().modifySerializedMessage(serializedMessage, message, messageType) : serializedMessage;
    }
}

