/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.GenericGateway;
import io.fluxcapacitor.javaclient.publishing.RequestHandler;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import io.fluxcapacitor.javaclient.web.WebResponse;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenericGateway
implements GenericGateway {
    private static final Logger log = LoggerFactory.getLogger(DefaultGenericGateway.class);
    private final GatewayClient gatewayClient;
    private final RequestHandler requestHandler;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final MessageType messageType;
    private final HandlerRegistry localHandlerRegistry;
    private final Map<String, CompletableFuture<?>> callbacks = new ConcurrentHashMap();

    @Override
    public CompletableFuture<Void> sendAndForget(Guarantee guarantee, Message ... messages) {
        ArrayList<SerializedMessage> serializedMessages = new ArrayList<SerializedMessage>();
        for (Message message : messages) {
            if ((message = this.dispatchInterceptor.interceptDispatch(message, this.messageType)) == null) continue;
            this.dispatchInterceptor.monitorDispatch(message, this.messageType);
            Optional<CompletableFuture<Message>> localResult = this.localHandlerRegistry.handle(new DeserializingMessage(message, this.messageType, this.serializer));
            if (localResult.isEmpty()) {
                SerializedMessage serializedMessage = this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, this.messageType);
                if (serializedMessage == null) continue;
                serializedMessages.add(serializedMessage);
                continue;
            }
            if (!localResult.get().isCompletedExceptionally()) continue;
            try {
                localResult.get().getNow(null);
            }
            catch (CompletionException e) {
                log.error("Handler failed to handle a {}", (Object)message.getPayloadClass().getSimpleName(), (Object)e.getCause());
            }
        }
        if (!serializedMessages.isEmpty()) {
            try {
                return this.gatewayClient.append(guarantee, serializedMessages.toArray(new SerializedMessage[0]));
            }
            catch (Exception e) {
                throw new GatewayException(String.format("Failed to send and forget %s messages", messages.length), e);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public List<CompletableFuture<Message>> sendForMessages(Message ... messages) {
        ArrayList<Object> results = new ArrayList<Object>(messages.length);
        for (Message message : messages) {
            if ((message = this.dispatchInterceptor.interceptDispatch(message, this.messageType)) == null) {
                results.add(this.emptyReturnMessage());
                continue;
            }
            this.dispatchInterceptor.monitorDispatch(message, this.messageType);
            Optional<CompletableFuture<Message>> localResult = this.localHandlerRegistry.handle(new DeserializingMessage(message, this.messageType, this.serializer));
            if (localResult.isPresent()) {
                CompletionStage<Message> c = localResult.get();
                if (this.messageType == MessageType.WEBREQUEST) {
                    c = ((CompletableFuture)c).thenApply(WebResponse::new);
                }
                String messageId = message.getMessageId();
                this.callbacks.put(messageId, (CompletableFuture<?>)c);
                results.add(((CompletableFuture)c).whenComplete((m, e) -> this.callbacks.remove(messageId)));
                continue;
            }
            SerializedMessage serializedMessage = this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, this.messageType);
            if (serializedMessage == null) {
                results.add(this.emptyReturnMessage());
                continue;
            }
            results.add(serializedMessage);
        }
        List<SerializedMessage> serializedMessages = results.stream().filter(r -> r instanceof SerializedMessage).map(m -> (SerializedMessage)m).collect(Collectors.toList());
        List externalResults = serializedMessages.isEmpty() ? Collections.emptyList() : this.requestHandler.sendRequests(serializedMessages, m -> this.gatewayClient.append(Guarantee.SENT, (SerializedMessage[])m.toArray(SerializedMessage[]::new))).stream().map(r -> r.thenCompose(m -> {
            Object result;
            try {
                result = this.serializer.deserialize((SerializedObject<byte[], ?>)m);
            }
            catch (Exception e) {
                log.error("Failed to deserialize result with id {}", (Object)m.getMessageId(), (Object)e);
                return CompletableFuture.failedFuture(e);
            }
            if (result instanceof Throwable) {
                return CompletableFuture.failedFuture((Throwable)result);
            }
            Message message = new Message(result, m.getMetadata());
            if (this.messageType == MessageType.WEBREQUEST) {
                message = new WebResponse(message);
            }
            return CompletableFuture.completedFuture(message);
        })).toList();
        return results.stream().map(r -> {
            if (r instanceof CompletableFuture) {
                return (CompletableFuture)r;
            }
            SerializedMessage m = (SerializedMessage)r;
            CompletableFuture future = (CompletableFuture)externalResults.get(serializedMessages.indexOf(m));
            this.callbacks.put(m.getMessageId(), future);
            return future.whenComplete((v, e) -> this.callbacks.remove(m.getMessageId()));
        }).collect(Collectors.toList());
    }

    protected CompletableFuture<Message> emptyReturnMessage() {
        CompletionStage<Message> c = CompletableFuture.completedFuture(Message.asMessage(null));
        if (this.messageType == MessageType.WEBREQUEST) {
            c = c.thenApply(WebResponse::new);
        }
        return c;
    }

    @Override
    public void close() {
        ClientUtils.waitForResults(Duration.ofSeconds(2L), this.callbacks.values());
    }

    @ConstructorProperties(value={"gatewayClient", "requestHandler", "serializer", "dispatchInterceptor", "messageType", "localHandlerRegistry"})
    public DefaultGenericGateway(GatewayClient gatewayClient, RequestHandler requestHandler, Serializer serializer, DispatchInterceptor dispatchInterceptor, MessageType messageType, HandlerRegistry localHandlerRegistry) {
        this.gatewayClient = gatewayClient;
        this.requestHandler = requestHandler;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.messageType = messageType;
        this.localHandlerRegistry = localHandlerRegistry;
    }

    public Optional<CompletableFuture<Message>> handle(DeserializingMessage message) {
        return this.localHandlerRegistry.handle(message);
    }

    public HandlerRegistry merge(HandlerRegistry next) {
        return this.localHandlerRegistry.merge(next);
    }

    @Override
    public Registration registerHandler(Object target) {
        return this.localHandlerRegistry.registerHandler(target);
    }

    @Override
    public void setSelfHandlerFilter(HandlerFilter selfHandlerFilter) {
        this.localHandlerRegistry.setSelfHandlerFilter(selfHandlerFilter);
    }

    @Override
    public Registration registerHandler(Object target, HandlerFilter handlerFilter) {
        return this.localHandlerRegistry.registerHandler(target, handlerFilter);
    }
}

