/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import lombok.NonNull;

public final class Schedule
extends Message {
    public static String scheduleIdMetadataKey = "$scheduleId";
    @NonNull
    private final String scheduleId;
    @NonNull
    private final Instant deadline;

    public Schedule(Object payload, Instant deadline) {
        this(payload, FluxCapacitor.currentIdentityProvider().nextTechnicalId(), deadline);
    }

    public Schedule(Object payload, String scheduleId, Instant deadline) {
        this(payload, Metadata.empty(), scheduleId, deadline);
    }

    public Schedule(Object payload, Metadata metadata2, String scheduleId, Instant deadline) {
        super(payload, metadata2);
        this.scheduleId = scheduleId;
        this.deadline = deadline.truncatedTo(ChronoUnit.MILLIS);
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp", "scheduleId", "deadline"})
    public Schedule(Object payload, Metadata metadata2, String messageId, Instant timestamp, String scheduleId, Instant deadline) {
        super(payload, metadata2, messageId, timestamp);
        this.scheduleId = scheduleId;
        this.deadline = deadline.truncatedTo(ChronoUnit.MILLIS);
    }

    @Override
    public Schedule withPayload(Object payload) {
        return new Schedule(payload, this.getMetadata(), this.getMessageId(), this.getTimestamp(), this.scheduleId, this.deadline);
    }

    @Override
    public Schedule withMetadata(Metadata metadata2) {
        return new Schedule(this.getPayload(), metadata2, this.getMessageId(), this.getTimestamp(), this.scheduleId, this.deadline);
    }

    @Override
    public Schedule addMetadata(Metadata metadata2) {
        return (Schedule)super.addMetadata(metadata2);
    }

    @Override
    public Schedule addMetadata(String key, Object value) {
        return (Schedule)super.addMetadata(key, value);
    }

    @Override
    public Schedule addMetadata(Object ... keyValues) {
        return (Schedule)super.addMetadata(keyValues);
    }

    @Override
    public Schedule addMetadata(Map<String, ?> values2) {
        return (Schedule)super.addMetadata(values2);
    }

    @Override
    public Schedule addUser(User user) {
        return (Schedule)super.addUser(user);
    }

    public Schedule reschedule(Duration duration) {
        return new Schedule(this.getPayload(), this.getMetadata(), FluxCapacitor.currentIdentityProvider().nextTechnicalId(), FluxCapacitor.currentTime(), this.scheduleId, this.deadline.plus(duration));
    }

    @NonNull
    public String getScheduleId() {
        return this.scheduleId;
    }

    @NonNull
    public Instant getDeadline() {
        return this.deadline;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$scheduleId = this.getScheduleId();
        String other$scheduleId = other.getScheduleId();
        if (this$scheduleId == null ? other$scheduleId != null : !this$scheduleId.equals(other$scheduleId)) {
            return false;
        }
        Instant this$deadline = this.getDeadline();
        Instant other$deadline = other.getDeadline();
        return !(this$deadline == null ? other$deadline != null : !((Object)this$deadline).equals(other$deadline));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Schedule;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $scheduleId = this.getScheduleId();
        result = result * 59 + ($scheduleId == null ? 43 : $scheduleId.hashCode());
        Instant $deadline = this.getDeadline();
        result = result * 59 + ($deadline == null ? 43 : ((Object)$deadline).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Schedule(super=" + super.toString() + ", scheduleId=" + this.getScheduleId() + ", deadline=" + String.valueOf(this.getDeadline()) + ")";
    }
}

