/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.MemoizingSupplier;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerFilter;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.MessageFilter;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.ViewRepository;
import io.fluxcapacitor.javaclient.tracking.TrackSelf;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import io.fluxcapacitor.javaclient.tracking.handling.HandleError;
import io.fluxcapacitor.javaclient.tracking.handling.HandleEvent;
import io.fluxcapacitor.javaclient.tracking.handling.HandleMetrics;
import io.fluxcapacitor.javaclient.tracking.handling.HandleNotification;
import io.fluxcapacitor.javaclient.tracking.handling.HandleQuery;
import io.fluxcapacitor.javaclient.tracking.handling.HandleResult;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerDecorator;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.PayloadFilter;
import io.fluxcapacitor.javaclient.tracking.handling.View;
import io.fluxcapacitor.javaclient.tracking.handling.ViewHandler;
import io.fluxcapacitor.javaclient.web.HandleWeb;
import io.fluxcapacitor.javaclient.web.HandleWebResponse;
import io.fluxcapacitor.javaclient.web.WebRequest;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class DefaultHandlerFactory
implements HandlerFactory {
    private final MessageType messageType;
    private final HandlerDecorator defaultDecorator;
    private final List<ParameterResolver<? super DeserializingMessage>> parameterResolvers;
    private final MessageFilter<? super DeserializingMessage> messageFilter;
    private final Class<? extends Annotation> handlerAnnotation;
    private final Function<Class<?>, ViewRepository> viewRepositorySupplier;

    public DefaultHandlerFactory(MessageType messageType, HandlerDecorator defaultDecorator, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, Function<Class<?>, ViewRepository> viewRepositorySupplier) {
        this.messageType = messageType;
        this.defaultDecorator = defaultDecorator;
        this.parameterResolvers = parameterResolvers;
        this.viewRepositorySupplier = ClientUtils.memoize(viewRepositorySupplier);
        this.handlerAnnotation = this.getHandlerAnnotation(messageType);
        this.messageFilter = this.defaultMessageFilter();
    }

    @Override
    public Optional<Handler<DeserializingMessage>> createHandler(Object target, HandlerFilter handlerFilter, List<HandlerInterceptor> extraInterceptors) {
        Class<?> targetClass = HandlerFactory.getTargetClass(target);
        HandlerDecorator handlerDecorator = Stream.concat(extraInterceptors.stream(), Stream.of(this.defaultDecorator)).reduce(HandlerDecorator::andThen).orElseThrow();
        return Optional.of(this.handlerAnnotation).map(a -> HandlerConfiguration.builder().methodAnnotation((Class<Annotation>)a).handlerFilter(handlerFilter).messageFilter(this.messageFilter).build()).filter(config -> HandlerInspector.hasHandlerMethods(targetClass, config)).map(config -> this.buildHandler(target, (HandlerConfiguration<DeserializingMessage>)config)).map(handlerDecorator::wrap);
    }

    private Handler<DeserializingMessage> buildHandler(Object target, HandlerConfiguration<DeserializingMessage> config) {
        if (target instanceof Class) {
            Class targetClass = (Class)target;
            View view = (View)ReflectionUtils.getTypeAnnotation(targetClass, View.class);
            if (view != null) {
                return new ViewHandler(targetClass, HandlerInspector.inspect(targetClass, this.parameterResolvers, config), this.viewRepositorySupplier.apply(targetClass));
            }
            Optional trackSelf = Optional.ofNullable(ReflectionUtils.getTypeAnnotation(targetClass, TrackSelf.class)).or(() -> Optional.ofNullable(targetClass.getPackage()).flatMap(p -> ReflectionUtils.getPackageAnnotation(p, TrackSelf.class)));
            if (trackSelf.isPresent()) {
                MessageFilter<DeserializingMessage> selfFilter = (message, method) -> targetClass.isAssignableFrom(message.getPayloadClass());
                return HandlerInspector.createHandler(DeserializingMessage::getPayload, targetClass, this.parameterResolvers, config.toBuilder().messageFilter(selfFilter.and(config.messageFilter())).build());
            }
            MemoizingSupplier<Object> instanceSupplier = ClientUtils.memoize(() -> ReflectionUtils.asInstance(targetClass));
            return HandlerInspector.createHandler(m -> targetClass.equals(m.getPayloadClass()) ? m.getPayload() : instanceSupplier.get(), targetClass, this.parameterResolvers, config);
        }
        return HandlerInspector.createHandler(target, this.parameterResolvers, config);
    }

    protected Class<? extends Annotation> getHandlerAnnotation(MessageType messageType) {
        return switch (messageType) {
            default -> throw new MatchException(null, null);
            case MessageType.COMMAND -> HandleCommand.class;
            case MessageType.EVENT -> HandleEvent.class;
            case MessageType.NOTIFICATION -> HandleNotification.class;
            case MessageType.QUERY -> HandleQuery.class;
            case MessageType.RESULT -> HandleResult.class;
            case MessageType.ERROR -> HandleError.class;
            case MessageType.SCHEDULE -> HandleSchedule.class;
            case MessageType.METRICS -> HandleMetrics.class;
            case MessageType.WEBREQUEST -> HandleWeb.class;
            case MessageType.WEBRESPONSE -> HandleWebResponse.class;
        };
    }

    protected MessageFilter<? super DeserializingMessage> defaultMessageFilter() {
        PayloadFilter payloadFilter = new PayloadFilter();
        MessageFilter<HasMessage> result = this.parameterResolvers.stream().flatMap(r -> r instanceof MessageFilter ? Stream.of((MessageFilter)((Object)r)) : Stream.empty()).reduce(MessageFilter::and).map(f -> f.and(payloadFilter)).orElse(payloadFilter);
        return this.messageType == MessageType.WEBREQUEST ? WebRequest.getWebRequestFilter().and(result) : result;
    }

    @ConstructorProperties(value={"messageType", "defaultDecorator", "parameterResolvers", "messageFilter", "handlerAnnotation", "viewRepositorySupplier"})
    public DefaultHandlerFactory(MessageType messageType, HandlerDecorator defaultDecorator, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers, MessageFilter<? super DeserializingMessage> messageFilter, Class<? extends Annotation> handlerAnnotation, Function<Class<?>, ViewRepository> viewRepositorySupplier) {
        this.messageType = messageType;
        this.defaultDecorator = defaultDecorator;
        this.parameterResolvers = parameterResolvers;
        this.messageFilter = messageFilter;
        this.handlerAnnotation = handlerAnnotation;
        this.viewRepositorySupplier = viewRepositorySupplier;
    }
}

