/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.MessageFilter;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.publishing.correlation.DefaultCorrelationDataProvider;
import io.fluxcapacitor.javaclient.tracking.handling.Trigger;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class TriggerParameterResolver
implements ParameterResolver<HasMessage>,
MessageFilter<HasMessage> {
    private final Function<Executable, Predicate<HasMessage>> messageFilterCache = ObjectUtils.memoize(e -> ReflectionUtils.getAnnotation(e, Trigger.class).map(trigger -> m -> this.filterMessage((HasMessage)m, (Trigger)trigger)).orElseGet(ObjectUtils::noOpPredicate));
    private final Client client;
    private final Serializer serializer;
    private final DefaultCorrelationDataProvider correlationDataProvider = DefaultCorrelationDataProvider.INSTANCE;

    @Override
    public boolean test(HasMessage message, Executable executable) {
        return this.messageFilterCache.apply(executable).test(message);
    }

    @Override
    public boolean matches(Parameter parameter, Annotation methodAnnotation, HasMessage value) {
        return ReflectionUtils.has(Trigger.class, parameter);
    }

    @Override
    public boolean filterMessage(HasMessage message, Parameter parameter) {
        Trigger trigger = parameter.getAnnotation(Trigger.class);
        if (!this.filterMessage(message, trigger)) {
            return false;
        }
        Class parameterType = HasMessage.class.isAssignableFrom(parameter.getType()) ? Object.class : parameter.getType();
        return this.getTriggerClass(message).filter(parameterType::isAssignableFrom).isPresent();
    }

    protected boolean filterMessage(HasMessage message, Trigger trigger) {
        if (trigger == null) {
            return false;
        }
        if (trigger.messageType().length > 0 && this.getTriggerMessageType(message).filter(type2 -> Arrays.stream(trigger.messageType()).anyMatch(t -> t == type2)).isEmpty()) {
            return false;
        }
        if (trigger.consumer().length > 0 && this.getConsumer(message).filter(type2 -> Arrays.asList(trigger.consumer()).contains(type2)).isEmpty()) {
            return false;
        }
        return this.getTriggerClass(message).filter(triggerClass -> {
            Class<?>[] allowedTypes = trigger.value();
            return allowedTypes.length == 0 || Arrays.stream(allowedTypes).anyMatch(a -> a.isAssignableFrom((Class<?>)triggerClass));
        }).isPresent();
    }

    @Override
    public Function<HasMessage, Object> resolve(Parameter p, Annotation methodAnnotation) {
        return m -> Optional.ofNullable(m.getMetadata().get(this.correlationDataProvider.getCorrelationIdKey())).flatMap(s -> {
            try {
                return Optional.of(Long.valueOf(s));
            }
            catch (Exception ignored) {
                return Optional.empty();
            }
        }).flatMap(index -> this.getTriggerMessage((long)index, this.getTriggerClass((HasMessage)m).orElseThrow(), this.getTriggerMessageType((HasMessage)m).orElseThrow())).map(triggerMessage -> {
            Class<?> parameterType = p.getType();
            if (DeserializingMessage.class.isAssignableFrom(parameterType)) {
                return triggerMessage;
            }
            if (HasMessage.class.isAssignableFrom(parameterType)) {
                return triggerMessage.toMessage();
            }
            return triggerMessage.getPayload();
        }).orElse(null);
    }

    protected Optional<Class<?>> getTriggerClass(HasMessage message) {
        return Optional.ofNullable(message.getMetadata().get(this.correlationDataProvider.getTriggerKey())).flatMap(s -> Optional.ofNullable(ReflectionUtils.classForName(s, null)));
    }

    protected Optional<MessageType> getTriggerMessageType(HasMessage message) {
        return Optional.ofNullable(message.getMetadata().get(this.correlationDataProvider.getTriggerTypeKey())).flatMap(s -> {
            try {
                return Optional.of(MessageType.valueOf(s));
            }
            catch (Exception ignored) {
                return Optional.empty();
            }
        });
    }

    protected Optional<String> getConsumer(HasMessage message) {
        return Optional.ofNullable(message.getMetadata().get(this.correlationDataProvider.getConsumerKey()));
    }

    protected Optional<DeserializingMessage> getTriggerMessage(long index, Class<?> type2, MessageType messageType) {
        return this.client.getTrackingClient(messageType).readFromIndex(index, 1).stream().flatMap(s -> this.serializer.deserializeMessages(Stream.of(s), messageType)).filter(d -> type2.isAssignableFrom(d.getPayloadClass())).findFirst();
    }

    @ConstructorProperties(value={"client", "serializer"})
    public TriggerParameterResolver(Client client, Serializer serializer) {
        this.client = client;
        this.serializer = serializer;
    }
}

