/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.Entry;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.EntityId;
import io.fluxcapacitor.javaclient.modeling.Id;
import io.fluxcapacitor.javaclient.modeling.ViewRepository;
import io.fluxcapacitor.javaclient.tracking.handling.Association;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewHandler
implements Handler<DeserializingMessage> {
    private static final Logger log = LoggerFactory.getLogger(ViewHandler.class);
    private final Class<?> targetClass;
    private final HandlerMatcher<Object, DeserializingMessage> handlerMatcher;
    private final ViewRepository repository;
    private final AtomicReference<Object> viewAssociationProperties = new AtomicReference();
    private final Function<Executable, Set<String>> methodAssociationProperties = ClientUtils.memoize(m -> ReflectionUtils.getAnnotation(m, Association.class).map(a -> {
        Set associations = Arrays.stream(a.value()).collect(Collectors.toSet());
        if (associations.isEmpty()) {
            log.warn("@Association on handler method {} does not define a property. This is probably a mistake.", m);
        }
        return associations;
    }).orElseGet(Collections::emptySet));

    @Override
    public Optional<HandlerInvoker> getInvoker(DeserializingMessage message) {
        if (!this.handlerMatcher.canHandle(message)) {
            return Optional.empty();
        }
        Collection<Entry<?>> matches = this.repository.findByAssociation(this.associations(message));
        if (matches.isEmpty()) {
            return this.handlerMatcher.getInvoker(null, message).map(i -> new ViewInvoker((HandlerInvoker)i, null));
        }
        HandlerInvoker result = null;
        for (Entry<?> entry : matches) {
            Optional<ViewInvoker> invoker = this.handlerMatcher.getInvoker(entry.getValue(), message).map(i -> new ViewInvoker((HandlerInvoker)i, entry));
            if (!invoker.isPresent()) continue;
            result = result == null ? (HandlerInvoker)invoker.get() : result.combine(invoker.get());
        }
        return Optional.ofNullable(result);
    }

    protected Collection<String> associations(DeserializingMessage message) {
        return Optional.ofNullable(message.getPayload()).stream().flatMap(payload -> Stream.concat(this.handlerMatcher.matchingMethods(message).flatMap(e -> this.methodAssociationProperties.apply((Executable)e).stream()), this.getViewAssociationProperties().stream()).flatMap(property -> ReflectionUtils.readProperty(property, payload).stream())).map(v -> {
            if (v instanceof Id) {
                Id id = (Id)v;
                return id.getFunctionalId();
            }
            return v.toString();
        }).collect(Collectors.toSet());
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public HandlerMatcher<Object, DeserializingMessage> getHandlerMatcher() {
        return this.handlerMatcher;
    }

    public ViewRepository getRepository() {
        return this.repository;
    }

    public Function<Executable, Set<String>> getMethodAssociationProperties() {
        return this.methodAssociationProperties;
    }

    @ConstructorProperties(value={"targetClass", "handlerMatcher", "repository"})
    public ViewHandler(Class<?> targetClass, HandlerMatcher<Object, DeserializingMessage> handlerMatcher, ViewRepository repository) {
        this.targetClass = targetClass;
        this.handlerMatcher = handlerMatcher;
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getViewAssociationProperties() {
        Object value = this.viewAssociationProperties.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.viewAssociationProperties;
            synchronized (atomicReference) {
                value = this.viewAssociationProperties.get();
                if (value == null) {
                    Set actualValue = ReflectionUtils.getAnnotatedProperties(this.getTargetClass(), Association.class).stream().flatMap(member -> ReflectionUtils.getAnnotation(member, Association.class).stream().flatMap(a -> a.value().length > 0 ? Arrays.stream(a.value()) : Stream.of(ReflectionUtils.getPropertyName(member)))).collect(Collectors.toSet());
                    value = actualValue == null ? this.viewAssociationProperties : actualValue;
                    this.viewAssociationProperties.set(value);
                }
            }
        }
        return (Set)(value == this.viewAssociationProperties ? null : value);
    }

    protected class ViewInvoker
    implements HandlerInvoker {
        private final HandlerInvoker delegate;
        private final Entry<?> currentEntry;

        @Override
        public Object invoke(BiFunction<Object, Object, Object> combiner) {
            Executable executable;
            Object result = this.delegate.invoke(combiner);
            if (this.delegate.getTargetClass().isInstance(result)) {
                if (this.currentEntry == null || !Objects.equals(this.currentEntry.getValue(), result)) {
                    ViewHandler.this.repository.set(result, this.currentEntry == null ? ViewInvoker.computeId(result) : this.currentEntry.getId()).get();
                }
                return null;
            }
            if (result == null && this.delegate.expectResult() && (executable = this.delegate.getMethod()) instanceof Method) {
                Method m = (Method)executable;
                if (this.delegate.getTargetClass().isAssignableFrom(m.getReturnType()) || m.getReturnType().isAssignableFrom(this.delegate.getTargetClass())) {
                    if (this.currentEntry != null) {
                        ViewHandler.this.repository.delete(this.currentEntry.getId()).get();
                    }
                    return null;
                }
            }
            return result;
        }

        private static Object computeId(Object view) {
            return ReflectionUtils.getAnnotatedPropertyValue(view, EntityId.class).orElseGet(FluxCapacitor::generateId);
        }

        public HandlerInvoker getDelegate() {
            return this.delegate;
        }

        public Entry<?> getCurrentEntry() {
            return this.currentEntry;
        }

        @ConstructorProperties(value={"delegate", "currentEntry"})
        public ViewInvoker(HandlerInvoker delegate, Entry<?> currentEntry) {
            this.delegate = delegate;
            this.currentEntry = currentEntry;
        }

        @Override
        public Class<?> getTargetClass() {
            return this.getDelegate().getTargetClass();
        }

        @Override
        public Executable getMethod() {
            return this.getDelegate().getMethod();
        }

        @Override
        public <A extends Annotation> A getMethodAnnotation() {
            return this.getDelegate().getMethodAnnotation();
        }

        @Override
        public boolean expectResult() {
            return this.getDelegate().expectResult();
        }

        @Override
        public boolean isPassive() {
            return this.getDelegate().isPassive();
        }

        @Override
        public Object invoke() {
            return this.getDelegate().invoke();
        }

        @Override
        public HandlerInvoker combine(HandlerInvoker second) {
            return this.getDelegate().combine(second);
        }

        private static interface ExcludedMethods {
            public Object invoke(BiFunction<Object, Object, Object> var1);
        }
    }
}

