/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.authentication;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationUtils;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Function;

public class AuthenticatingInterceptor
implements DispatchInterceptor,
HandlerInterceptor {
    private final UserProvider userProvider;

    @Override
    public Message interceptDispatch(Message m, MessageType messageType) {
        if (!this.userProvider.containsUser(m.getMetadata())) {
            User user;
            Optional<DeserializingMessage> currentMessage = Optional.ofNullable(DeserializingMessage.getCurrent());
            User user2 = currentMessage.isPresent() ? (currentMessage.get().getMessageType() == MessageType.WEBREQUEST ? null : this.userProvider.getSystemUser()) : (user = Optional.ofNullable(this.userProvider.getActiveUser()).orElseGet(this.userProvider::getSystemUser));
            if (user != null) {
                m = m.withMetadata(this.userProvider.addToMetadata(m.getMetadata(), user));
            }
        }
        return m;
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, HandlerInvoker invoker) {
        return m -> {
            Object previous = User.getCurrent();
            User user = this.userProvider.fromMessage((HasMessage)m);
            try {
                User.current.set(user);
                if (m.getType() != null) {
                    ValidationUtils.assertAuthorized(m.getPayloadClass(), user);
                }
                Object r = function.apply((DeserializingMessage)m);
                return r;
            }
            finally {
                User.current.set((User)previous);
            }
        };
    }

    @Override
    public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler) {
        return new AuthorizingHandler(HandlerInterceptor.super.wrap(handler));
    }

    @ConstructorProperties(value={"userProvider"})
    public AuthenticatingInterceptor(UserProvider userProvider) {
        this.userProvider = userProvider;
    }

    private class AuthorizingHandler
    implements Handler<DeserializingMessage> {
        private final Handler<DeserializingMessage> delegate;

        @Override
        public Optional<HandlerInvoker> getInvoker(DeserializingMessage m) {
            return this.delegate.getInvoker(m).filter(i -> Optional.ofNullable(m.getPayloadClass()).map(c -> i.getTargetClass().isAssignableFrom((Class<?>)c)).orElse(true) != false || ValidationUtils.isAuthorized(i.getTargetClass(), i.getMethod(), AuthenticatingInterceptor.this.userProvider.fromMessage(m)));
        }

        public String toString() {
            return this.delegate.toString();
        }

        @ConstructorProperties(value={"delegate"})
        public AuthorizingHandler(Handler<DeserializingMessage> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Class<?> getTargetClass() {
            return this.delegate.getTargetClass();
        }
    }

    private static interface ExcludedMethods {
        public Optional<HandlerInvoker> getInvoker(DeserializingMessage var1);
    }
}

