/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.web.DefaultSocketSession;
import io.fluxcapacitor.javaclient.web.HandleWeb;
import io.fluxcapacitor.javaclient.web.SocketSession;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.function.Function;

public class SocketSessionParameterResolver
implements ParameterResolver<HasMessage> {
    private final ResultGateway webResponseGateway;

    @Override
    public Function<HasMessage, Object> resolve(Parameter p, Annotation methodAnnotation) {
        return m -> {
            String string;
            String sessionId = m.getMetadata().get("sessionId");
            if (m instanceof DeserializingMessage) {
                DeserializingMessage dm = (DeserializingMessage)m;
                string = dm.getSerializedObject().getSource();
            } else {
                string = null;
            }
            String target = string;
            return sessionId == null ? null : new DefaultSocketSession(sessionId, target, this.webResponseGateway);
        };
    }

    @Override
    public boolean matches(Parameter parameter, Annotation methodAnnotation, HasMessage value) {
        return SocketSession.class.isAssignableFrom(parameter.getType()) && ReflectionUtils.isOrHas(methodAnnotation, HandleWeb.class) && value.getMetadata().containsKey("sessionId");
    }

    @ConstructorProperties(value={"webResponseGateway"})
    public SocketSessionParameterResolver(ResultGateway webResponseGateway) {
        this.webResponseGateway = webResponseGateway;
    }
}

