/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import io.fluxcapacitor.common.serialization.compression.CompressionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.web.WebUtils;
import java.beans.ConstructorProperties;
import java.net.HttpCookie;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class WebResponse
extends Message {
    private static final List<String> gzipEncoding = List.of("gzip");
    @NonNull
    private final Map<String, List<String>> headers;
    private final Integer status;
    private final AtomicReference<Object> decodedPayload = new AtomicReference();

    private WebResponse(Builder builder) {
        super(builder.payload(), Metadata.of("status", builder.status(), "headers", builder.headers()));
        this.status = builder.status();
        this.headers = builder.headers();
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp"})
    WebResponse(Object payload, Metadata metadata2, String messageId, Instant timestamp) {
        super(payload, metadata2, messageId, timestamp);
        this.headers = Optional.ofNullable(metadata2.get("headers", Map.class)).orElse(Collections.emptyMap());
        this.status = Optional.ofNullable(metadata2.get("status")).map(Integer::valueOf).orElse(null);
    }

    public WebResponse(Message m) {
        this(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp());
    }

    @Override
    public SerializedMessage serialize(Serializer serializer) {
        return this.headers.getOrDefault("Content-Type", List.of()).stream().findFirst().map(format -> new SerializedMessage(serializer.serialize(this.getEncodedPayload(), (String)format), this.getMetadata(), this.getMessageId(), this.getTimestamp().toEpochMilli())).orElseGet(() -> super.serialize(serializer));
    }

    public static Metadata asMetadata(int statusCode, Map<String, List<String>> headers) {
        return Metadata.of("status", statusCode, "headers", headers);
    }

    @Override
    public WebResponse withMetadata(Metadata metadata2) {
        return new WebResponse(super.withMetadata(metadata2));
    }

    @Override
    public WebResponse addMetadata(Metadata metadata2) {
        return (WebResponse)super.addMetadata(metadata2);
    }

    @Override
    public WebResponse addMetadata(String key, Object value) {
        return (WebResponse)super.addMetadata(key, value);
    }

    @Override
    public WebResponse addMetadata(Object ... keyValues) {
        return (WebResponse)super.addMetadata(keyValues);
    }

    @Override
    public WebResponse addMetadata(Map<String, ?> values2) {
        return (WebResponse)super.addMetadata(values2);
    }

    @Override
    public WebResponse addUser(User user) {
        return (WebResponse)super.addUser(user);
    }

    @Override
    public WebResponse withPayload(Object payload) {
        return this.toBuilder().payload(payload).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Map<String, List<String>> getHeaders(Metadata metadata2) {
        return Optional.ofNullable(metadata2.get("headers", Map.class)).orElse(Collections.emptyMap());
    }

    public static Integer getStatusCode(Metadata metadata2) {
        return Optional.ofNullable(metadata2.get("status")).map(Integer::valueOf).orElse(null);
    }

    @Override
    public <R> R getPayload() {
        return (R)this.getDecodedPayload();
    }

    Object getEncodedPayload() {
        return super.getPayload();
    }

    Object decodePayload() {
        Object result = this.getEncodedPayload();
        if (result instanceof byte[]) {
            byte[] bytes = (byte[])result;
            if (Objects.equals(this.getHeaders().get("Content-Encoding"), gzipEncoding)) {
                return CompressionUtils.decompress(bytes, CompressionAlgorithm.GZIP);
            }
        }
        return result;
    }

    @NonNull
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Integer getStatus() {
        return this.status;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebResponse)) {
            return false;
        }
        WebResponse other = (WebResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Object this$decodedPayload = this.getDecodedPayload();
        Object other$decodedPayload = other.getDecodedPayload();
        return !(this$decodedPayload == null ? other$decodedPayload != null : !this$decodedPayload.equals(other$decodedPayload));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Object $decodedPayload = this.getDecodedPayload();
        result = result * 59 + ($decodedPayload == null ? 43 : $decodedPayload.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WebResponse(super=" + super.toString() + ", headers=" + String.valueOf(this.getHeaders()) + ", status=" + this.getStatus() + ", decodedPayload=" + String.valueOf(this.getDecodedPayload()) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDecodedPayload() {
        AtomicReference<Object> value = this.decodedPayload.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.decodedPayload;
            synchronized (atomicReference) {
                value = this.decodedPayload.get();
                if (value == null) {
                    AtomicReference<Object> actualValue = this.decodePayload();
                    value = actualValue == null ? this.decodedPayload : actualValue;
                    this.decodedPayload.set(value);
                }
            }
        }
        return value == this.decodedPayload ? null : value;
    }

    public static class Builder {
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private List<HttpCookie> cookies = new ArrayList<HttpCookie>();
        private Object payload;
        private Integer status;

        protected Builder(WebResponse response) {
            this.payload(response.getEncodedPayload());
            this.status(response.getStatus());
            response.getHeaders().forEach((k, v) -> this.headers.put((String)k, new ArrayList(v)));
            this.cookies.addAll(WebUtils.parseResponseCookieHeader(this.headers.remove("Set-Cookie")));
        }

        public Builder payload(Object payload) {
            this.payload = payload;
            if (!this.headers().containsKey("Content-Type")) {
                if (payload instanceof String) {
                    return this.contentType("text/plain");
                }
                if (payload instanceof byte[]) {
                    return this.contentType("application/octet-stream");
                }
            }
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder cookie(HttpCookie cookie) {
            this.cookies.add(cookie);
            return this;
        }

        public Builder contentType(String contentType) {
            return this.header("Content-Type", contentType);
        }

        public Map<String, List<String>> headers() {
            Map<String, List<String>> result = this.headers;
            if (!this.cookies.isEmpty()) {
                result = new HashMap<String, List<String>>(this.headers);
                result.put("Set-Cookie", this.cookies.stream().map(WebUtils::toResponseHeaderString).collect(Collectors.toList()));
            }
            return result;
        }

        public Integer status() {
            return this.status == null ? (this.payload == null ? 204 : 200) : this.status;
        }

        public WebResponse build() {
            return new WebResponse(this);
        }

        public List<HttpCookie> cookies() {
            return this.cookies;
        }

        public Object payload() {
            return this.payload;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.status();
            Integer other$status = other.status();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.headers();
            Map<String, List<String>> other$headers = other.headers();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            List<HttpCookie> this$cookies = this.cookies();
            List<HttpCookie> other$cookies = other.cookies();
            if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
                return false;
            }
            Object this$payload = this.payload();
            Object other$payload = other.payload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.status();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            Map<String, List<String>> $headers = this.headers();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            List<HttpCookie> $cookies = this.cookies();
            result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
            Object $payload = this.payload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        public String toString() {
            return "WebResponse.Builder(headers=" + String.valueOf(this.headers()) + ", cookies=" + String.valueOf(this.cookies()) + ", payload=" + String.valueOf(this.payload()) + ", status=" + this.status() + ")";
        }

        public Builder() {
        }
    }
}

