/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import io.fluxcapacitor.common.serialization.compression.CompressionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.web.HttpRequestMethod;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WebResponseCompressingInterceptor
implements DispatchInterceptor {
    private final int minimumLength;

    public WebResponseCompressingInterceptor() {
        this(2048);
    }

    public WebResponseCompressingInterceptor(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    @Override
    public SerializedMessage modifySerializedMessage(SerializedMessage response, Message message, MessageType type2) {
        return this.acceptCompression() && this.shouldCompress(response) ? this.compress(response) : response;
    }

    protected boolean acceptCompression() {
        DeserializingMessage request = DeserializingMessage.getCurrent();
        if (request == null || request.getMessageType() != MessageType.WEBREQUEST) {
            return false;
        }
        HttpRequestMethod requestMethod = WebRequest.getMethod(request.getMetadata());
        if (requestMethod == null || requestMethod.isWebsocket()) {
            return false;
        }
        return WebRequest.getHeaders(request.getMetadata()).getOrDefault("Accept-Encoding", Collections.emptyList()).stream().flatMap(v -> Arrays.stream(v.split(",")).map(String::trim)).toList().contains("gzip");
    }

    protected boolean shouldCompress(SerializedMessage response) {
        return !WebResponse.getHeaders(response.getMetadata()).containsKey("Content-Encoding") && response.getData().getValue().length >= this.minimumLength;
    }

    protected SerializedMessage compress(SerializedMessage serializedMessage) {
        SerializedObject result = serializedMessage.withData((Data)serializedMessage.getData().map(bytes -> CompressionUtils.compress(bytes, CompressionAlgorithm.GZIP)));
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>(((SerializedMessage)result).getMetadata().get("headers", Map.class));
        headers.put("Content-Encoding", List.of("gzip"));
        ((SerializedMessage)result).setMetadata(((SerializedMessage)result).getMetadata().with((Object)"headers", (Object)headers));
        return result;
    }

    @Override
    public Message interceptDispatch(Message message, MessageType messageType) {
        return message;
    }
}

