/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.ServicePathBuilder;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.InMemoryClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.InMemoryScheduleStore;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.InMemoryMessageStore;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.testserver.metrics.DefaultMetricsLog;
import io.fluxcapacitor.testserver.metrics.MetricsLog;
import io.fluxcapacitor.testserver.metrics.NoOpMetricsLog;
import io.fluxcapacitor.testserver.scheduling.TestServerScheduleStore;
import io.fluxcapacitor.testserver.websocket.ConsumerEndpoint;
import io.fluxcapacitor.testserver.websocket.EventSourcingEndpoint;
import io.fluxcapacitor.testserver.websocket.KeyValueEndPoint;
import io.fluxcapacitor.testserver.websocket.ProducerEndpoint;
import io.fluxcapacitor.testserver.websocket.SchedulingEndpoint;
import io.fluxcapacitor.testserver.websocket.SearchEndpoint;
import io.fluxcapacitor.testserver.websocket.WebsocketDeploymentUtils;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.Headers;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServer {
    private static final Logger log = LoggerFactory.getLogger(TestServer.class);
    private static final Function<String, Client> clients = ObjectUtils.memoize(projectId -> new TestServerProject(InMemoryClient.newInstance()));
    private static final Function<String, MetricsLog> metricsLogSupplier = ObjectUtils.memoize(projectId -> new DefaultMetricsLog(TestServer.getMessageStore(projectId, MessageType.METRICS)));

    public static void main(String[] args2) {
        TestServer.start(Integer.getInteger("port", 8080));
    }

    public static void start(int port) {
        PathHandler pathHandler = Handlers.path();
        for (MessageType messageType : Arrays.asList(MessageType.METRICS, MessageType.EVENT, MessageType.COMMAND, MessageType.QUERY, MessageType.RESULT, MessageType.ERROR, MessageType.WEBREQUEST, MessageType.WEBRESPONSE)) {
            pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ProducerEndpoint(TestServer.getMessageStore(projectId, messageType)).metricsLog(messageType == MessageType.METRICS ? new NoOpMetricsLog() : metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.producerPath(messageType)), pathHandler);
            pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ConsumerEndpoint(TestServer.getMessageStore(projectId, messageType), messageType).metricsLog(messageType == MessageType.METRICS ? new NoOpMetricsLog() : metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.consumerPath(messageType)), pathHandler);
        }
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ConsumerEndpoint(TestServer.getMessageStore(projectId, MessageType.NOTIFICATION), MessageType.NOTIFICATION).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.consumerPath(MessageType.NOTIFICATION)), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new EventSourcingEndpoint(clients.apply((String)projectId).getEventStoreClient()).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.eventSourcingPath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new KeyValueEndPoint(clients.apply((String)projectId).getKeyValueClient()).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.keyValuePath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new SearchEndpoint(clients.apply((String)projectId).getSearchClient()).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.searchPath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new SchedulingEndpoint(clients.apply((String)projectId).getSchedulingClient()).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.schedulingPath()), pathHandler);
        pathHandler = WebsocketDeploymentUtils.deploy(projectId -> new ConsumerEndpoint((MessageStore)((Object)clients.apply((String)projectId).getSchedulingClient()), MessageType.SCHEDULE).metricsLog(metricsLogSupplier.apply((String)projectId)), String.format("/%s/", ServicePathBuilder.consumerPath(MessageType.SCHEDULE)), pathHandler);
        pathHandler = pathHandler.addPrefixPath("/health", exchange -> {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
            exchange.getResponseSender().send("Healthy");
        });
        GracefulShutdownHandler shutdownHandler = new GracefulShutdownHandler(pathHandler);
        Undertow server = Undertow.builder().addHttpListener(port, "0.0.0.0").setHandler(shutdownHandler).build();
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Initiating controlled shutdown");
            shutdownHandler.shutdown();
            try {
                shutdownHandler.awaitShutdown(1000L);
            }
            catch (InterruptedException e) {
                log.warn("Thread to kill server was interrupted");
                Thread.currentThread().interrupt();
            }
        }, ObjectUtils.newThreadName("TestServer-shutdown")));
        log.info("Flux Capacitor test server running on port {}", (Object)port);
    }

    private static InMemoryMessageStore getMessageStore(String projectId, MessageType messageType) {
        if (messageType == MessageType.NOTIFICATION) {
            messageType = MessageType.EVENT;
        }
        return (InMemoryMessageStore)clients.apply(projectId).getGatewayClient(messageType);
    }

    static class TestServerProject
    implements Client {
        private final InMemoryClient delegate;

        @Override
        public SchedulingClient getSchedulingClient() {
            return new TestServerScheduleStore((InMemoryScheduleStore)this.delegate.getSchedulingClient());
        }

        @ConstructorProperties(value={"delegate"})
        public TestServerProject(InMemoryClient delegate) {
            this.delegate = delegate;
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        public String id() {
            return this.delegate.id();
        }

        @Override
        public GatewayClient getGatewayClient(MessageType messageType) {
            return this.delegate.getGatewayClient(messageType);
        }

        @Override
        public TrackingClient getTrackingClient(MessageType messageType) {
            return this.delegate.getTrackingClient(messageType);
        }

        @Override
        public void shutDown() {
            this.delegate.shutDown();
        }

        @Override
        public Registration beforeShutdown(Runnable task) {
            return this.delegate.beforeShutdown(task);
        }

        @Override
        public EventStoreClient getEventStoreClient() {
            return this.delegate.getEventStoreClient();
        }

        @Override
        public KeyValueClient getKeyValueClient() {
            return this.delegate.getKeyValueClient();
        }

        @Override
        public SearchClient getSearchClient() {
            return this.delegate.getSearchClient();
        }

        @Override
        public Client unwrap() {
            return this.delegate.unwrap();
        }

        static interface Excluded {
            public SchedulingClient getSchedulingClient();
        }
    }
}

