/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.testserver.websocket;

import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.eventsourcing.AppendEvents;
import io.fluxcapacitor.common.api.eventsourcing.DeleteEvents;
import io.fluxcapacitor.common.api.eventsourcing.EventBatch;
import io.fluxcapacitor.common.api.eventsourcing.GetEvents;
import io.fluxcapacitor.common.api.eventsourcing.GetEventsResult;
import io.fluxcapacitor.common.api.modeling.GetAggregateIds;
import io.fluxcapacitor.common.api.modeling.GetAggregateIdsResult;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.testserver.websocket.Handle;
import io.fluxcapacitor.testserver.websocket.WebsocketEndpoint;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSourcingEndpoint
extends WebsocketEndpoint {
    private static final Logger log = LoggerFactory.getLogger(EventSourcingEndpoint.class);
    private final EventStoreClient eventStore;

    @Handle
    CompletableFuture<Void> handle(AppendEvents appendEvents) {
        return CompletableFuture.allOf((CompletableFuture[])appendEvents.getEventBatches().stream().map(b -> this.eventStore.storeEvents(b.getAggregateId(), b.getEvents(), b.isStoreOnly(), appendEvents.getGuarantee())).toArray(CompletableFuture[]::new));
    }

    @Handle
    CompletableFuture<Void> handle(DeleteEvents deleteEvents) {
        return this.eventStore.deleteEvents(deleteEvents.getAggregateId(), deleteEvents.getGuarantee());
    }

    @Handle
    GetEventsResult handle(GetEvents getEvents) {
        AggregateEventStream<SerializedMessage> stream = this.eventStore.getEvents(getEvents.getAggregateId(), getEvents.getLastSequenceNumber());
        long lastSequenceNumber = stream.getLastSequenceNumber().orElse(-1L);
        return new GetEventsResult(getEvents.getRequestId(), new EventBatch(getEvents.getAggregateId(), stream.collect(Collectors.toList()), false), lastSequenceNumber);
    }

    @Handle
    CompletableFuture<Void> handle(UpdateRelationships request) {
        return this.eventStore.updateRelationships(request);
    }

    @Handle
    GetAggregateIdsResult handle(GetAggregateIds request) {
        return new GetAggregateIdsResult(request.getRequestId(), this.eventStore.getAggregateIds(request));
    }

    @ConstructorProperties(value={"eventStore"})
    public EventSourcingEndpoint(EventStoreClient eventStore) {
        this.eventStore = eventStore;
    }
}

