/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.io.Receiver;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSourceChannel;

public class AsyncReceiverImpl
implements Receiver {
    private static final Receiver.ErrorCallback END_EXCHANGE = new Receiver.ErrorCallback(){

        @Override
        public void error(HttpServerExchange exchange, IOException e) {
            e.printStackTrace();
            exchange.setStatusCode(500);
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            exchange.endExchange();
        }
    };
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final HttpServerExchange exchange;
    private final StreamSourceChannel channel;
    private int maxBufferSize = -1;
    private boolean paused = false;
    private boolean done = false;

    public AsyncReceiverImpl(HttpServerExchange exchange) {
        this.exchange = exchange;
        this.channel = exchange.getRequestChannel();
        if (this.channel == null) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
    }

    @Override
    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public void receiveFullString(Receiver.FullStringCallback callback, Receiver.ErrorCallback errorCallback) {
        this.receiveFullString(callback, errorCallback, StandardCharsets.ISO_8859_1);
    }

    @Override
    public void receiveFullString(Receiver.FullStringCallback callback) {
        this.receiveFullString(callback, END_EXCHANGE, StandardCharsets.ISO_8859_1);
    }

    @Override
    public void receivePartialString(Receiver.PartialStringCallback callback, Receiver.ErrorCallback errorCallback) {
        this.receivePartialString(callback, errorCallback, StandardCharsets.ISO_8859_1);
    }

    @Override
    public void receivePartialString(Receiver.PartialStringCallback callback) {
        this.receivePartialString(callback, END_EXCHANGE, StandardCharsets.ISO_8859_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveFullString(final Receiver.FullStringCallback callback, Receiver.ErrorCallback errorCallback, final Charset charset) {
        ByteArrayOutputStream sb;
        long contentLength;
        Receiver.ErrorCallback error;
        if (this.done) {
            throw UndertowMessages.MESSAGES.requestBodyAlreadyRead();
        }
        Receiver.ErrorCallback errorCallback2 = error = errorCallback == null ? END_EXCHANGE : errorCallback;
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.exchange.isRequestComplete()) {
            callback.handle(this.exchange, "");
            return;
        }
        String contentLengthString = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
            if (contentLength > Integer.MAX_VALUE) {
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
            sb = new ByteArrayOutputStream((int)contentLength);
        } else {
            contentLength = -1L;
            sb = new ByteArrayOutputStream();
        }
        if (this.maxBufferSize > 0 && contentLength > (long)this.maxBufferSize) {
            error.error(this.exchange, new Receiver.RequestToLargeException());
            return;
        }
        PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().allocate();
        ByteBuffer buffer = pooled.getBuffer();
        try {
            while (true) {
                buffer.clear();
                int res = this.channel.read(buffer);
                if (res == -1) {
                    this.done = true;
                    callback.handle(this.exchange, sb.toString(charset.name()));
                    return;
                }
                if (res == 0) {
                    this.channel.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleEvent(StreamSourceChannel channel) {
                            if (AsyncReceiverImpl.this.done) {
                                return;
                            }
                            PooledByteBuffer pooled = AsyncReceiverImpl.this.exchange.getConnection().getByteBufferPool().allocate();
                            ByteBuffer buffer = pooled.getBuffer();
                            try {
                                while (true) {
                                    buffer.clear();
                                    int res = channel.read(buffer);
                                    if (res == -1) {
                                        AsyncReceiverImpl.this.done = true;
                                        Connectors.executeRootHandler(new HttpHandler(){

                                            @Override
                                            public void handleRequest(HttpServerExchange exchange) throws Exception {
                                                callback.handle(exchange, sb.toString(charset.name()));
                                            }
                                        }, AsyncReceiverImpl.this.exchange);
                                        return;
                                    }
                                    if (res == 0) {
                                        return;
                                    }
                                    buffer.flip();
                                    while (buffer.hasRemaining()) {
                                        sb.write(buffer.get());
                                    }
                                    if (AsyncReceiverImpl.this.maxBufferSize <= 0 || sb.size() <= AsyncReceiverImpl.this.maxBufferSize) continue;
                                    Connectors.executeRootHandler(new HttpHandler(){

                                        @Override
                                        public void handleRequest(HttpServerExchange exchange) throws Exception {
                                            error.error(exchange, new Receiver.RequestToLargeException());
                                        }
                                    }, AsyncReceiverImpl.this.exchange);
                                    return;
                                }
                            }
                            catch (IOException e) {
                                Connectors.executeRootHandler(new HttpHandler(){

                                    @Override
                                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                                        error.error(exchange, e);
                                    }
                                }, AsyncReceiverImpl.this.exchange);
                                return;
                            }
                            finally {
                                pooled.close();
                            }
                        }
                    });
                    this.channel.resumeReads();
                    return;
                }
                buffer.flip();
                while (buffer.hasRemaining()) {
                    sb.write(buffer.get());
                }
                if (this.maxBufferSize <= 0 || sb.size() <= this.maxBufferSize) continue;
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
        }
        catch (IOException e) {
            error.error(this.exchange, e);
            return;
        }
        finally {
            pooled.close();
        }
    }

    @Override
    public void receiveFullString(Receiver.FullStringCallback callback, Charset charset) {
        this.receiveFullString(callback, END_EXCHANGE, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivePartialString(final Receiver.PartialStringCallback callback, Receiver.ErrorCallback errorCallback, Charset charset) {
        long contentLength;
        Receiver.ErrorCallback error;
        if (this.done) {
            throw UndertowMessages.MESSAGES.requestBodyAlreadyRead();
        }
        Receiver.ErrorCallback errorCallback2 = error = errorCallback == null ? END_EXCHANGE : errorCallback;
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.exchange.isRequestComplete()) {
            callback.handle(this.exchange, "", true);
            return;
        }
        String contentLengthString = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
            if (contentLength > Integer.MAX_VALUE) {
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
        } else {
            contentLength = -1L;
        }
        if (this.maxBufferSize > 0 && contentLength > (long)this.maxBufferSize) {
            error.error(this.exchange, new Receiver.RequestToLargeException());
            return;
        }
        final CharsetDecoder decoder = charset.newDecoder();
        PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().allocate();
        ByteBuffer buffer = pooled.getBuffer();
        this.channel.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

            /*
             * Exception decompiling
             */
            @Override
            public void handleEvent(StreamSourceChannel channel) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        try {
            while (true) {
                buffer.clear();
                int res = this.channel.read(buffer);
                if (res == -1) {
                    this.done = true;
                    callback.handle(this.exchange, "", true);
                    return;
                }
                if (res == 0) {
                    this.channel.resumeReads();
                    return;
                }
                buffer.flip();
                CharBuffer cb = decoder.decode(buffer);
                callback.handle(this.exchange, cb.toString(), false);
                if (!this.paused) continue;
                return;
            }
        }
        catch (IOException e) {
            error.error(this.exchange, e);
            return;
        }
        finally {
            pooled.close();
        }
    }

    @Override
    public void receivePartialString(Receiver.PartialStringCallback callback, Charset charset) {
        this.receivePartialString(callback, END_EXCHANGE, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveFullBytes(final Receiver.FullBytesCallback callback, Receiver.ErrorCallback errorCallback) {
        ByteArrayOutputStream sb;
        long contentLength;
        Receiver.ErrorCallback error;
        if (this.done) {
            throw UndertowMessages.MESSAGES.requestBodyAlreadyRead();
        }
        Receiver.ErrorCallback errorCallback2 = error = errorCallback == null ? END_EXCHANGE : errorCallback;
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.exchange.isRequestComplete()) {
            callback.handle(this.exchange, EMPTY_BYTE_ARRAY);
            return;
        }
        String contentLengthString = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
            if (contentLength > Integer.MAX_VALUE) {
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
            sb = new ByteArrayOutputStream((int)contentLength);
        } else {
            contentLength = -1L;
            sb = new ByteArrayOutputStream();
        }
        if (this.maxBufferSize > 0 && contentLength > (long)this.maxBufferSize) {
            error.error(this.exchange, new Receiver.RequestToLargeException());
            return;
        }
        PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().allocate();
        ByteBuffer buffer = pooled.getBuffer();
        try {
            while (true) {
                buffer.clear();
                int res = this.channel.read(buffer);
                if (res == -1) {
                    this.done = true;
                    callback.handle(this.exchange, sb.toByteArray());
                    return;
                }
                if (res == 0) {
                    this.channel.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleEvent(StreamSourceChannel channel) {
                            if (AsyncReceiverImpl.this.done) {
                                return;
                            }
                            PooledByteBuffer pooled = AsyncReceiverImpl.this.exchange.getConnection().getByteBufferPool().allocate();
                            ByteBuffer buffer = pooled.getBuffer();
                            try {
                                while (true) {
                                    buffer.clear();
                                    int res = channel.read(buffer);
                                    if (res == -1) {
                                        AsyncReceiverImpl.this.done = true;
                                        Connectors.executeRootHandler(new HttpHandler(){

                                            @Override
                                            public void handleRequest(HttpServerExchange exchange) throws Exception {
                                                callback.handle(exchange, sb.toByteArray());
                                            }
                                        }, AsyncReceiverImpl.this.exchange);
                                        return;
                                    }
                                    if (res == 0) {
                                        return;
                                    }
                                    buffer.flip();
                                    while (buffer.hasRemaining()) {
                                        sb.write(buffer.get());
                                    }
                                    if (AsyncReceiverImpl.this.maxBufferSize <= 0 || sb.size() <= AsyncReceiverImpl.this.maxBufferSize) continue;
                                    Connectors.executeRootHandler(new HttpHandler(){

                                        @Override
                                        public void handleRequest(HttpServerExchange exchange) throws Exception {
                                            error.error(exchange, new Receiver.RequestToLargeException());
                                        }
                                    }, AsyncReceiverImpl.this.exchange);
                                    return;
                                }
                            }
                            catch (Exception e) {
                                Connectors.executeRootHandler(new HttpHandler(){

                                    @Override
                                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                                        error.error(exchange, new IOException(e));
                                    }
                                }, AsyncReceiverImpl.this.exchange);
                                return;
                            }
                            finally {
                                pooled.close();
                            }
                        }
                    });
                    this.channel.resumeReads();
                    return;
                }
                buffer.flip();
                while (buffer.hasRemaining()) {
                    sb.write(buffer.get());
                }
                if (this.maxBufferSize <= 0 || sb.size() <= this.maxBufferSize) continue;
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
        }
        catch (IOException e) {
            error.error(this.exchange, e);
            return;
        }
        finally {
            pooled.close();
        }
    }

    @Override
    public void receiveFullBytes(Receiver.FullBytesCallback callback) {
        this.receiveFullBytes(callback, END_EXCHANGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivePartialBytes(final Receiver.PartialBytesCallback callback, Receiver.ErrorCallback errorCallback) {
        long contentLength;
        Receiver.ErrorCallback error;
        if (this.done) {
            throw UndertowMessages.MESSAGES.requestBodyAlreadyRead();
        }
        Receiver.ErrorCallback errorCallback2 = error = errorCallback == null ? END_EXCHANGE : errorCallback;
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.exchange.isRequestComplete()) {
            callback.handle(this.exchange, EMPTY_BYTE_ARRAY, true);
            return;
        }
        String contentLengthString = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
            if (contentLength > Integer.MAX_VALUE) {
                error.error(this.exchange, new Receiver.RequestToLargeException());
                return;
            }
        } else {
            contentLength = -1L;
        }
        if (this.maxBufferSize > 0 && contentLength > (long)this.maxBufferSize) {
            error.error(this.exchange, new Receiver.RequestToLargeException());
            return;
        }
        PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().allocate();
        ByteBuffer buffer = pooled.getBuffer();
        this.channel.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

            /*
             * Exception decompiling
             */
            @Override
            public void handleEvent(StreamSourceChannel channel) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        try {
            while (true) {
                buffer.clear();
                int res = this.channel.read(buffer);
                if (res == -1) {
                    this.done = true;
                    callback.handle(this.exchange, EMPTY_BYTE_ARRAY, true);
                    return;
                }
                if (res == 0) {
                    this.channel.resumeReads();
                    return;
                }
                buffer.flip();
                byte[] data2 = new byte[buffer.remaining()];
                buffer.get(data2);
                callback.handle(this.exchange, data2, false);
                if (!this.paused) continue;
                return;
            }
        }
        catch (IOException e) {
            error.error(this.exchange, e);
            return;
        }
        finally {
            pooled.close();
        }
    }

    @Override
    public void receivePartialBytes(Receiver.PartialBytesCallback callback) {
        this.receivePartialBytes(callback, END_EXCHANGE);
    }

    @Override
    public void pause() {
        this.paused = true;
        this.channel.suspendReads();
    }

    @Override
    public void resume() {
        this.paused = false;
        this.channel.wakeupReads();
    }
}

