/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MethodPredicate
implements Predicate {
    private final HttpString[] methods;

    MethodPredicate(String[] methods2) {
        HttpString[] values2 = new HttpString[methods2.length];
        for (int i = 0; i < methods2.length; ++i) {
            values2[i] = HttpString.tryFromString(methods2[i]);
        }
        this.methods = values2;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (!value.getRequestMethod().equals(this.methods[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.methods.length == 1) {
            return "method( '" + this.methods[0] + "' )";
        }
        return "method( {" + Arrays.asList(this.methods).stream().map(s -> s.toString()).collect(Collectors.joining(", ")) + "} )";
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "method";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("value", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] methods2 = (String[])config.get("value");
            return new MethodPredicate(methods2);
        }
    }
}

