/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.compat.rewrite;

import io.undertow.servlet.compat.rewrite.Resolver;
import io.undertow.servlet.compat.rewrite.RewriteMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;

public class Substitution {
    protected SubstitutionElement[] elements = null;
    protected String sub = null;

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(Map<String, RewriteMap> maps) {
        ArrayList<Object> elements = new ArrayList<Object>();
        int pos = 0;
        int percentPos = 0;
        int dollarPos = 0;
        while (pos < this.sub.length()) {
            void var6_21;
            int colon;
            int open;
            percentPos = this.sub.indexOf(37, pos);
            dollarPos = this.sub.indexOf(36, pos);
            if (percentPos == -1 && dollarPos == -1) {
                StaticElement staticElement = new StaticElement();
                staticElement.value = this.sub.substring(pos, this.sub.length());
                pos = this.sub.length();
                elements.add(staticElement);
                continue;
            }
            if (percentPos == -1 || dollarPos != -1 && dollarPos < percentPos) {
                if (dollarPos + 1 == this.sub.length()) {
                    throw new IllegalArgumentException(this.sub);
                }
                if (pos < dollarPos) {
                    StaticElement staticElement = new StaticElement();
                    staticElement.value = this.sub.substring(pos, dollarPos);
                    pos = dollarPos;
                    elements.add(staticElement);
                }
                if (Character.isDigit(this.sub.charAt(dollarPos + 1))) {
                    RewriteRuleBackReferenceElement rewriteRuleBackReferenceElement = new RewriteRuleBackReferenceElement();
                    rewriteRuleBackReferenceElement.n = Character.digit(this.sub.charAt(dollarPos + 1), 10);
                    pos = dollarPos + 2;
                    elements.add(rewriteRuleBackReferenceElement);
                    continue;
                }
                MapElement mapElement = new MapElement();
                open = this.sub.indexOf(123, dollarPos);
                colon = this.sub.indexOf(58, dollarPos);
                int def = this.sub.indexOf(124, dollarPos);
                int close = this.sub.indexOf(125, dollarPos);
                if (-1 >= open || open >= colon || colon >= close) {
                    throw new IllegalArgumentException(this.sub);
                }
                mapElement.map = maps.get(this.sub.substring(open + 1, colon));
                if (mapElement.map == null) {
                    throw new IllegalArgumentException(this.sub + ": No map: " + this.sub.substring(open + 1, colon));
                }
                if (def > -1) {
                    if (colon >= def || def >= close) {
                        throw new IllegalArgumentException(this.sub);
                    }
                    mapElement.key = this.sub.substring(colon + 1, def);
                    mapElement.defaultValue = this.sub.substring(def + 1, close);
                } else {
                    mapElement.key = this.sub.substring(colon + 1, close);
                }
                pos = close + 1;
                elements.add(mapElement);
                continue;
            }
            if (percentPos + 1 == this.sub.length()) {
                throw new IllegalArgumentException(this.sub);
            }
            if (pos < percentPos) {
                StaticElement staticElement = new StaticElement();
                staticElement.value = this.sub.substring(pos, percentPos);
                pos = percentPos;
                elements.add(staticElement);
            }
            if (Character.isDigit(this.sub.charAt(percentPos + 1))) {
                RewriteCondBackReferenceElement rewriteCondBackReferenceElement = new RewriteCondBackReferenceElement();
                rewriteCondBackReferenceElement.n = Character.digit(this.sub.charAt(percentPos + 1), 10);
                pos = percentPos + 2;
                elements.add(rewriteCondBackReferenceElement);
                continue;
            }
            Object var6_15 = null;
            open = this.sub.indexOf(123, percentPos);
            colon = this.sub.indexOf(58, percentPos);
            int close = this.sub.indexOf(125, percentPos);
            if (-1 >= open || open >= close) {
                throw new IllegalArgumentException(this.sub);
            }
            if (colon > -1) {
                if (open >= colon || colon >= close) {
                    throw new IllegalArgumentException(this.sub);
                }
                String type2 = this.sub.substring(open + 1, colon);
                if (type2.equals("ENV")) {
                    ServerVariableEnvElement serverVariableEnvElement = new ServerVariableEnvElement();
                    serverVariableEnvElement.key = this.sub.substring(colon + 1, close);
                } else if (type2.equals("SSL")) {
                    ServerVariableSslElement serverVariableSslElement = new ServerVariableSslElement();
                    serverVariableSslElement.key = this.sub.substring(colon + 1, close);
                } else {
                    if (!type2.equals("HTTP")) throw new IllegalArgumentException(this.sub + ": Bad type: " + type2);
                    ServerVariableHttpElement serverVariableHttpElement = new ServerVariableHttpElement();
                    serverVariableHttpElement.key = this.sub.substring(colon + 1, close);
                }
            } else {
                ServerVariableElement serverVariableElement = new ServerVariableElement();
                serverVariableElement.key = this.sub.substring(open + 1, close);
            }
            pos = close + 1;
            elements.add(var6_21);
        }
        this.elements = elements.toArray(new SubstitutionElement[0]);
    }

    public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.elements.length; ++i) {
            buf.append(this.elements[i].evaluate(rule, cond, resolver));
        }
        return buf.toString();
    }

    public class MapElement
    extends SubstitutionElement {
        public RewriteMap map;
        public String key;
        public String defaultValue;

        public MapElement() {
            this.map = null;
            this.defaultValue = null;
        }

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            String result = this.map.lookup(this.key);
            if (result == null) {
                result = this.defaultValue;
            }
            return result;
        }
    }

    public class ServerVariableHttpElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return resolver.resolveHttp(this.key);
        }
    }

    public class ServerVariableSslElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return resolver.resolveSsl(this.key);
        }
    }

    public class ServerVariableEnvElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return resolver.resolveEnv(this.key);
        }
    }

    public class ServerVariableElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return resolver.resolve(this.key);
        }
    }

    public class RewriteCondBackReferenceElement
    extends SubstitutionElement {
        public int n;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return cond.group(this.n);
        }
    }

    public class RewriteRuleBackReferenceElement
    extends SubstitutionElement {
        public int n;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return rule.group(this.n);
        }
    }

    public class StaticElement
    extends SubstitutionElement {
        public String value;

        @Override
        public String evaluate(Matcher rule, Matcher cond, Resolver resolver) {
            return this.value;
        }
    }

    public abstract class SubstitutionElement {
        public abstract String evaluate(Matcher var1, Matcher var2, Resolver var3);
    }
}

