/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.extensions.ExtensionFunction;
import io.undertow.websockets.extensions.NoopExtensionFunction;
import java.io.IOException;
import java.util.List;

public class CompositeExtensionFunction
implements ExtensionFunction {
    private final ExtensionFunction[] delegates;

    private CompositeExtensionFunction(ExtensionFunction ... delegates) {
        this.delegates = delegates;
    }

    public static ExtensionFunction compose(List<ExtensionFunction> functions2) {
        if (null == functions2) {
            return NoopExtensionFunction.INSTANCE;
        }
        return CompositeExtensionFunction.compose(functions2.toArray(new ExtensionFunction[functions2.size()]));
    }

    public static ExtensionFunction compose(ExtensionFunction ... functions2) {
        if (functions2 == null || functions2.length == 0) {
            return NoopExtensionFunction.INSTANCE;
        }
        if (functions2.length == 1) {
            return functions2[0];
        }
        return new CompositeExtensionFunction(functions2);
    }

    @Override
    public boolean hasExtensionOpCode() {
        for (ExtensionFunction delegate : this.delegates) {
            if (!delegate.hasExtensionOpCode()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int writeRsv(int rsv) {
        for (ExtensionFunction ext : this.delegates) {
            rsv = ext.writeRsv(rsv);
        }
        return rsv;
    }

    @Override
    public PooledByteBuffer transformForWrite(PooledByteBuffer pooledBuffer, StreamSinkFrameChannel channel, boolean lastFrame) throws IOException {
        PooledByteBuffer result = pooledBuffer;
        for (ExtensionFunction delegate : this.delegates) {
            result = delegate.transformForWrite(result, channel, lastFrame);
        }
        return result;
    }

    @Override
    public PooledByteBuffer transformForRead(PooledByteBuffer pooledBuffer, StreamSourceFrameChannel channel, boolean lastFragementOfMessage) throws IOException {
        PooledByteBuffer result = pooledBuffer;
        for (ExtensionFunction delegate : this.delegates) {
            result = delegate.transformForRead(result, channel, lastFragementOfMessage);
        }
        return result;
    }

    @Override
    public void dispose() {
        for (ExtensionFunction delegate : this.delegates) {
            delegate.dispose();
        }
    }
}

