/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.foldright.cffu.CffuFactory;
import io.foldright.cffu.CffuState;
import io.foldright.cffu.CompletableFutureUtils;
import io.foldright.cffu.tuple.Tuple2;
import io.foldright.cffu.tuple.Tuple3;
import io.foldright.cffu.tuple.Tuple4;
import io.foldright.cffu.tuple.Tuple5;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public final class Cffu<T>
implements Future<T>,
CompletionStage<T> {
    @NonNull
    private final CffuFactory fac;
    private final boolean isMinimalStage;
    @NonNull
    private final CompletableFuture<T> cf;

    Cffu(CffuFactory cffuFactory, boolean isMinimalStage, CompletableFuture<T> cf) {
        this.fac = Objects.requireNonNull(cffuFactory, "cffuFactory is null");
        this.isMinimalStage = isMinimalStage;
        this.cf = Objects.requireNonNull(cf, "cf is null");
    }

    @Contract(pure=true)
    private <U> Cffu<U> reset0(CompletableFuture<U> cf) {
        return new Cffu<U>(this.fac, this.isMinimalStage, cf);
    }

    @Contract(pure=true)
    private <U> Cffu<U> resetToMin(CompletableFuture<U> cf) {
        return new Cffu<U>(this.fac, true, cf);
    }

    public Cffu<Void> thenRun(Runnable action) {
        return this.reset0((CompletableFuture)this.cf.thenRun(action));
    }

    public Cffu<Void> thenRunAsync(Runnable action) {
        return this.reset0((CompletableFuture)this.cf.thenRunAsync(action, this.fac.defaultExecutor()));
    }

    public Cffu<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.thenRunAsync(action, executor));
    }

    public Cffu<Void> thenAccept(Consumer<? super T> action) {
        return this.reset0((CompletableFuture)this.cf.thenAccept((Consumer)action));
    }

    public Cffu<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.thenAcceptAsync((Consumer)action, this.fac.defaultExecutor());
    }

    public Cffu<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.thenAcceptAsync((Consumer)action, executor));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenRun`")
    public <U> Cffu<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.thenApply(fn));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenRunAsync`")
    public <U> Cffu<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, this.fac.defaultExecutor());
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenRunAsync`")
    public <U> Cffu<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.thenApplyAsync(fn, executor));
    }

    public Cffu<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.reset0((CompletableFuture)this.cf.runAfterBoth((CompletionStage)other, action));
    }

    public Cffu<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothAsync((CompletionStage)other, action, this.fac.defaultExecutor());
    }

    public Cffu<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    public <U> Cffu<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.reset0((CompletableFuture<U>)this.cf.thenAcceptBoth(other, (BiConsumer)action));
    }

    public <U> Cffu<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, this.fac.defaultExecutor());
    }

    public <U> Cffu<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.thenAcceptBothAsync(other, (BiConsumer)action, executor));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenAcceptBoth`")
    public <U, V> Cffu<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.thenCombine(other, fn));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenAcceptBothAsync`")
    public <U, V> Cffu<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.thenCombineAsync((CompletionStage)other, (BiFunction)fn, this.fac.defaultExecutor());
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenAcceptBothAsync`")
    public <U, V> Cffu<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.thenCombineAsync(other, fn, executor));
    }

    @Contract(pure=true)
    public <T2> Cffu<Tuple2<T, T2>> cffuCombine(Cffu<T2> cf2) {
        return this.fac.cffuCombine(this, cf2);
    }

    @Contract(pure=true)
    public <T2> Cffu<Tuple2<T, T2>> cffuCombine(CompletableFuture<T2> cf2) {
        return this.fac.cffuCombine(this.toCompletableFuture(), cf2);
    }

    @Contract(pure=true)
    public <T2, T3> Cffu<Tuple3<T, T2, T3>> cffuCombine(Cffu<T2> cf2, Cffu<T3> cf3) {
        return this.fac.cffuCombine(this, cf2, cf3);
    }

    @Contract(pure=true)
    public <T2, T3> Cffu<Tuple3<T, T2, T3>> cffuCombine(CompletableFuture<T2> cf2, CompletableFuture<T3> cf3) {
        return this.fac.cffuCombine(this.toCompletableFuture(), cf2, cf3);
    }

    @Contract(pure=true)
    public <T2, T3, T4> Cffu<Tuple4<T, T2, T3, T4>> cffuCombine(Cffu<T2> cf2, Cffu<T3> cf3, Cffu<T4> cf4) {
        return this.fac.cffuCombine(this, cf2, cf3, cf4);
    }

    @Contract(pure=true)
    public <T2, T3, T4> Cffu<Tuple4<T, T2, T3, T4>> cffuCombine(CompletableFuture<T2> cf2, CompletableFuture<T3> cf3, CompletableFuture<T4> cf4) {
        return this.fac.cffuCombine(this.toCompletableFuture(), cf2, cf3, cf4);
    }

    @Contract(pure=true)
    public <T2, T3, T4, T5> Cffu<Tuple5<T, T2, T3, T4, T5>> cffuCombine(Cffu<T2> cf2, Cffu<T3> cf3, Cffu<T4> cf4, Cffu<T5> cf5) {
        return this.fac.cffuCombine(this, cf2, cf3, cf4, cf5);
    }

    @Contract(pure=true)
    public <T2, T3, T4, T5> Cffu<Tuple5<T, T2, T3, T4, T5>> cffuCombine(CompletableFuture<T2> cf2, CompletableFuture<T3> cf3, CompletableFuture<T4> cf4, CompletableFuture<T5> cf5) {
        return this.fac.cffuCombine(this.toCompletableFuture(), cf2, cf3, cf4, cf5);
    }

    public Cffu<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.reset0((CompletableFuture)this.cf.runAfterEither((CompletionStage)other, action));
    }

    public Cffu<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync((CompletionStage)other, action, this.fac.defaultExecutor());
    }

    public Cffu<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    public Cffu<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.reset0((CompletableFuture)this.cf.acceptEither((CompletionStage)other, (Consumer)action));
    }

    public Cffu<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.acceptEitherAsync((CompletionStage)other, (Consumer)action, this.fac.defaultExecutor());
    }

    public Cffu<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `acceptEither`")
    public <U> Cffu<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.applyToEither((CompletionStage)other, fn));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `acceptEitherAsync`")
    public <U> Cffu<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)fn, this.fac.defaultExecutor());
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `acceptEitherAsync`")
    public <U> Cffu<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.applyToEitherAsync((CompletionStage)other, fn, executor));
    }

    @Override
    public Cffu<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.reset0((CompletableFuture)this.cf.exceptionally(fn));
    }

    @Override
    public Cffu<T> exceptionallyAsync(Function<Throwable, ? extends T> fn) {
        return this.exceptionallyAsync((Function)fn, this.fac.defaultExecutor());
    }

    @Override
    public Cffu<T> exceptionallyAsync(Function<Throwable, ? extends T> fn, Executor executor) {
        return this.reset0(CompletableFutureUtils.exceptionallyAsync(this.cf, fn, executor));
    }

    public Cffu<T> orTimeout(long timeout, TimeUnit unit) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        CompletableFutureUtils.orTimeout(this.cf, timeout, unit);
        return this;
    }

    public Cffu<T> completeOnTimeout(@Nullable T value, long timeout, TimeUnit unit) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        CompletableFutureUtils.completeOnTimeout(this.cf, value, timeout, unit);
        return this;
    }

    @Override
    public <U> Cffu<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.thenCompose(fn));
    }

    @Override
    public <U> Cffu<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync((Function)fn, this.fac.defaultExecutor());
    }

    @Override
    public <U> Cffu<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.thenComposeAsync(fn, executor));
    }

    @Override
    public Cffu<T> exceptionallyCompose(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return this.reset0(CompletableFutureUtils.exceptionallyCompose(this.cf, fn));
    }

    @Override
    public Cffu<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return this.exceptionallyComposeAsync((Function)fn, this.fac.defaultExecutor());
    }

    @Override
    public Cffu<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        return this.reset0(CompletableFutureUtils.exceptionallyComposeAsync(this.cf, fn, executor));
    }

    @Override
    public Cffu<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.reset0((CompletableFuture)this.cf.whenComplete(action));
    }

    @Override
    public Cffu<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.whenCompleteAsync((BiConsumer)action, this.fac.defaultExecutor());
    }

    @Override
    public Cffu<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.whenCompleteAsync(action, executor));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `whenComplete`")
    public <U> Cffu<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.handle(fn));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `whenCompleteAsync`")
    public <U> Cffu<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.handleAsync((BiFunction)fn, this.fac.defaultExecutor());
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `whenCompleteAsync`")
    public <U> Cffu<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.handleAsync(fn, executor));
    }

    @Override
    @Blocking
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.get();
    }

    @Override
    @Blocking
    @Nullable
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.get(timeout, unit);
    }

    @Blocking
    @Nullable
    public T join() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.join();
    }

    @Blocking
    @Nullable
    public T cffuJoin(long timeout, TimeUnit unit) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return CompletableFutureUtils.cffuJoin(this.cf, timeout, unit);
    }

    @Contract(pure=true)
    @Nullable
    public T getNow(T valueIfAbsent) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.getNow(valueIfAbsent);
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public T resultNow() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return CompletableFutureUtils.resultNow(this.cf);
    }

    @Override
    @Contract(pure=true)
    public Throwable exceptionNow() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return CompletableFutureUtils.exceptionNow(this.cf);
    }

    @Override
    @Contract(pure=true)
    public boolean isDone() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.isDone();
    }

    @Contract(pure=true)
    public boolean isCompletedExceptionally() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.isCompletedExceptionally();
    }

    @Override
    @Contract(pure=true)
    public boolean isCancelled() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.isCancelled();
    }

    @Override
    @Contract(pure=true)
    public Future.State state() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.state();
    }

    @Contract(pure=true)
    public CffuState cffuState() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return CompletableFutureUtils.cffuState(this.cf);
    }

    public boolean complete(@Nullable T value) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.complete(value);
    }

    public Cffu<T> completeAsync(Supplier<? extends T> supplier) {
        return this.completeAsync(supplier, this.fac.defaultExecutor());
    }

    public Cffu<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        CompletableFutureUtils.completeAsync(this.cf, supplier, executor);
        return this;
    }

    public boolean completeExceptionally(Throwable ex) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.completeExceptionally(ex);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.cancel(mayInterruptIfRunning);
    }

    @Contract(pure=true)
    public CompletionStage<T> minimalCompletionStage() {
        return this.resetToMin((CompletableFuture)CompletableFutureUtils.minimalCompletionStage(this.cf));
    }

    @Contract(pure=true)
    public Cffu<T> resetCffuFactory(CffuFactory cffuFactory) {
        return new Cffu<T>(cffuFactory, this.isMinimalStage, this.cf);
    }

    @Override
    @Contract(pure=true)
    public CompletableFuture<T> toCompletableFuture() {
        return this.cf.toCompletableFuture();
    }

    @Contract(pure=true)
    public Cffu<T> copy() {
        return this.reset0(CompletableFutureUtils.copy(this.cf));
    }

    @Contract(pure=true)
    public Executor defaultExecutor() {
        return this.fac.defaultExecutor();
    }

    @Contract(pure=true)
    public CffuFactory cffuFactory() {
        return this.fac;
    }

    @Contract(pure=true)
    public boolean forbidObtrudeMethods() {
        return this.fac.forbidObtrudeMethods();
    }

    @Contract(pure=true)
    public boolean isMinimalStage() {
        return this.isMinimalStage;
    }

    @Contract(pure=true)
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public CompletableFuture<T> cffuUnwrap() {
        return this.cf;
    }

    @Contract(pure=true)
    public int getNumberOfDependents() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        return this.cf.getNumberOfDependents();
    }

    public void obtrudeValue(@Nullable T value) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        if (this.fac.forbidObtrudeMethods()) {
            throw new UnsupportedOperationException("obtrudeValue is forbidden by cffu");
        }
        this.cf.obtrudeValue(value);
    }

    public void obtrudeException(Throwable ex) {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this a minimal stage");
        }
        if (this.fac.forbidObtrudeMethods()) {
            throw new UnsupportedOperationException("obtrudeException is forbidden by cffu");
        }
        this.cf.obtrudeException(ex);
    }

    @Contract(pure=true)
    public <U> Cffu<U> newIncompleteFuture() {
        return this.reset0(CompletableFutureUtils.newIncompleteFuture(this.cf));
    }

    @Contract(pure=true)
    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "(" + this.cf + ")";
    }
}

