/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import io.foldright.cffu.Cffu;
import io.foldright.cffu.CompletableFutureUtils;
import io.foldright.cffu.tuple.Tuple2;
import io.foldright.cffu.tuple.Tuple3;
import io.foldright.cffu.tuple.Tuple4;
import io.foldright.cffu.tuple.Tuple5;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@Immutable
@ThreadSafe
public final class CffuFactory {
    @NonNull
    private final Executor defaultExecutor;
    private final boolean forbidObtrudeMethods;

    CffuFactory(Executor defaultExecutor, boolean forbidObtrudeMethods) {
        this.defaultExecutor = CompletableFutureUtils.screenExecutor(defaultExecutor);
        this.forbidObtrudeMethods = forbidObtrudeMethods;
    }

    @Contract(pure=true)
    private <T> Cffu<T> new0(CompletableFuture<T> cf) {
        return new Cffu<T>(this, false, cf);
    }

    @Contract(pure=true)
    private <T> Cffu<T> newMin(CompletableFuture<T> cf) {
        return new Cffu<T>(this, true, cf);
    }

    @Contract(pure=true)
    public <T> Cffu<T> completedFuture(@Nullable T value) {
        return this.new0(CompletableFuture.completedFuture(value));
    }

    @Contract(pure=true)
    public <T> CompletionStage<T> completedStage(@Nullable T value) {
        return this.newMin((CompletableFuture)CompletableFutureUtils.completedStage(value));
    }

    @Contract(pure=true)
    public <T> Cffu<T> failedFuture(Throwable ex) {
        return this.new0(CompletableFutureUtils.failedFuture(ex));
    }

    @Contract(pure=true)
    public <T> CompletionStage<T> failedStage(Throwable ex) {
        return this.newMin((CompletableFuture)CompletableFutureUtils.failedStage(ex));
    }

    @Contract(pure=true)
    private <T> Cffu<T> dummy() {
        return this.completedFuture(null);
    }

    public Cffu<Void> runAsync(Runnable action) {
        return this.dummy().thenRunAsync(action);
    }

    public Cffu<Void> runAsync(Runnable action, Executor executor) {
        return this.dummy().thenRunAsync(action, executor);
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `runAsync`")
    public <T> Cffu<T> supplyAsync(Supplier<T> supplier) {
        return this.dummy().thenApplyAsync(unused -> supplier.get());
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `runAsync`")
    public <T> Cffu<T> supplyAsync(Supplier<T> supplier, Executor executor) {
        return this.dummy().thenApplyAsync(unused -> supplier.get(), executor);
    }

    @Contract(pure=true)
    public <T> Cffu<T> newIncompleteCffu() {
        return this.new0(new CompletableFuture());
    }

    @Contract(pure=true)
    public <T> Cffu<T> asCffu(CompletionStage<T> stage) {
        Objects.requireNonNull(stage, "stage is null");
        if ("java.util.concurrent.CompletableFuture$MinimalStage".equals(stage.getClass().getName())) {
            return this.newMin((CompletableFuture)stage);
        }
        if (stage instanceof CompletableFuture) {
            return this.new0((CompletableFuture)stage);
        }
        if (stage instanceof Cffu) {
            return ((Cffu)stage).resetCffuFactory(this);
        }
        return this.new0(stage.toCompletableFuture());
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<T>[] asCffuArray(CompletionStage<T> ... stages) {
        Cffu[] ret = new Cffu[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            ret[i] = this.asCffu(Objects.requireNonNull(stages[i], "stage" + i + " is null"));
        }
        return ret;
    }

    @Contract(pure=true)
    public Cffu<Void> allOf(Cffu<?> ... cfs) {
        return this.allOf(CffuFactory.toCompletableFutureArray(cfs));
    }

    @Contract(pure=true)
    public Cffu<Void> allOf(CompletableFuture<?> ... cfs) {
        return this.new0(CompletableFuture.allOf(cfs));
    }

    @Contract(pure=true)
    public Cffu<Void> allOf() {
        return this.dummy();
    }

    @Contract(pure=true)
    public Cffu<Void> allOfFastFail(Cffu<?> ... cfs) {
        return this.allOfFastFail(CffuFactory.toCompletableFutureArray(cfs));
    }

    @Contract(pure=true)
    public Cffu<Void> allOfFastFail(CompletableFuture<?> ... cfs) {
        return this.new0(CompletableFutureUtils.allOfFastFail(cfs));
    }

    @Contract(pure=true)
    public Cffu<Void> allOfFastFail() {
        return this.new0(CompletableFutureUtils.allOfFastFail(new CompletableFuture[0]));
    }

    @Contract(pure=true)
    public Cffu<Object> anyOf(Cffu<?> ... cfs) {
        return this.anyOf(CffuFactory.toCompletableFutureArray(cfs));
    }

    @Contract(pure=true)
    public Cffu<Object> anyOf(CompletableFuture<?> ... cfs) {
        return this.new0(CompletableFuture.anyOf(cfs));
    }

    @Contract(pure=true)
    public Cffu<Object> anyOf() {
        return this.newIncompleteCffu();
    }

    public Cffu<Object> anyOfSuccess(Cffu<?> ... cfs) {
        return this.anyOfSuccess(CffuFactory.toCompletableFutureArray(cfs));
    }

    public Cffu<Object> anyOfSuccess(CompletableFuture<?> ... cfs) {
        return this.new0(CompletableFutureUtils.anyOfSuccess(cfs));
    }

    public Cffu<Object> anyOfSuccess() {
        return this.new0(CompletableFutureUtils.anyOfSuccess(new CompletableFuture[0]));
    }

    @Contract(pure=true)
    public Executor delayedExecutor(long delay, TimeUnit unit) {
        return CompletableFutureUtils.delayedExecutor(delay, unit, this.defaultExecutor);
    }

    @Contract(pure=true)
    public Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        return CompletableFutureUtils.delayedExecutor(delay, unit, executor);
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<List<T>> cffuAllOf(Cffu<T> ... cfs) {
        return this.cffuAllOf(CffuFactory.toCompletableFutureArray(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<List<T>> cffuAllOf(CompletableFuture<T> ... cfs) {
        return this.new0(CompletableFutureUtils.allOfWithResult(cfs));
    }

    @Contract(pure=true)
    public <T> Cffu<List<T>> cffuAllOf() {
        return this.new0(CompletableFutureUtils.allOfWithResult(new CompletableFuture[0]));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<List<T>> cffuAllOfFastFail(Cffu<T> ... cfs) {
        return this.cffuAllOfFastFail(CffuFactory.toCompletableFutureArray(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<List<T>> cffuAllOfFastFail(CompletableFuture<T> ... cfs) {
        return this.new0(CompletableFutureUtils.allOfFastFailWithResult(cfs));
    }

    @Contract(pure=true)
    public <T> Cffu<List<T>> cffuAllOfFastFail() {
        return this.new0(CompletableFutureUtils.allOfFastFailWithResult(new CompletableFuture[0]));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<T> cffuAnyOf(Cffu<T> ... cfs) {
        return this.cffuAnyOf(CffuFactory.toCompletableFutureArray(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<T> cffuAnyOf(CompletableFuture<T> ... cfs) {
        return this.new0(CompletableFutureUtils.anyOfWithType(cfs));
    }

    @Contract(pure=true)
    public <T> Cffu<T> cffuAnyOf() {
        return this.newIncompleteCffu();
    }

    @SafeVarargs
    public final <T> Cffu<T> cffuAnyOfSuccess(Cffu<T> ... cfs) {
        return this.cffuAnyOfSuccess(CffuFactory.toCompletableFutureArray(cfs));
    }

    @SafeVarargs
    public final <T> Cffu<T> cffuAnyOfSuccess(CompletableFuture<T> ... cfs) {
        return this.new0(CompletableFutureUtils.anyOfSuccessWithType(cfs));
    }

    public <T> Cffu<T> cffuAnyOfSuccess() {
        return this.new0(CompletableFutureUtils.anyOfSuccessWithType(new CompletableFuture[0]));
    }

    @Contract(pure=true)
    public <T1, T2> Cffu<Tuple2<T1, T2>> cffuCombine(Cffu<T1> cf1, Cffu<T2> cf2) {
        return this.cffuCombine(cf1.toCompletableFuture(), cf2.toCompletableFuture());
    }

    @Contract(pure=true)
    public <T1, T2> Cffu<Tuple2<T1, T2>> cffuCombine(CompletableFuture<T1> cf1, CompletableFuture<T2> cf2) {
        return this.new0(CompletableFutureUtils.combine(cf1, cf2));
    }

    @Contract(pure=true)
    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> cffuCombine(Cffu<T1> cf1, Cffu<T2> cf2, Cffu<T3> cf3) {
        return this.cffuCombine(cf1.toCompletableFuture(), cf2.toCompletableFuture(), cf3.toCompletableFuture());
    }

    @Contract(pure=true)
    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> cffuCombine(CompletableFuture<T1> cf1, CompletableFuture<T2> cf2, CompletableFuture<T3> cf3) {
        return this.new0(CompletableFutureUtils.combine(cf1, cf2, cf3));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> cffuCombine(Cffu<T1> cf1, Cffu<T2> cf2, Cffu<T3> cf3, Cffu<T4> cf4) {
        return this.cffuCombine(cf1.toCompletableFuture(), cf2.toCompletableFuture(), cf3.toCompletableFuture(), cf4.toCompletableFuture());
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> cffuCombine(CompletableFuture<T1> cf1, CompletableFuture<T2> cf2, CompletableFuture<T3> cf3, CompletableFuture<T4> cf4) {
        return this.new0(CompletableFutureUtils.combine(cf1, cf2, cf3, cf4));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> cffuCombine(Cffu<T1> cf1, Cffu<T2> cf2, Cffu<T3> cf3, Cffu<T4> cf4, Cffu<T5> cf5) {
        return this.cffuCombine(cf1.toCompletableFuture(), cf2.toCompletableFuture(), cf3.toCompletableFuture(), cf4.toCompletableFuture(), cf5.toCompletableFuture());
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> cffuCombine(CompletableFuture<T1> cf1, CompletableFuture<T2> cf2, CompletableFuture<T3> cf3, CompletableFuture<T4> cf4, CompletableFuture<T5> cf5) {
        return this.new0(CompletableFutureUtils.combine(cf1, cf2, cf3, cf4, cf5));
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] toCompletableFutureArray(CompletionStage<T> ... stages) {
        CompletableFuture[] ret = new CompletableFuture[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            ret[i] = Objects.requireNonNull(stages[i], "stage" + i + " is null").toCompletableFuture();
        }
        return ret;
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] cffuArrayUnwrap(Cffu<T> ... cfs) {
        CompletableFuture[] ret = new CompletableFuture[cfs.length];
        for (int i = 0; i < cfs.length; ++i) {
            ret[i] = Objects.requireNonNull(cfs[i], "cf" + i + " is null").cffuUnwrap();
        }
        return ret;
    }

    @Contract(pure=true)
    public static <T> Cffu<T>[] cffuListToArray(List<Cffu<T>> cffuList) {
        return cffuList.toArray(new Cffu[0]);
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] completableFutureListToArray(List<CompletableFuture<T>> cfList) {
        return cfList.toArray(new CompletableFuture[0]);
    }

    @Contract(pure=true)
    public Executor defaultExecutor() {
        return this.defaultExecutor;
    }

    @Contract(pure=true)
    public boolean forbidObtrudeMethods() {
        return this.forbidObtrudeMethods;
    }
}

