/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import io.foldright.cffu.CffuFactory;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@ThreadSafe
public final class CffuFactoryBuilder {
    @NonNull
    private final Executor defaultExecutor;
    private volatile boolean forbidObtrudeMethods = false;

    private CffuFactoryBuilder(Executor defaultExecutor) {
        this.defaultExecutor = Objects.requireNonNull(defaultExecutor, "defaultExecutor is null");
    }

    @Contract(pure=true)
    public static CffuFactoryBuilder newCffuFactoryBuilder(Executor defaultExecutor) {
        return new CffuFactoryBuilder(Objects.requireNonNull(defaultExecutor, "defaultExecutor is null"));
    }

    public CffuFactoryBuilder forbidObtrudeMethods(boolean forbid) {
        this.forbidObtrudeMethods = forbid;
        return this;
    }

    @Contract(pure=true)
    public CffuFactory build() {
        return new CffuFactory(this.defaultExecutor, this.forbidObtrudeMethods);
    }
}

