/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import io.foldright.cffu.Cffu;
import io.foldright.cffu.CompletableFutureUtils;
import io.foldright.cffu.tuple.Tuple2;
import io.foldright.cffu.tuple.Tuple3;
import io.foldright.cffu.tuple.Tuple4;
import io.foldright.cffu.tuple.Tuple5;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@ThreadSafe
public final class CffuFactory {
    @NonNull
    private final Executor defaultExecutor;
    private final boolean forbidObtrudeMethods;

    CffuFactory(Executor defaultExecutor, boolean forbidObtrudeMethods) {
        this.defaultExecutor = CompletableFutureUtils.screenExecutor(defaultExecutor);
        this.forbidObtrudeMethods = forbidObtrudeMethods;
    }

    @Contract(pure=true)
    private <T> Cffu<T> new0(CompletableFuture<T> cf) {
        return new Cffu<T>(this, false, cf);
    }

    @Contract(pure=true)
    private <T> Cffu<T> newMin(CompletableFuture<T> cf) {
        return new Cffu<T>(this, true, cf);
    }

    @Contract(pure=true)
    public <T> Cffu<T> completedFuture(@Nullable T value) {
        return this.new0(CompletableFuture.completedFuture(value));
    }

    @Contract(pure=true)
    public <T> CompletionStage<T> completedStage(@Nullable T value) {
        return this.newMin((CompletableFuture)CompletableFutureUtils.completedStage(value));
    }

    @Contract(pure=true)
    public <T> Cffu<T> failedFuture(Throwable ex) {
        return this.new0(CompletableFutureUtils.failedFuture(ex));
    }

    @Contract(pure=true)
    public <T> CompletionStage<T> failedStage(Throwable ex) {
        return this.newMin((CompletableFuture)CompletableFutureUtils.failedStage(ex));
    }

    @Contract(pure=true)
    private Cffu<Void> dummy() {
        return this.completedFuture(null);
    }

    public Cffu<Void> runAsync(Runnable action) {
        return this.dummy().thenRunAsync(action);
    }

    public Cffu<Void> runAsync(Runnable action, Executor executor) {
        return this.dummy().thenRunAsync(action, executor);
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `runAsync`")
    public <T> Cffu<T> supplyAsync(Supplier<T> supplier) {
        return this.dummy().thenApplyAsync(unused -> supplier.get());
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `runAsync`")
    public <T> Cffu<T> supplyAsync(Supplier<T> supplier, Executor executor) {
        return this.dummy().thenApplyAsync(unused -> supplier.get(), executor);
    }

    @Contract(pure=true)
    public <T> Cffu<T> newIncompleteCffu() {
        return this.new0(new CompletableFuture());
    }

    @Contract(pure=true)
    public <T> Cffu<T> asCffu(CompletionStage<T> stage) {
        Objects.requireNonNull(stage, "stage is null");
        if ("java.util.concurrent.CompletableFuture$MinimalStage".equals(stage.getClass().getName())) {
            return this.newMin((CompletableFuture)stage);
        }
        if (stage instanceof CompletableFuture) {
            return this.new0((CompletableFuture)stage);
        }
        if (stage instanceof Cffu) {
            return ((Cffu)stage).resetCffuFactory(this);
        }
        return this.new0(stage.toCompletableFuture());
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<T>[] asCffuArray(CompletionStage<T> ... stages) {
        Cffu[] ret = new Cffu[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            ret[i] = this.asCffu(Objects.requireNonNull(stages[i], "stage" + (i + 1) + " is null"));
        }
        return ret;
    }

    @Contract(pure=true)
    public Cffu<Void> allOf(CompletionStage<?> ... cfs) {
        return this.new0(CompletableFuture.allOf(CffuFactory.toCompletableFutureArray(cfs)));
    }

    @Contract(pure=true)
    public Cffu<Void> allOfFastFail(CompletionStage<?> ... cfs) {
        return this.new0(CompletableFutureUtils.allOfFastFail(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<List<T>> allResultsOf(CompletionStage<? extends T> ... cfs) {
        return this.new0(CompletableFutureUtils.allResultsOf(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<List<T>> allResultsOfFastFail(CompletionStage<? extends T> ... cfs) {
        return this.new0(CompletableFutureUtils.allResultsOfFastFail(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<T> anyOf(CompletionStage<? extends T> ... cfs) {
        return this.new0(CompletableFutureUtils.anyOf(cfs));
    }

    @SafeVarargs
    public final <T> Cffu<T> anyOfSuccess(CompletionStage<? extends T> ... cfs) {
        return this.new0(CompletableFutureUtils.anyOfSuccess(cfs));
    }

    @Contract(pure=true)
    public <T1, T2> Cffu<Tuple2<T1, T2>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return this.new0(CompletableFutureUtils.allTupleOf(cf1, cf2));
    }

    @Contract(pure=true)
    public <T1, T2> Cffu<Tuple2<T1, T2>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return this.new0(CompletableFutureUtils.allTupleOfFastFail(cf1, cf2));
    }

    @Contract(pure=true)
    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return this.new0(CompletableFutureUtils.allTupleOf(cf1, cf2, cf3));
    }

    @Contract(pure=true)
    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return this.new0(CompletableFutureUtils.allTupleOfFastFail(cf1, cf2, cf3));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return this.new0(CompletableFutureUtils.allTupleOf(cf1, cf2, cf3, cf4));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return this.new0(CompletableFutureUtils.allTupleOfFastFail(cf1, cf2, cf3, cf4));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return this.new0(CompletableFutureUtils.allTupleOf(cf1, cf2, cf3, cf4, cf5));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return this.new0(CompletableFutureUtils.allTupleOfFastFail(cf1, cf2, cf3, cf4, cf5));
    }

    @Contract(pure=true)
    public Executor delayedExecutor(long delay, TimeUnit unit) {
        return CompletableFutureUtils.delayedExecutor(delay, unit, this.defaultExecutor);
    }

    @Contract(pure=true)
    public Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        return CompletableFutureUtils.delayedExecutor(delay, unit, executor);
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] toCompletableFutureArray(CompletionStage<T> ... stages) {
        CompletableFuture[] ret = new CompletableFuture[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            ret[i] = Objects.requireNonNull(stages[i], "stage" + (i + 1) + " is null").toCompletableFuture();
        }
        return ret;
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] cffuArrayUnwrap(Cffu<T> ... cfs) {
        CompletableFuture[] ret = new CompletableFuture[cfs.length];
        for (int i = 0; i < cfs.length; ++i) {
            ret[i] = Objects.requireNonNull(cfs[i], "cf" + (i + 1) + " is null").cffuUnwrap();
        }
        return ret;
    }

    @Contract(pure=true)
    public static <T> Cffu<T>[] cffuListToArray(List<Cffu<T>> cffuList) {
        return cffuList.toArray(new Cffu[0]);
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] completableFutureListToArray(List<CompletableFuture<T>> cfList) {
        return cfList.toArray(new CompletableFuture[0]);
    }

    @Contract(pure=true)
    public Executor defaultExecutor() {
        return this.defaultExecutor;
    }

    @Contract(pure=true)
    public boolean forbidObtrudeMethods() {
        return this.forbidObtrudeMethods;
    }
}

