/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import io.foldright.cffu.CfCompleterBySupplier;
import io.foldright.cffu.CffuFactory;
import io.foldright.cffu.CffuState;
import io.foldright.cffu.DelayedExecutor;
import io.foldright.cffu.Delayer;
import io.foldright.cffu.FutureCanceller;
import io.foldright.cffu.NoCfsProvidedException;
import io.foldright.cffu.tuple.Tuple2;
import io.foldright.cffu.tuple.Tuple3;
import io.foldright.cffu.tuple.Tuple4;
import io.foldright.cffu.tuple.Tuple5;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public final class CompletableFutureUtils {
    private static final boolean USE_COMMON_POOL;
    private static final boolean IS_JAVA9_PLUS;
    private static final boolean IS_JAVA12_PLUS;
    private static final boolean IS_JAVA19_PLUS;

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<List<T>> allResultsOf(CompletionStage<? extends T> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cfs);
        int size = cfs.length;
        if (size == 0) {
            return CompletableFuture.completedFuture(CompletableFutureUtils.arrayList(new Object[0]));
        }
        if (size == 1) {
            return CompletableFutureUtils.csToListCf(cfs[0]);
        }
        Object[] result = new Object[size];
        CompletableFuture[] collectResultCfs = new CompletableFuture[size];
        int i = 0;
        while (i < size) {
            int index = i++;
            collectResultCfs[index] = cfs[index].thenAccept(v -> {
                result[index] = v;
            }).toCompletableFuture();
        }
        return CompletableFuture.allOf(collectResultCfs).thenApply(unused -> CompletableFutureUtils.arrayList(result));
    }

    @Contract(pure=true)
    public static CompletableFuture<Void> allOfFastFail(CompletionStage<?> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cfs);
        int size = cfs.length;
        if (size == 0) {
            return CompletableFuture.completedFuture(null);
        }
        if (size == 1) {
            return cfs[0].thenApply(v -> null).toCompletableFuture();
        }
        CompletableFuture[] successOrBeIncomplete = new CompletableFuture[size];
        CompletableFuture[] failedOrBeIncomplete = new CompletableFuture[size + 1];
        CompletableFutureUtils.fill(cfs, successOrBeIncomplete, failedOrBeIncomplete);
        failedOrBeIncomplete[size] = CompletableFuture.allOf(successOrBeIncomplete);
        return CompletableFuture.anyOf(failedOrBeIncomplete);
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<List<T>> allResultsOfFastFail(CompletionStage<? extends T> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cfs);
        int size = cfs.length;
        if (size == 0) {
            return CompletableFuture.completedFuture(CompletableFutureUtils.arrayList(new Object[0]));
        }
        if (size == 1) {
            return CompletableFutureUtils.csToListCf(cfs[0]);
        }
        CompletableFuture[] successOrBeIncomplete = new CompletableFuture[size];
        CompletableFuture[] failedOrBeIncomplete = new CompletableFuture[size + 1];
        CompletableFutureUtils.fill(cfs, successOrBeIncomplete, failedOrBeIncomplete);
        failedOrBeIncomplete[size] = CompletableFutureUtils.allResultsOf(successOrBeIncomplete);
        return CompletableFuture.anyOf(failedOrBeIncomplete);
    }

    private static void requireCfsAndEleNonNull(CompletionStage<?> ... cfs) {
        Objects.requireNonNull(cfs, "cfs is null");
        for (int i = 0; i < cfs.length; ++i) {
            Objects.requireNonNull(cfs[i], "cf" + (i + 1) + " is null");
        }
    }

    private static <T> List<T> arrayList(T ... elements) {
        ArrayList<T> ret = new ArrayList<T>(elements.length);
        ret.addAll(Arrays.asList(elements));
        return ret;
    }

    private static <T> CompletableFuture<List<T>> csToListCf(CompletionStage<? extends T> s) {
        return s.thenApply(xva$0 -> CompletableFutureUtils.arrayList(xva$0)).toCompletableFuture();
    }

    private static void fill(CompletionStage[] cfs, CompletableFuture[] successOrBeIncomplete, CompletableFuture[] failedOrBeIncomplete) {
        CompletableFuture incomplete = new CompletableFuture();
        for (int i = 0; i < cfs.length; ++i) {
            CompletionStage cf = cfs[i];
            successOrBeIncomplete[i] = cf.handle((v, ex) -> ex == null ? cf : incomplete).thenCompose(Function.identity()).toCompletableFuture();
            failedOrBeIncomplete[i] = cf.handle((v, ex) -> ex == null ? incomplete : cf).thenCompose(Function.identity()).toCompletableFuture();
        }
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T> anyOf(CompletionStage<? extends T> ... cfs) {
        return CompletableFuture.anyOf(CffuFactory.toCompletableFutureArray(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T> anyOfSuccess(CompletionStage<? extends T> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cfs);
        int size = cfs.length;
        if (size == 0) {
            return CompletableFutureUtils.failedFuture(new NoCfsProvidedException());
        }
        if (size == 1) {
            return CompletableFutureUtils.copy(cfs[0].toCompletableFuture());
        }
        CompletableFuture[] successOrBeIncomplete = new CompletableFuture[size + 1];
        CompletableFuture[] failedOrBeIncomplete = new CompletableFuture[size];
        CompletableFutureUtils.fill(cfs, successOrBeIncomplete, failedOrBeIncomplete);
        successOrBeIncomplete[size] = CompletableFuture.allOf(failedOrBeIncomplete);
        return CompletableFuture.anyOf(successOrBeIncomplete);
    }

    @Contract(pure=true)
    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Object[] result = new Object[2];
        return CompletableFuture.allOf(cf1.thenAccept(t1 -> {
            result[0] = t1;
        }).toCompletableFuture(), cf2.thenAccept(t2 -> {
            result[1] = t2;
        }).toCompletableFuture()).thenApply(unused -> Tuple2.of(result[0], result[1]));
    }

    @Contract(pure=true)
    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Object[] result = new Object[2];
        return CompletableFutureUtils.allOfFastFail(cf1.thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.thenAccept(t2 -> {
            result[1] = t2;
        })).thenApply(unused -> Tuple2.of(result[0], result[1]));
    }

    @Contract(pure=true)
    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2, cf3);
        Object[] result = new Object[3];
        return CompletableFuture.allOf(cf1.thenAccept(t1 -> {
            result[0] = t1;
        }).toCompletableFuture(), cf2.thenAccept(t2 -> {
            result[1] = t2;
        }).toCompletableFuture(), cf3.thenAccept(t3 -> {
            result[2] = t3;
        }).toCompletableFuture()).thenApply(unused -> Tuple3.of(result[0], result[1], result[2]));
    }

    @Contract(pure=true)
    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2, cf3);
        Object[] result = new Object[3];
        return CompletableFutureUtils.allOfFastFail(cf1.thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.thenAccept(t2 -> {
            result[1] = t2;
        }), cf3.thenAccept(t3 -> {
            result[2] = t3;
        })).thenApply(unused -> Tuple3.of(result[0], result[1], result[2]));
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2, cf3, cf4);
        Object[] result = new Object[4];
        return CompletableFuture.allOf(cf1.thenAccept(t1 -> {
            result[0] = t1;
        }).toCompletableFuture(), cf2.thenAccept(t2 -> {
            result[1] = t2;
        }).toCompletableFuture(), cf3.thenAccept(t3 -> {
            result[2] = t3;
        }).toCompletableFuture(), cf4.thenAccept(t4 -> {
            result[3] = t4;
        }).toCompletableFuture()).thenApply(unused -> Tuple4.of(result[0], result[1], result[2], result[3]));
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2, cf3, cf4);
        Object[] result = new Object[4];
        return CompletableFutureUtils.allOfFastFail(cf1.thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.thenAccept(t2 -> {
            result[1] = t2;
        }), cf3.thenAccept(t3 -> {
            result[2] = t3;
        }), cf4.thenAccept(t4 -> {
            result[3] = t4;
        })).thenApply(unused -> Tuple4.of(result[0], result[1], result[2], result[3]));
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2, cf3, cf4, cf5);
        Object[] result = new Object[5];
        return CompletableFuture.allOf(cf1.thenAccept(t1 -> {
            result[0] = t1;
        }).toCompletableFuture(), cf2.thenAccept(t2 -> {
            result[1] = t2;
        }).toCompletableFuture(), cf3.thenAccept(t3 -> {
            result[2] = t3;
        }).toCompletableFuture(), cf4.thenAccept(t4 -> {
            result[3] = t4;
        }).toCompletableFuture(), cf5.thenAccept(t5 -> {
            result[4] = t5;
        }).toCompletableFuture()).thenApply(unused -> Tuple5.of(result[0], result[1], result[2], result[3], result[4]));
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2, cf3, cf4, cf5);
        Object[] result = new Object[5];
        return CompletableFutureUtils.allOfFastFail(cf1.thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.thenAccept(t2 -> {
            result[1] = t2;
        }), cf3.thenAccept(t3 -> {
            result[2] = t3;
        }), cf4.thenAccept(t4 -> {
            result[3] = t4;
        }), cf5.thenAccept(t5 -> {
            result[4] = t5;
        })).thenApply(unused -> Tuple5.of(result[0], result[1], result[2], result[3], result[4]));
    }

    public static CompletableFuture<Void> runAfterBothFastFail(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.allOfFastFail(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenRun(action);
    }

    public static CompletableFuture<Void> runAfterBothFastFailAsync(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.allOfFastFail(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenRunAsync(action);
    }

    public static CompletableFuture<Void> runAfterBothFastFailAsync(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action, Executor executor) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.allOfFastFail(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenRunAsync(action, executor);
    }

    public static <T, U> CompletableFuture<Void> thenAcceptBothFastFail(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiConsumer<? super T, ? super U> action) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        Object[] result = new Object[2];
        return CompletableFutureUtils.allOfFastFail(cf1.toCompletableFuture().thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.toCompletableFuture().thenAccept(t2 -> {
            result[1] = t2;
        })).thenAccept(unused -> action.accept(result[0], result[1]));
    }

    public static <T, U> CompletableFuture<Void> thenAcceptBothFastFailAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiConsumer<? super T, ? super U> action) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        Object[] result = new Object[2];
        return CompletableFutureUtils.allOfFastFail(cf1.toCompletableFuture().thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.toCompletableFuture().thenAccept(t2 -> {
            result[1] = t2;
        })).thenAcceptAsync(unused -> action.accept(result[0], result[1]));
    }

    public static <T, U> CompletableFuture<Void> thenAcceptBothFastFailAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiConsumer<? super T, ? super U> action, Executor executor) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        Object[] result = new Object[2];
        return CompletableFutureUtils.allOfFastFail(cf1.toCompletableFuture().thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.toCompletableFuture().thenAccept(t2 -> {
            result[1] = t2;
        })).thenAcceptAsync(unused -> action.accept(result[0], result[1]), executor);
    }

    public static <T, U, V> CompletableFuture<V> thenCombineFastFail(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiFunction<? super T, ? super U, ? extends V> fn) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(fn, "fn is null");
        Object[] result = new Object[2];
        return CompletableFutureUtils.allOfFastFail(cf1.toCompletableFuture().thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.toCompletableFuture().thenAccept(t2 -> {
            result[1] = t2;
        })).thenApply(unused -> fn.apply(result[0], result[1]));
    }

    public static <T, U, V> CompletableFuture<V> thenCombineFastFailAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiFunction<? super T, ? super U, ? extends V> fn) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(fn, "fn is null");
        Object[] result = new Object[2];
        return CompletableFutureUtils.allOfFastFail(cf1.toCompletableFuture().thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.toCompletableFuture().thenAccept(t2 -> {
            result[1] = t2;
        })).thenApplyAsync(unused -> fn.apply(result[0], result[1]));
    }

    public static <T, U, V> CompletableFuture<V> thenCombineFastFailAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        Object[] result = new Object[2];
        return CompletableFutureUtils.allOfFastFail(cf1.toCompletableFuture().thenAccept(t1 -> {
            result[0] = t1;
        }), cf2.toCompletableFuture().thenAccept(t2 -> {
            result[1] = t2;
        })).thenApplyAsync(unused -> fn.apply(result[0], result[1]), executor);
    }

    public static CompletableFuture<Void> runAfterEitherSuccess(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.anyOfSuccess(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenRun(action);
    }

    public static CompletableFuture<Void> runAfterEitherSuccessAsync(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.anyOfSuccess(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenRunAsync(action);
    }

    public static CompletableFuture<Void> runAfterEitherSuccessAsync(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action, Executor executor) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.anyOfSuccess(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenRunAsync(action, executor);
    }

    public static <T> CompletableFuture<Void> acceptEitherSuccess(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Consumer<? super T> action) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.anyOfSuccess(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenAccept((Consumer)action);
    }

    public static <T> CompletableFuture<Void> acceptEitherSuccessAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Consumer<? super T> action) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.anyOfSuccess(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenAcceptAsync((Consumer)action);
    }

    public static <T> CompletableFuture<Void> acceptEitherSuccessAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Consumer<? super T> action, Executor executor) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.anyOfSuccess(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenAcceptAsync((Consumer)action, executor);
    }

    public static <T, U> CompletableFuture<U> applyToEitherSuccess(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Function<? super T, U> fn) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(fn, "fn is null");
        return CompletableFutureUtils.anyOfSuccess(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenApply(fn);
    }

    public static <T, U> CompletableFuture<U> applyToEitherSuccessAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Function<? super T, U> fn) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(fn, "fn is null");
        return CompletableFutureUtils.anyOfSuccess(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenApplyAsync(fn);
    }

    public static <T, U> CompletableFuture<U> applyToEitherSuccessAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Function<? super T, U> fn, Executor executor) {
        CompletableFutureUtils.requireCfsAndEleNonNull(cf1, cf2);
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.anyOfSuccess(cf1.toCompletableFuture(), cf2.toCompletableFuture()).thenApplyAsync(fn, executor);
    }

    public static <T, C extends CompletionStage<? extends T>> C peek(C cf, BiConsumer<? super T, ? super Throwable> action) {
        cf.whenComplete(action);
        return cf;
    }

    public static <T, C extends CompletionStage<? extends T>> C peekAsync(C cf, BiConsumer<? super T, ? super Throwable> action) {
        cf.whenCompleteAsync(action);
        return cf;
    }

    public static <T, C extends CompletionStage<? extends T>> C peekAsync(C cf, BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        cf.whenCompleteAsync(action, executor);
        return cf;
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.failedFuture(ex);
        }
        CompletableFuture cf = new CompletableFuture();
        cf.completeExceptionally(ex);
        return cf;
    }

    @Contract(pure=true)
    public static <T> CompletionStage<T> completedStage(@Nullable T value) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.completedStage(value);
        }
        return CompletableFuture.completedFuture(value);
    }

    @Contract(pure=true)
    public static <T> CompletionStage<T> failedStage(Throwable ex) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.failedStage(ex);
        }
        CompletableFuture cf = new CompletableFuture();
        cf.completeExceptionally(ex);
        return cf;
    }

    @Contract(pure=true)
    public static Executor delayedExecutor(long delay, TimeUnit unit) {
        return CompletableFutureUtils.delayedExecutor(delay, unit, AsyncPoolHolder.ASYNC_POOL);
    }

    @Contract(pure=true)
    public static Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.delayedExecutor(delay, unit, executor);
        }
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        return new DelayedExecutor(delay, unit, executor);
    }

    public static <T> CompletableFuture<T> exceptionallyAsync(CompletableFuture<T> cf, Function<Throwable, ? extends T> fn) {
        return CompletableFutureUtils.exceptionallyAsync(cf, fn, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T> CompletableFuture<T> exceptionallyAsync(CompletableFuture<T> cf, Function<Throwable, ? extends T> fn, Executor executor) {
        if (IS_JAVA12_PLUS) {
            return cf.exceptionallyAsync(fn, executor);
        }
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        return ((CompletableFuture)cf.handle((r, ex) -> ex == null ? cf : cf.handleAsync((r1, ex1) -> fn.apply((Throwable)ex1), executor))).thenCompose(Function.identity());
    }

    public static <T> CompletableFuture<T> orTimeout(CompletableFuture<T> cf, long timeout, TimeUnit unit) {
        if (IS_JAVA9_PLUS) {
            return cf.orTimeout(timeout, unit);
        }
        Objects.requireNonNull(unit, "unit is null");
        if (!cf.isDone()) {
            ScheduledFuture<?> f = Delayer.delayToTimoutCf(cf, timeout, unit);
            cf.whenComplete((BiConsumer)new FutureCanceller(f));
        }
        return cf;
    }

    public static <T> CompletableFuture<T> completeOnTimeout(CompletableFuture<T> cf, @Nullable T value, long timeout, TimeUnit unit) {
        if (IS_JAVA9_PLUS) {
            return cf.completeOnTimeout(value, timeout, unit);
        }
        Objects.requireNonNull(unit, "unit is null");
        if (!cf.isDone()) {
            ScheduledFuture<?> f = Delayer.delayToCompleteCf(cf, value, timeout, unit);
            cf.whenComplete((BiConsumer)new FutureCanceller(f));
        }
        return cf;
    }

    public static <T> CompletableFuture<T> exceptionallyCompose(CompletableFuture<T> cf, Function<Throwable, ? extends CompletionStage<T>> fn) {
        if (IS_JAVA12_PLUS) {
            return cf.exceptionallyCompose(fn);
        }
        Objects.requireNonNull(fn, "fn is null");
        return ((CompletableFuture)cf.handle((r, ex) -> ex == null ? cf : (CompletionStage)fn.apply((Throwable)ex))).thenCompose(Function.identity());
    }

    public static <T> CompletableFuture<T> exceptionallyComposeAsync(CompletableFuture<T> cf, Function<Throwable, ? extends CompletionStage<T>> fn) {
        return CompletableFutureUtils.exceptionallyComposeAsync(cf, fn, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T> CompletableFuture<T> exceptionallyComposeAsync(CompletableFuture<T> cf, Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        if (IS_JAVA12_PLUS) {
            return cf.exceptionallyComposeAsync(fn, executor);
        }
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        return ((CompletableFuture)cf.handle((r, ex) -> ex == null ? cf : ((CompletableFuture)cf.handleAsync((r1, ex1) -> (CompletionStage)fn.apply((Throwable)ex1), executor)).thenCompose(Function.identity()))).thenCompose(Function.identity());
    }

    @Blocking
    @Nullable
    public static <T> T join(CompletableFuture<T> cf, long timeout, TimeUnit unit) {
        if (cf.isDone()) {
            return cf.join();
        }
        return CompletableFutureUtils.orTimeout(CompletableFutureUtils.copy(cf), timeout, unit).join();
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T resultNow(CompletableFuture<T> cf) {
        if (IS_JAVA19_PLUS) {
            return cf.resultNow();
        }
        if (!cf.isDone()) {
            throw new IllegalStateException("Task has not completed");
        }
        boolean interrupted = false;
        while (true) {
            try {
                T t = cf.get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Task completed with exception");
            }
            catch (CancellationException e) {
                throw new IllegalStateException("Task was cancelled");
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    public static <T> Throwable exceptionNow(CompletableFuture<T> cf) {
        if (IS_JAVA19_PLUS) {
            return cf.exceptionNow();
        }
        if (!cf.isDone()) {
            throw new IllegalStateException("Task has not completed");
        }
        if (cf.isCancelled()) {
            throw new IllegalStateException("Task was cancelled");
        }
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    cf.get();
                    throw new IllegalStateException("Task completed with a result");
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    return throwable;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    public static <T> CffuState state(CompletableFuture<T> cf) {
        if (IS_JAVA19_PLUS) {
            return CffuState.toCffuState(cf.state());
        }
        if (!cf.isDone()) {
            return CffuState.RUNNING;
        }
        if (cf.isCancelled()) {
            return CffuState.CANCELLED;
        }
        boolean interrupted = false;
        while (true) {
            try {
                cf.get();
                CffuState cffuState = CffuState.SUCCESS;
                return cffuState;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                CffuState cffuState = CffuState.FAILED;
                return cffuState;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> CompletableFuture<T> completeAsync(CompletableFuture<T> cf, Supplier<? extends T> supplier) {
        return CompletableFutureUtils.completeAsync(cf, supplier, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T> CompletableFuture<T> completeAsync(CompletableFuture<T> cf, Supplier<? extends T> supplier, Executor executor) {
        if (IS_JAVA9_PLUS) {
            return cf.completeAsync(supplier, executor);
        }
        Objects.requireNonNull(supplier, "supplier is null");
        Objects.requireNonNull(executor, "executor is null");
        executor.execute(new CfCompleterBySupplier<T>(cf, supplier));
        return cf;
    }

    @Contract(pure=true)
    public static <T> CompletionStage<T> minimalCompletionStage(CompletableFuture<T> cf) {
        if (IS_JAVA9_PLUS) {
            return cf.minimalCompletionStage();
        }
        return cf.thenApply(Function.identity());
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T> copy(CompletableFuture<T> cf) {
        if (IS_JAVA9_PLUS) {
            return cf.copy();
        }
        return cf.thenApply(Function.identity());
    }

    @Contract(pure=true)
    public static <T, U> CompletableFuture<U> newIncompleteFuture(CompletableFuture<T> cf) {
        if (IS_JAVA9_PLUS) {
            return cf.newIncompleteFuture();
        }
        return new CompletableFuture();
    }

    @Contract(pure=true)
    public static Executor defaultExecutor() {
        return AsyncPoolHolder.ASYNC_POOL;
    }

    static Executor screenExecutor(Executor e) {
        if (!USE_COMMON_POOL && e == ForkJoinPool.commonPool()) {
            return AsyncPoolHolder.ASYNC_POOL;
        }
        return Objects.requireNonNull(e, "defaultExecutor is null");
    }

    private CompletableFutureUtils() {
    }

    static {
        boolean b;
        USE_COMMON_POOL = ForkJoinPool.getCommonPoolParallelism() > 1;
        try {
            CompletableFuture.completedStage(null);
            b = true;
        }
        catch (NoSuchMethodError e) {
            b = false;
        }
        IS_JAVA9_PLUS = b;
        CompletableFuture<Integer> cf = CompletableFuture.completedFuture(42);
        try {
            cf.exceptionallyCompose(v -> cf);
            b = true;
        }
        catch (NoSuchMethodError e) {
            b = false;
        }
        IS_JAVA12_PLUS = b;
        try {
            cf.resultNow();
            b = true;
        }
        catch (NoSuchMethodError e) {
            b = false;
        }
        IS_JAVA19_PLUS = b;
    }

    private static class AsyncPoolHolder {
        private static final Executor ASYNC_POOL = AsyncPoolHolder._asyncPool0();

        private AsyncPoolHolder() {
        }

        private static Executor _asyncPool0() {
            if (IS_JAVA9_PLUS) {
                return CompletableFuture.completedFuture(null).defaultExecutor();
            }
            if (USE_COMMON_POOL) {
                return ForkJoinPool.commonPool();
            }
            return new ThreadPerTaskExecutor();
        }
    }

    private static final class ThreadPerTaskExecutor
    implements Executor {
        private ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(Objects.requireNonNull(r)).start();
        }
    }
}

