/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.foldright.cffu.CffuFactory;
import io.foldright.cffu.CffuState;
import io.foldright.cffu.CompletableFutureUtils;
import io.foldright.cffu.tuple.Tuple2;
import io.foldright.cffu.tuple.Tuple3;
import io.foldright.cffu.tuple.Tuple4;
import io.foldright.cffu.tuple.Tuple5;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Contract;

public final class Cffu<T>
implements Future<T>,
CompletionStage<T> {
    private final CffuFactory fac;
    private final boolean isMinimalStage;
    private final CompletableFuture<T> cf;

    Cffu(CffuFactory cffuFactory, boolean isMinimalStage, CompletableFuture<T> cf) {
        this.fac = Objects.requireNonNull(cffuFactory, "cffuFactory is null");
        this.isMinimalStage = isMinimalStage;
        this.cf = Objects.requireNonNull(cf, "cf is null");
    }

    @Contract(pure=true)
    private <U> Cffu<U> reset0(CompletableFuture<U> cf) {
        return new Cffu<U>(this.fac, this.isMinimalStage, cf);
    }

    @Contract(pure=true)
    private <U> CompletionStage<U> resetToMin(CompletableFuture<U> cf) {
        return new Cffu<U>(this.fac, true, cf);
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenRun`")
    public <U> Cffu<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.thenApply(fn));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenRunAsync`")
    public <U> Cffu<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, this.fac.defaultExecutor());
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenRunAsync`")
    public <U> Cffu<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.thenApplyAsync(fn, executor));
    }

    public Cffu<Void> thenAccept(Consumer<? super T> action) {
        return this.reset0((CompletableFuture)this.cf.thenAccept((Consumer)action));
    }

    public Cffu<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.thenAcceptAsync((Consumer)action, this.fac.defaultExecutor());
    }

    public Cffu<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.thenAcceptAsync((Consumer)action, executor));
    }

    public Cffu<Void> thenRun(Runnable action) {
        return this.reset0((CompletableFuture)this.cf.thenRun(action));
    }

    public Cffu<Void> thenRunAsync(Runnable action) {
        return this.thenRunAsync(action, this.fac.defaultExecutor());
    }

    public Cffu<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.thenRunAsync(action, executor));
    }

    @SafeVarargs
    public final <U> Cffu<List<U>> thenMApplyFastFailAsync(Function<? super T, ? extends U> ... fns) {
        return this.thenMApplyFastFailAsync(this.fac.defaultExecutor(), fns);
    }

    @SafeVarargs
    public final <U> Cffu<List<U>> thenMApplyFastFailAsync(Executor executor, Function<? super T, ? extends U> ... fns) {
        return this.reset0(CompletableFutureUtils.thenMApplyFastFailAsync(this.cf, executor, fns));
    }

    @SafeVarargs
    public final <U> Cffu<List<U>> thenMApplyMostSuccessAsync(@Nullable U valueIfNotSuccess, long timeout, TimeUnit unit, Function<? super T, ? extends U> ... fns) {
        return this.thenMApplyMostSuccessAsync(valueIfNotSuccess, this.fac.defaultExecutor(), timeout, unit, fns);
    }

    @SafeVarargs
    public final <U> Cffu<List<U>> thenMApplyMostSuccessAsync(@Nullable U valueIfNotSuccess, Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U> ... fns) {
        return this.reset0(CompletableFutureUtils.thenMApplyMostSuccessAsync(this.cf, valueIfNotSuccess, executor, timeout, unit, fns));
    }

    @SafeVarargs
    public final <U> Cffu<List<U>> thenMApplyAsync(Function<? super T, ? extends U> ... fns) {
        return this.thenMApplyAsync(this.fac.defaultExecutor(), fns);
    }

    @SafeVarargs
    public final <U> Cffu<List<U>> thenMApplyAsync(Executor executor, Function<? super T, ? extends U> ... fns) {
        return this.reset0(CompletableFutureUtils.thenMApplyAsync(this.cf, executor, fns));
    }

    @SafeVarargs
    public final Cffu<Void> thenMAcceptAsync(Consumer<? super T> ... actions) {
        return this.thenMAcceptAsync(this.fac.defaultExecutor(), actions);
    }

    @SafeVarargs
    public final Cffu<Void> thenMAcceptAsync(Executor executor, Consumer<? super T> ... actions) {
        return this.reset0(CompletableFutureUtils.thenMAcceptAsync(this.cf, executor, actions));
    }

    @SafeVarargs
    public final Cffu<Void> thenMAcceptFastFailAsync(Consumer<? super T> ... actions) {
        return this.thenMAcceptFastFailAsync(this.fac.defaultExecutor(), actions);
    }

    @SafeVarargs
    public final Cffu<Void> thenMAcceptFastFailAsync(Executor executor, Consumer<? super T> ... actions) {
        return this.reset0(CompletableFutureUtils.thenMAcceptFastFailAsync(this.cf, executor, actions));
    }

    public Cffu<Void> thenMRunFastFailAsync(Runnable ... actions) {
        return this.thenMRunFastFailAsync(this.fac.defaultExecutor(), actions);
    }

    public Cffu<Void> thenMRunFastFailAsync(Executor executor, Runnable ... actions) {
        return this.reset0(CompletableFutureUtils.thenMRunFastFailAsync(this.cf, executor, actions));
    }

    public Cffu<Void> thenMRunAsync(Runnable ... actions) {
        return this.thenMRunAsync(this.fac.defaultExecutor(), actions);
    }

    public Cffu<Void> thenMRunAsync(Executor executor, Runnable ... actions) {
        return this.reset0(CompletableFutureUtils.thenMRunAsync(this.cf, executor, actions));
    }

    public <U1, U2> Cffu<Tuple2<U1, U2>> thenTupleMApplyFastFailAsync(Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        return this.thenTupleMApplyFastFailAsync(this.fac.defaultExecutor(), fn1, fn2);
    }

    public <U1, U2> Cffu<Tuple2<U1, U2>> thenTupleMApplyFastFailAsync(Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyFastFailAsync(this.cf, executor, fn1, fn2));
    }

    public <U1, U2, U3> Cffu<Tuple3<U1, U2, U3>> thenTupleMApplyFastFailAsync(Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        return this.thenTupleMApplyFastFailAsync(this.fac.defaultExecutor(), fn1, fn2, fn3);
    }

    public <U1, U2, U3> Cffu<Tuple3<U1, U2, U3>> thenTupleMApplyFastFailAsync(Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyFastFailAsync(this.cf, executor, fn1, fn2, fn3));
    }

    public <U1, U2, U3, U4> Cffu<Tuple4<U1, U2, U3, U4>> thenTupleMApplyFastFailAsync(Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        return this.thenTupleMApplyFastFailAsync(this.fac.defaultExecutor(), fn1, fn2, fn3, fn4);
    }

    public <U1, U2, U3, U4> Cffu<Tuple4<U1, U2, U3, U4>> thenTupleMApplyFastFailAsync(Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyFastFailAsync(this.cf, executor, fn1, fn2, fn3, fn4));
    }

    public <U1, U2, U3, U4, U5> Cffu<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyFastFailAsync(Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        return this.thenTupleMApplyFastFailAsync(this.fac.defaultExecutor(), fn1, fn2, fn3, fn4, fn5);
    }

    public <U1, U2, U3, U4, U5> Cffu<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyFastFailAsync(Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyFastFailAsync(this.cf, executor, fn1, fn2, fn3, fn4, fn5));
    }

    public <U1, U2> Cffu<Tuple2<U1, U2>> thenTupleMApplyMostSuccessAsync(long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        return this.thenTupleMApplyMostSuccessAsync(this.fac.defaultExecutor(), timeout, unit, fn1, fn2);
    }

    public <U1, U2> Cffu<Tuple2<U1, U2>> thenTupleMApplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyMostSuccessAsync(this.cf, executor, timeout, unit, fn1, fn2));
    }

    public <U1, U2, U3> Cffu<Tuple3<U1, U2, U3>> thenTupleMApplyMostSuccessAsync(long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        return this.thenTupleMApplyMostSuccessAsync(this.fac.defaultExecutor(), timeout, unit, fn1, fn2, fn3);
    }

    public <U1, U2, U3> Cffu<Tuple3<U1, U2, U3>> thenTupleMApplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyMostSuccessAsync(this.cf, executor, timeout, unit, fn1, fn2, fn3));
    }

    public <U1, U2, U3, U4> Cffu<Tuple4<U1, U2, U3, U4>> thenTupleMApplyMostSuccessAsync(long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        return this.thenTupleMApplyMostSuccessAsync(this.fac.defaultExecutor(), timeout, unit, fn1, fn2, fn3, fn4);
    }

    public <U1, U2, U3, U4> Cffu<Tuple4<U1, U2, U3, U4>> thenTupleMApplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyMostSuccessAsync(this.cf, executor, timeout, unit, fn1, fn2, fn3, fn4));
    }

    public <U1, U2, U3, U4, U5> Cffu<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyMostSuccessAsync(long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        return this.thenTupleMApplyMostSuccessAsync(this.fac.defaultExecutor(), timeout, unit, fn1, fn2, fn3, fn4, fn5);
    }

    public <U1, U2, U3, U4, U5> Cffu<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyMostSuccessAsync(this.cf, executor, timeout, unit, fn1, fn2, fn3, fn4, fn5));
    }

    public <U1, U2> Cffu<Tuple2<U1, U2>> thenTupleMApplyAsync(Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        return this.thenTupleMApplyAsync(this.fac.defaultExecutor(), fn1, fn2);
    }

    public <U1, U2> Cffu<Tuple2<U1, U2>> thenTupleMApplyAsync(Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyAsync(this.cf, executor, fn1, fn2));
    }

    public <U1, U2, U3> Cffu<Tuple3<U1, U2, U3>> thenTupleMApplyAsync(Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        return this.thenTupleMApplyAsync(this.fac.defaultExecutor(), fn1, fn2, fn3);
    }

    public <U1, U2, U3> Cffu<Tuple3<U1, U2, U3>> thenTupleMApplyAsync(Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyAsync(this.cf, executor, fn1, fn2, fn3));
    }

    public <U1, U2, U3, U4> Cffu<Tuple4<U1, U2, U3, U4>> thenTupleMApplyAsync(Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        return this.thenTupleMApplyAsync(this.fac.defaultExecutor(), fn1, fn2, fn3, fn4);
    }

    public <U1, U2, U3, U4> Cffu<Tuple4<U1, U2, U3, U4>> thenTupleMApplyAsync(Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyAsync(this.cf, executor, fn1, fn2, fn3, fn4));
    }

    public <U1, U2, U3, U4, U5> Cffu<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyAsync(Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        return this.thenTupleMApplyAsync(this.fac.defaultExecutor(), fn1, fn2, fn3, fn4, fn5);
    }

    public <U1, U2, U3, U4, U5> Cffu<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyAsync(Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        return this.reset0(CompletableFutureUtils.thenTupleMApplyAsync(this.cf, executor, fn1, fn2, fn3, fn4, fn5));
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenAcceptBothFastFail`")
    public <U, V> Cffu<V> thenCombineFastFail(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.reset0(CompletableFutureUtils.thenCombineFastFail(this.cf, other, fn));
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenAcceptBothFastFailAsync`")
    public <U, V> Cffu<V> thenCombineFastFailAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.thenCombineFastFailAsync(other, fn, this.fac.defaultExecutor());
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenAcceptBothFastFailAsync`")
    public <U, V> Cffu<V> thenCombineFastFailAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.reset0(CompletableFutureUtils.thenCombineFastFailAsync(this.cf, other, fn, executor));
    }

    public <U> Cffu<Void> thenAcceptBothFastFail(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.reset0(CompletableFutureUtils.thenAcceptBothFastFail(this.cf, other, action));
    }

    public <U> Cffu<Void> thenAcceptBothFastFailAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.thenAcceptBothFastFailAsync(other, action, this.fac.defaultExecutor());
    }

    public <U> Cffu<Void> thenAcceptBothFastFailAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.reset0(CompletableFutureUtils.thenAcceptBothFastFailAsync(this.cf, other, action, executor));
    }

    public Cffu<Void> runAfterBothFastFail(CompletionStage<?> other, Runnable action) {
        return this.reset0(CompletableFutureUtils.runAfterBothFastFail(this.cf, other, action));
    }

    public Cffu<Void> runAfterBothFastFailAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothFastFailAsync(other, action, this.fac.defaultExecutor());
    }

    public Cffu<Void> runAfterBothFastFailAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.reset0(CompletableFutureUtils.runAfterBothFastFailAsync(this.cf, other, action, executor));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenAcceptBoth`")
    public <U, V> Cffu<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.thenCombine(other, fn));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenAcceptBothAsync`")
    public <U, V> Cffu<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.thenCombineAsync((CompletionStage)other, (BiFunction)fn, this.fac.defaultExecutor());
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `thenAcceptBothAsync`")
    public <U, V> Cffu<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.thenCombineAsync(other, fn, executor));
    }

    public <U> Cffu<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.reset0((CompletableFuture<U>)this.cf.thenAcceptBoth(other, (BiConsumer)action));
    }

    public <U> Cffu<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, this.fac.defaultExecutor());
    }

    public <U> Cffu<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.thenAcceptBothAsync(other, (BiConsumer)action, executor));
    }

    public Cffu<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.reset0((CompletableFuture)this.cf.runAfterBoth((CompletionStage)other, action));
    }

    public Cffu<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothAsync((CompletionStage)other, action, this.fac.defaultExecutor());
    }

    public Cffu<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `acceptEitherSuccess`")
    public <U> Cffu<U> applyToEitherSuccess(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.reset0(CompletableFutureUtils.applyToEitherSuccess(this.cf, other, fn));
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `acceptEitherSuccessAsync`")
    public <U> Cffu<U> applyToEitherSuccessAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.applyToEitherSuccessAsync(other, fn, this.fac.defaultExecutor());
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `acceptEitherSuccessAsync`")
    public <U> Cffu<U> applyToEitherSuccessAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.reset0(CompletableFutureUtils.applyToEitherSuccessAsync(this.cf, other, fn, executor));
    }

    public Cffu<Void> acceptEitherSuccess(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.reset0(CompletableFutureUtils.acceptEitherSuccess(this.cf, other, action));
    }

    public Cffu<Void> acceptEitherSuccessAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.acceptEitherSuccessAsync(other, action, this.fac.defaultExecutor());
    }

    public Cffu<Void> acceptEitherSuccessAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.reset0(CompletableFutureUtils.acceptEitherSuccessAsync(this.cf, other, action, executor));
    }

    public Cffu<Void> runAfterEitherSuccess(CompletionStage<?> other, Runnable action) {
        return this.reset0(CompletableFutureUtils.runAfterEitherSuccess(this.cf, other, action));
    }

    public Cffu<Void> runAfterEitherSuccessAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherSuccessAsync(other, action, this.fac.defaultExecutor());
    }

    public Cffu<Void> runAfterEitherSuccessAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.reset0(CompletableFutureUtils.runAfterEitherSuccessAsync(this.cf, other, action, executor));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `acceptEither`")
    public <U> Cffu<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.applyToEither((CompletionStage)other, fn));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `acceptEitherAsync`")
    public <U> Cffu<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)fn, this.fac.defaultExecutor());
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `acceptEitherAsync`")
    public <U> Cffu<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.applyToEitherAsync((CompletionStage)other, fn, executor));
    }

    public Cffu<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.reset0((CompletableFuture)this.cf.acceptEither((CompletionStage)other, (Consumer)action));
    }

    public Cffu<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.acceptEitherAsync((CompletionStage)other, (Consumer)action, this.fac.defaultExecutor());
    }

    public Cffu<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    public Cffu<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.reset0((CompletableFuture)this.cf.runAfterEither((CompletionStage)other, action));
    }

    public Cffu<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync((CompletionStage)other, action, this.fac.defaultExecutor());
    }

    public Cffu<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    @Override
    public Cffu<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.reset0((CompletableFuture)this.cf.exceptionally(fn));
    }

    @Override
    public Cffu<T> exceptionallyAsync(Function<Throwable, ? extends T> fn) {
        return this.exceptionallyAsync((Function)fn, this.fac.defaultExecutor());
    }

    @Override
    public Cffu<T> exceptionallyAsync(Function<Throwable, ? extends T> fn, Executor executor) {
        return this.reset0(CompletableFutureUtils.exceptionallyAsync(this.cf, fn, executor));
    }

    public Cffu<T> orTimeout(long timeout, TimeUnit unit) {
        return this.orTimeout(this.fac.defaultExecutor(), timeout, unit);
    }

    public Cffu<T> orTimeout(Executor executorWhenTimeout, long timeout, TimeUnit unit) {
        this.checkMinimalStage();
        return this.reset0(CompletableFutureUtils.cffuOrTimeout(this.cf, executorWhenTimeout, timeout, unit));
    }

    public Cffu<T> unsafeOrTimeout(long timeout, TimeUnit unit) {
        this.checkMinimalStage();
        CompletableFutureUtils.orTimeout(this.cf, timeout, unit);
        return this;
    }

    public Cffu<T> completeOnTimeout(@Nullable T value, long timeout, TimeUnit unit) {
        return this.completeOnTimeout(value, this.fac.defaultExecutor(), timeout, unit);
    }

    public Cffu<T> completeOnTimeout(@Nullable T value, Executor executorWhenTimeout, long timeout, TimeUnit unit) {
        this.checkMinimalStage();
        return this.reset0(CompletableFutureUtils.cffuCompleteOnTimeout(this.cf, value, executorWhenTimeout, timeout, unit));
    }

    public Cffu<T> unsafeCompleteOnTimeout(@Nullable T value, long timeout, TimeUnit unit) {
        this.checkMinimalStage();
        CompletableFutureUtils.completeOnTimeout(this.cf, value, timeout, unit);
        return this;
    }

    @Override
    public <U> Cffu<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.thenCompose(fn));
    }

    @Override
    public <U> Cffu<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync((Function)fn, this.fac.defaultExecutor());
    }

    @Override
    public <U> Cffu<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.thenComposeAsync(fn, executor));
    }

    @Override
    public Cffu<T> exceptionallyCompose(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return this.reset0(CompletableFutureUtils.exceptionallyCompose(this.cf, fn));
    }

    @Override
    public Cffu<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn) {
        return this.exceptionallyComposeAsync((Function)fn, this.fac.defaultExecutor());
    }

    @Override
    public Cffu<T> exceptionallyComposeAsync(Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        return this.reset0(CompletableFutureUtils.exceptionallyComposeAsync(this.cf, fn, executor));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `peek`")
    public <U> Cffu<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.reset0((CompletableFuture<U>)this.cf.handle(fn));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `peekAsync`")
    public <U> Cffu<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.handleAsync((BiFunction)fn, this.fac.defaultExecutor());
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `peekAsync`")
    public <U> Cffu<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.reset0((CompletableFuture<U>)this.cf.handleAsync(fn, executor));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `peek`")
    public Cffu<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.reset0((CompletableFuture)this.cf.whenComplete(action));
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `peekAsync`")
    public Cffu<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.whenCompleteAsync((BiConsumer)action, this.fac.defaultExecutor());
    }

    @Override
    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `peekAsync`")
    public Cffu<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.reset0((CompletableFuture)this.cf.whenCompleteAsync(action, executor));
    }

    public Cffu<T> peek(BiConsumer<? super T, ? super Throwable> action) {
        CompletableFutureUtils.peek(this.cf, action);
        return this;
    }

    public Cffu<T> peekAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.peekAsync(action, this.fac.defaultExecutor());
    }

    public Cffu<T> peekAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        CompletableFutureUtils.peekAsync(this.cf, action, executor);
        return this;
    }

    @Override
    @Blocking
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        this.checkMinimalStage();
        return this.cf.get();
    }

    @Override
    @Blocking
    @Nullable
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkMinimalStage();
        return this.cf.get(timeout, unit);
    }

    @Blocking
    @Nullable
    public T join() {
        this.checkMinimalStage();
        return this.cf.join();
    }

    @Blocking
    @Nullable
    public T join(long timeout, TimeUnit unit) {
        this.checkMinimalStage();
        return CompletableFutureUtils.join(this.cf, timeout, unit);
    }

    @Contract(pure=true)
    @Nullable
    public T getNow(T valueIfAbsent) {
        this.checkMinimalStage();
        return this.cf.getNow(valueIfAbsent);
    }

    @Contract(pure=true)
    @Nullable
    public T getSuccessNow(@Nullable T valueIfNotSuccess) {
        this.checkMinimalStage();
        return CompletableFutureUtils.getSuccessNow(this.cf, valueIfNotSuccess);
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public T resultNow() {
        this.checkMinimalStage();
        return CompletableFutureUtils.resultNow(this.cf);
    }

    @Override
    @Contract(pure=true)
    public Throwable exceptionNow() {
        this.checkMinimalStage();
        return CompletableFutureUtils.exceptionNow(this.cf);
    }

    @Override
    @Contract(pure=true)
    public boolean isDone() {
        this.checkMinimalStage();
        return this.cf.isDone();
    }

    @Contract(pure=true)
    public boolean isCompletedExceptionally() {
        this.checkMinimalStage();
        return this.cf.isCompletedExceptionally();
    }

    @Override
    @Contract(pure=true)
    public boolean isCancelled() {
        this.checkMinimalStage();
        return this.cf.isCancelled();
    }

    @Override
    @Contract(pure=true)
    public Future.State state() {
        this.checkMinimalStage();
        return this.cf.state();
    }

    @Contract(pure=true)
    public CffuState cffuState() {
        this.checkMinimalStage();
        return CompletableFutureUtils.state(this.cf);
    }

    public boolean complete(@Nullable T value) {
        this.checkMinimalStage();
        return this.cf.complete(value);
    }

    public Cffu<T> completeAsync(Supplier<? extends T> supplier) {
        return this.completeAsync(supplier, this.fac.defaultExecutor());
    }

    public Cffu<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        this.checkMinimalStage();
        CompletableFutureUtils.completeAsync(this.cf, supplier, executor);
        return this;
    }

    public boolean completeExceptionally(Throwable ex) {
        this.checkMinimalStage();
        return this.cf.completeExceptionally(ex);
    }

    public Cffu<T> completeExceptionallyAsync(Supplier<? extends Throwable> supplier) {
        return this.completeExceptionallyAsync(supplier, this.fac.defaultExecutor());
    }

    public Cffu<T> completeExceptionallyAsync(Supplier<? extends Throwable> supplier, Executor executor) {
        this.checkMinimalStage();
        CompletableFutureUtils.completeExceptionallyAsync(this.cf, supplier, executor);
        return this;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.checkMinimalStage();
        return this.cf.cancel(mayInterruptIfRunning);
    }

    @Contract(pure=true)
    public CompletionStage<T> minimalCompletionStage() {
        return this.resetToMin((CompletableFuture)CompletableFutureUtils.minimalCompletionStage(this.cf));
    }

    @Contract(pure=true)
    public Cffu<T> resetCffuFactory(CffuFactory cffuFactory) {
        return new Cffu<T>(cffuFactory, this.isMinimalStage, this.cf);
    }

    @Override
    @Contract(pure=true)
    public CompletableFuture<T> toCompletableFuture() {
        return this.cf.toCompletableFuture();
    }

    @Contract(pure=true)
    public Cffu<T> copy() {
        return this.reset0(CompletableFutureUtils.copy(this.cf));
    }

    @Contract(pure=true)
    public Executor defaultExecutor() {
        return this.fac.defaultExecutor();
    }

    @Contract(pure=true)
    public CffuFactory cffuFactory() {
        return this.fac;
    }

    @Contract(pure=true)
    public boolean forbidObtrudeMethods() {
        return this.fac.forbidObtrudeMethods();
    }

    @Contract(pure=true)
    public boolean isMinimalStage() {
        return this.isMinimalStage;
    }

    @Contract(pure=true)
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public CompletableFuture<T> cffuUnwrap() {
        return this.cf;
    }

    @Contract(pure=true)
    public int getNumberOfDependents() {
        this.checkMinimalStage();
        return this.cf.getNumberOfDependents();
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public void obtrudeValue(@Nullable T value) {
        this.checkMinimalStage();
        this.checkForbidObtrudeMethods();
        this.cf.obtrudeValue(value);
    }

    public void obtrudeException(Throwable ex) {
        this.checkMinimalStage();
        this.checkForbidObtrudeMethods();
        this.cf.obtrudeException(ex);
    }

    @Contract(pure=true)
    public <U> Cffu<U> newIncompleteFuture() {
        return this.fac.newIncompleteCffu();
    }

    @Contract(pure=true)
    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "(" + this.cf + ")";
    }

    private void checkMinimalStage() {
        if (this.isMinimalStage) {
            throw new UnsupportedOperationException("unsupported because this is a minimal stage");
        }
    }

    private void checkForbidObtrudeMethods() {
        if (this.fac.forbidObtrudeMethods()) {
            throw new UnsupportedOperationException("obtrude methods is forbidden by cffu");
        }
    }
}

