/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.foldright.cffu.Cffu;
import io.foldright.cffu.CffuFactoryBuilder;
import io.foldright.cffu.CompletableFutureUtils;
import io.foldright.cffu.tuple.Tuple2;
import io.foldright.cffu.tuple.Tuple3;
import io.foldright.cffu.tuple.Tuple4;
import io.foldright.cffu.tuple.Tuple5;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.Contract;

@ThreadSafe
public final class CffuFactory {
    private final Executor defaultExecutor;
    private final boolean forbidObtrudeMethods;

    CffuFactory(Executor defaultExecutor, boolean forbidObtrudeMethods) {
        this.defaultExecutor = defaultExecutor;
        this.forbidObtrudeMethods = forbidObtrudeMethods;
    }

    @Contract(pure=true)
    public static CffuFactoryBuilder builder(Executor defaultExecutor) {
        return new CffuFactoryBuilder(CompletableFutureUtils.screenExecutor(defaultExecutor));
    }

    @Contract(pure=true)
    private <T> Cffu<T> create(CompletableFuture<T> cf) {
        return new Cffu<T>(this, false, cf);
    }

    @Contract(pure=true)
    private <T> CompletionStage<T> createMin(CompletableFuture<T> cf) {
        return new Cffu<T>(this, true, cf);
    }

    @Contract(pure=true)
    public <T> Cffu<T> newIncompleteCffu() {
        return this.create(new CompletableFuture());
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `runAsync`")
    public <T> Cffu<T> supplyAsync(Supplier<T> supplier) {
        return this.supplyAsync(supplier, this.defaultExecutor);
    }

    @CheckReturnValue(explanation="should use the returned Cffu; otherwise, prefer method `runAsync`")
    public <T> Cffu<T> supplyAsync(Supplier<T> supplier, Executor executor) {
        return this.create(CompletableFuture.supplyAsync(supplier, executor));
    }

    public Cffu<Void> runAsync(Runnable action) {
        return this.runAsync(action, this.defaultExecutor);
    }

    public Cffu<Void> runAsync(Runnable action, Executor executor) {
        return this.create(CompletableFuture.runAsync(action, executor));
    }

    @SafeVarargs
    public final <T> Cffu<List<T>> mSupplyFastFailAsync(Supplier<? extends T> ... suppliers) {
        return this.mSupplyFastFailAsync(this.defaultExecutor, suppliers);
    }

    @SafeVarargs
    public final <T> Cffu<List<T>> mSupplyFastFailAsync(Executor executor, Supplier<? extends T> ... suppliers) {
        return this.create(CompletableFutureUtils.mSupplyFastFailAsync(executor, suppliers));
    }

    @SafeVarargs
    public final <T> Cffu<List<T>> mSupplyMostSuccessAsync(@Nullable T valueIfNotSuccess, long timeout, TimeUnit unit, Supplier<? extends T> ... suppliers) {
        return this.mSupplyMostSuccessAsync(valueIfNotSuccess, this.defaultExecutor, timeout, unit, suppliers);
    }

    @SafeVarargs
    public final <T> Cffu<List<T>> mSupplyMostSuccessAsync(@Nullable T valueIfNotSuccess, Executor executor, long timeout, TimeUnit unit, Supplier<? extends T> ... suppliers) {
        return this.create(CompletableFutureUtils.mSupplyMostSuccessAsync(valueIfNotSuccess, executor, timeout, unit, suppliers));
    }

    @SafeVarargs
    public final <T> Cffu<List<T>> mSupplyAsync(Supplier<? extends T> ... suppliers) {
        return this.mSupplyAsync(this.defaultExecutor, suppliers);
    }

    @SafeVarargs
    public final <T> Cffu<List<T>> mSupplyAsync(Executor executor, Supplier<? extends T> ... suppliers) {
        return this.create(CompletableFutureUtils.mSupplyAsync(executor, suppliers));
    }

    public Cffu<Void> mRunFastFailAsync(Runnable ... actions) {
        return this.mRunFastFailAsync(this.defaultExecutor, actions);
    }

    public Cffu<Void> mRunFastFailAsync(Executor executor, Runnable ... actions) {
        return this.create(CompletableFutureUtils.mRunFastFailAsync(executor, actions));
    }

    public Cffu<Void> mRunAsync(Runnable ... actions) {
        return this.mRunAsync(this.defaultExecutor, actions);
    }

    public Cffu<Void> mRunAsync(Executor executor, Runnable ... actions) {
        return this.create(CompletableFutureUtils.mRunAsync(executor, actions));
    }

    public <T1, T2> Cffu<Tuple2<T1, T2>> tupleMSupplyFastFailAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        return this.tupleMSupplyFastFailAsync(this.defaultExecutor, supplier1, supplier2);
    }

    public <T1, T2> Cffu<Tuple2<T1, T2>> tupleMSupplyFastFailAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        return this.create(CompletableFutureUtils.tupleMSupplyFastFailAsync(executor, supplier1, supplier2));
    }

    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> tupleMSupplyFastFailAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        return this.tupleMSupplyFastFailAsync(this.defaultExecutor, supplier1, supplier2, supplier3);
    }

    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> tupleMSupplyFastFailAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        return this.create(CompletableFutureUtils.tupleMSupplyFastFailAsync(executor, supplier1, supplier2, supplier3));
    }

    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> tupleMSupplyFastFailAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        return this.tupleMSupplyFastFailAsync(this.defaultExecutor, supplier1, supplier2, supplier3, supplier4);
    }

    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> tupleMSupplyFastFailAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        return this.create(CompletableFutureUtils.tupleMSupplyFastFailAsync(executor, supplier1, supplier2, supplier3, supplier4));
    }

    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyFastFailAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        return this.tupleMSupplyFastFailAsync(this.defaultExecutor, supplier1, supplier2, supplier3, supplier4, supplier5);
    }

    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyFastFailAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        return this.create(CompletableFutureUtils.tupleMSupplyFastFailAsync(executor, supplier1, supplier2, supplier3, supplier4, supplier5));
    }

    public <T1, T2> Cffu<Tuple2<T1, T2>> tupleMSupplyMostSuccessAsync(long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        return this.tupleMSupplyMostSuccessAsync(this.defaultExecutor, timeout, unit, supplier1, supplier2);
    }

    public <T1, T2> Cffu<Tuple2<T1, T2>> tupleMSupplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        return this.create(CompletableFutureUtils.tupleMSupplyMostSuccessAsync(executor, timeout, unit, supplier1, supplier2));
    }

    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> tupleMSupplyMostSuccessAsync(long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        return this.tupleMSupplyMostSuccessAsync(this.defaultExecutor, timeout, unit, supplier1, supplier2, supplier3);
    }

    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> tupleMSupplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        return this.create(CompletableFutureUtils.tupleMSupplyMostSuccessAsync(executor, timeout, unit, supplier1, supplier2, supplier3));
    }

    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> tupleMSupplyMostSuccessAsync(long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        return this.tupleMSupplyMostSuccessAsync(this.defaultExecutor, timeout, unit, supplier1, supplier2, supplier3, supplier4);
    }

    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> tupleMSupplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        return this.create(CompletableFutureUtils.tupleMSupplyMostSuccessAsync(executor, timeout, unit, supplier1, supplier2, supplier3, supplier4));
    }

    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyMostSuccessAsync(long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        return this.tupleMSupplyMostSuccessAsync(this.defaultExecutor, timeout, unit, supplier1, supplier2, supplier3, supplier4, supplier5);
    }

    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        return this.create(CompletableFutureUtils.tupleMSupplyMostSuccessAsync(executor, timeout, unit, supplier1, supplier2, supplier3, supplier4, supplier5));
    }

    public <T1, T2> Cffu<Tuple2<T1, T2>> tupleMSupplyAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        return this.tupleMSupplyAsync(this.defaultExecutor, supplier1, supplier2);
    }

    public <T1, T2> Cffu<Tuple2<T1, T2>> tupleMSupplyAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        return this.create(CompletableFutureUtils.tupleMSupplyAsync(executor, supplier1, supplier2));
    }

    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> tupleMSupplyAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        return this.tupleMSupplyAsync(this.defaultExecutor, supplier1, supplier2, supplier3);
    }

    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> tupleMSupplyAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        return this.create(CompletableFutureUtils.tupleMSupplyAsync(executor, supplier1, supplier2, supplier3));
    }

    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> tupleMSupplyAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        return this.tupleMSupplyAsync(this.defaultExecutor, supplier1, supplier2, supplier3, supplier4);
    }

    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> tupleMSupplyAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        return this.create(CompletableFutureUtils.tupleMSupplyAsync(executor, supplier1, supplier2, supplier3, supplier4));
    }

    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        return this.tupleMSupplyAsync(this.defaultExecutor, supplier1, supplier2, supplier3, supplier4, supplier5);
    }

    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        return this.create(CompletableFutureUtils.tupleMSupplyAsync(executor, supplier1, supplier2, supplier3, supplier4, supplier5));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<List<T>> allResultsFastFailOf(CompletionStage<? extends T> ... cfs) {
        return this.create(CompletableFutureUtils.allResultsFastFailOf(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<List<T>> mostSuccessResultsOf(@Nullable T valueIfNotSuccess, long timeout, TimeUnit unit, CompletionStage<? extends T> ... cfs) {
        return this.create(CompletableFutureUtils.mostSuccessResultsOf(valueIfNotSuccess, this.defaultExecutor, timeout, unit, cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<List<T>> allResultsOf(CompletionStage<? extends T> ... cfs) {
        return this.create(CompletableFutureUtils.allResultsOf(cfs));
    }

    @Contract(pure=true)
    public Cffu<Void> allFastFailOf(CompletionStage<?> ... cfs) {
        return this.create(CompletableFutureUtils.allFastFailOf(cfs));
    }

    @Contract(pure=true)
    public Cffu<Void> allOf(CompletionStage<?> ... cfs) {
        return this.create(CompletableFutureUtils.allOf(cfs));
    }

    @SafeVarargs
    public final <T> Cffu<T> anySuccessOf(CompletionStage<? extends T> ... cfs) {
        return this.create(CompletableFutureUtils.anySuccessOf(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<T> anyOf(CompletionStage<? extends T> ... cfs) {
        return this.create(CompletableFutureUtils.anyOf(cfs));
    }

    @Contract(pure=true)
    public <T1, T2> Cffu<Tuple2<T1, T2>> allTupleFastFailOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return this.create(CompletableFutureUtils.allTupleFastFailOf(cf1, cf2));
    }

    @Contract(pure=true)
    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> allTupleFastFailOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return this.create(CompletableFutureUtils.allTupleFastFailOf(cf1, cf2, cf3));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> allTupleFastFailOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return this.create(CompletableFutureUtils.allTupleFastFailOf(cf1, cf2, cf3, cf4));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> allTupleFastFailOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return this.create(CompletableFutureUtils.allTupleFastFailOf(cf1, cf2, cf3, cf4, cf5));
    }

    @Contract(pure=true)
    public <T1, T2> Cffu<Tuple2<T1, T2>> mostSuccessTupleOf(long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return this.create(CompletableFutureUtils.mostSuccessTupleOf(this.defaultExecutor, timeout, unit, cf1, cf2));
    }

    @Contract(pure=true)
    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> mostSuccessTupleOf(long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return this.create(CompletableFutureUtils.mostSuccessTupleOf(this.defaultExecutor, timeout, unit, cf1, cf2, cf3));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> mostSuccessTupleOf(long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return this.create(CompletableFutureUtils.mostSuccessTupleOf(this.defaultExecutor, timeout, unit, cf1, cf2, cf3, cf4));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> mostSuccessTupleOf(long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return this.create(CompletableFutureUtils.mostSuccessTupleOf(this.defaultExecutor, timeout, unit, cf1, cf2, cf3, cf4, cf5));
    }

    @Contract(pure=true)
    public <T1, T2> Cffu<Tuple2<T1, T2>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return this.create(CompletableFutureUtils.allTupleOf(cf1, cf2));
    }

    @Contract(pure=true)
    public <T1, T2, T3> Cffu<Tuple3<T1, T2, T3>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return this.create(CompletableFutureUtils.allTupleOf(cf1, cf2, cf3));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4> Cffu<Tuple4<T1, T2, T3, T4>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return this.create(CompletableFutureUtils.allTupleOf(cf1, cf2, cf3, cf4));
    }

    @Contract(pure=true)
    public <T1, T2, T3, T4, T5> Cffu<Tuple5<T1, T2, T3, T4, T5>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return this.create(CompletableFutureUtils.allTupleOf(cf1, cf2, cf3, cf4, cf5));
    }

    @Contract(pure=true)
    public <T> Cffu<T> completedFuture(@Nullable T value) {
        return this.create(CompletableFuture.completedFuture(value));
    }

    @Contract(pure=true)
    public <T> CompletionStage<T> completedStage(@Nullable T value) {
        return this.createMin((CompletableFuture)CompletableFutureUtils.completedStage(value));
    }

    @Contract(pure=true)
    public <T> Cffu<T> failedFuture(Throwable ex) {
        return this.create(CompletableFutureUtils.failedFuture(ex));
    }

    @Contract(pure=true)
    public <T> CompletionStage<T> failedStage(Throwable ex) {
        return this.createMin((CompletableFuture)CompletableFutureUtils.failedStage(ex));
    }

    @Contract(pure=true)
    public <T> Cffu<T> toCffu(CompletionStage<T> stage) {
        Cffu f;
        Objects.requireNonNull(stage, "stage is null");
        if (stage instanceof Cffu && (f = (Cffu)stage).cffuFactory() == this && !f.isMinimalStage()) {
            return f;
        }
        return this.create(stage.toCompletableFuture());
    }

    @SafeVarargs
    @Contract(pure=true)
    public final <T> Cffu<T>[] toCffuArray(CompletionStage<T> ... stages) {
        Objects.requireNonNull(stages, "stages is null");
        Cffu[] ret = new Cffu[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            ret[i] = this.toCffu(Objects.requireNonNull(stages[i], "stage" + (i + 1) + " is null"));
        }
        return ret;
    }

    @Contract(pure=true)
    public Executor delayedExecutor(long delay, TimeUnit unit) {
        return CompletableFutureUtils.delayedExecutor(delay, unit, this.defaultExecutor);
    }

    @Contract(pure=true)
    public Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        return CompletableFutureUtils.delayedExecutor(delay, unit, executor);
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] cffuArrayUnwrap(Cffu<T> ... cfs) {
        CompletableFuture[] ret = new CompletableFuture[cfs.length];
        for (int i = 0; i < cfs.length; ++i) {
            ret[i] = Objects.requireNonNull(cfs[i], "cf" + (i + 1) + " is null").cffuUnwrap();
        }
        return ret;
    }

    @Contract(pure=true)
    public static <T> Cffu<T>[] cffuListToArray(List<Cffu<T>> cffuList) {
        Cffu[] a = new Cffu[cffuList.size()];
        return cffuList.toArray(a);
    }

    @Contract(pure=true)
    public Executor defaultExecutor() {
        return this.defaultExecutor;
    }

    @Contract(pure=true)
    public boolean forbidObtrudeMethods() {
        return this.forbidObtrudeMethods;
    }
}

