/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import io.foldright.cffu.CffuFactory;
import io.foldright.cffu.spi.ExecutorWrapperProvider;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.Contract;

@ThreadSafe
public final class CffuFactoryBuilder {
    private final Executor defaultExecutor;
    private volatile boolean forbidObtrudeMethods = false;
    private static final List<ExecutorWrapperProvider> EXECUTOR_WRAPPER_PROVIDERS = CffuFactoryBuilder.loadExecutorWrapperProviders();

    CffuFactoryBuilder(Executor defaultExecutor) {
        this.defaultExecutor = CffuFactoryBuilder.wrapExecutor(defaultExecutor);
    }

    public CffuFactoryBuilder forbidObtrudeMethods(boolean forbid) {
        this.forbidObtrudeMethods = forbid;
        return this;
    }

    @Contract(pure=true)
    public CffuFactory build() {
        return new CffuFactory(this.defaultExecutor, this.forbidObtrudeMethods);
    }

    private static Executor wrapExecutor(Executor executor) {
        for (ExecutorWrapperProvider provider : EXECUTOR_WRAPPER_PROVIDERS) {
            Supplier<String> msg = () -> provider + "(class: " + provider.getClass().getName() + ") return null";
            executor = Objects.requireNonNull(provider.wrap(executor), msg);
        }
        return executor;
    }

    private static List<ExecutorWrapperProvider> loadExecutorWrapperProviders() {
        ServiceLoader<ExecutorWrapperProvider> loader = ServiceLoader.load(ExecutorWrapperProvider.class);
        return StreamSupport.stream(loader.spliterator(), false).collect(Collectors.toList());
    }
}

