/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.foldright.cffu.CfCompleterBySupplier;
import io.foldright.cffu.CfExCompleterBySupplier;
import io.foldright.cffu.Cffu;
import io.foldright.cffu.CffuState;
import io.foldright.cffu.DelayedExecutor;
import io.foldright.cffu.Delayer;
import io.foldright.cffu.ExceptionReporter;
import io.foldright.cffu.FutureCanceller;
import io.foldright.cffu.NoCfsProvidedException;
import io.foldright.cffu.tuple.Tuple2;
import io.foldright.cffu.tuple.Tuple3;
import io.foldright.cffu.tuple.Tuple4;
import io.foldright.cffu.tuple.Tuple5;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Contract;

public final class CompletableFutureUtils {
    private static final boolean USE_COMMON_POOL;
    private static final boolean IS_JAVA9_PLUS;
    private static final boolean IS_JAVA12_PLUS;
    private static final boolean IS_JAVA19_PLUS;

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> mSupplyFastFailAsync(Supplier<? extends T> ... suppliers) {
        return CompletableFutureUtils.mSupplyFastFailAsync(AsyncPoolHolder.ASYNC_POOL, suppliers);
    }

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> mSupplyFastFailAsync(Executor executor, Supplier<? extends T> ... suppliers) {
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("supplier", suppliers);
        return CompletableFutureUtils.allResultsFastFailOf(CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> mSupplyMostSuccessAsync(@Nullable T valueIfNotSuccess, long timeout, TimeUnit unit, Supplier<? extends T> ... suppliers) {
        return CompletableFutureUtils.mSupplyMostSuccessAsync(valueIfNotSuccess, AsyncPoolHolder.ASYNC_POOL, timeout, unit, suppliers);
    }

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> mSupplyMostSuccessAsync(@Nullable T valueIfNotSuccess, Executor executor, long timeout, TimeUnit unit, Supplier<? extends T> ... suppliers) {
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("supplier", suppliers);
        return CompletableFutureUtils.mostSuccessResultsOf(valueIfNotSuccess, executor, timeout, unit, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> mSupplyAsync(Supplier<? extends T> ... suppliers) {
        return CompletableFutureUtils.mSupplyAsync(AsyncPoolHolder.ASYNC_POOL, suppliers);
    }

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> mSupplyAsync(Executor executor, Supplier<? extends T> ... suppliers) {
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("supplier", suppliers);
        return CompletableFutureUtils.allResultsOf(CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    @SafeVarargs
    private static <T> T[] requireArrayAndEleNonNull(String varName, T ... array) {
        Objects.requireNonNull(array, varName + "s is null");
        for (int i = 0; i < array.length; ++i) {
            Objects.requireNonNull(array[i], varName + (i + 1) + " is null");
        }
        return array;
    }

    private static <T> CompletableFuture<? extends T>[] wrapSuppliers(Executor executor, Supplier<? extends T>[] suppliers) {
        CompletableFuture[] cfs = new CompletableFuture[suppliers.length];
        for (int i = 0; i < suppliers.length; ++i) {
            cfs[i] = CompletableFuture.supplyAsync(suppliers[i], executor);
        }
        return cfs;
    }

    public static CompletableFuture<Void> mRunFastFailAsync(Runnable ... actions) {
        return CompletableFutureUtils.mRunFastFailAsync(AsyncPoolHolder.ASYNC_POOL, actions);
    }

    public static CompletableFuture<Void> mRunFastFailAsync(Executor executor, Runnable ... actions) {
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("action", actions);
        return CompletableFutureUtils.allFastFailOf(CompletableFutureUtils.wrapRunnables(executor, actions));
    }

    public static CompletableFuture<Void> mRunAsync(Runnable ... actions) {
        return CompletableFutureUtils.mRunAsync(AsyncPoolHolder.ASYNC_POOL, actions);
    }

    public static CompletableFuture<Void> mRunAsync(Executor executor, Runnable ... actions) {
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("action", actions);
        return CompletableFuture.allOf(CompletableFutureUtils.wrapRunnables(executor, actions));
    }

    private static CompletableFuture<Void>[] wrapRunnables(Executor executor, Runnable[] actions) {
        CompletableFuture[] cfs = new CompletableFuture[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            cfs[i] = CompletableFuture.runAsync(actions[i], executor);
        }
        return cfs;
    }

    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> tupleMSupplyFastFailAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        return CompletableFutureUtils.tupleMSupplyFastFailAsync(AsyncPoolHolder.ASYNC_POOL, supplier1, supplier2);
    }

    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> tupleMSupplyFastFailAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        Objects.requireNonNull(executor, "executor is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2);
        return CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> tupleMSupplyFastFailAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        return CompletableFutureUtils.tupleMSupplyFastFailAsync(AsyncPoolHolder.ASYNC_POOL, supplier1, supplier2, supplier3);
    }

    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> tupleMSupplyFastFailAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        Objects.requireNonNull(executor, "executor is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2, supplier3);
        return CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> tupleMSupplyFastFailAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        return CompletableFutureUtils.tupleMSupplyFastFailAsync(AsyncPoolHolder.ASYNC_POOL, supplier1, supplier2, supplier3, supplier4);
    }

    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> tupleMSupplyFastFailAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        Objects.requireNonNull(executor, "executor is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2, supplier3, supplier4);
        return CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyFastFailAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        return CompletableFutureUtils.tupleMSupplyFastFailAsync(AsyncPoolHolder.ASYNC_POOL, supplier1, supplier2, supplier3, supplier4, supplier5);
    }

    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyFastFailAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        Objects.requireNonNull(executor, "executor is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2, supplier3, supplier4, supplier5);
        return CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    private static <T> CompletableFuture<T> allTupleOf0(boolean fastFail, CompletionStage<?>[] css) {
        Object[] result = new Object[css.length];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(css, result);
        CompletableFuture<Void> resultSetter = fastFail ? CompletableFutureUtils.allFastFailOf(resultSetterCfs) : CompletableFuture.allOf(resultSetterCfs);
        return resultSetter.thenApply(unused -> CompletableFutureUtils.tupleOf0(result));
    }

    private static <T> T tupleOf0(Object ... elements) {
        int len = elements.length;
        Object ret = len == 2 ? Tuple2.of(elements[0], elements[1]) : (len == 3 ? Tuple3.of(elements[0], elements[1], elements[2]) : (len == 4 ? Tuple4.of(elements[0], elements[1], elements[2], elements[3]) : Tuple5.of(elements[0], elements[1], elements[2], elements[3], elements[4])));
        return (T)ret;
    }

    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> tupleMSupplyMostSuccessAsync(long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        return CompletableFutureUtils.tupleMSupplyMostSuccessAsync(AsyncPoolHolder.ASYNC_POOL, timeout, unit, supplier1, supplier2);
    }

    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> tupleMSupplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2);
        return CompletableFutureUtils.mostSuccessTupleOf0(executor, timeout, unit, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> tupleMSupplyMostSuccessAsync(long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        return CompletableFutureUtils.tupleMSupplyMostSuccessAsync(AsyncPoolHolder.ASYNC_POOL, timeout, unit, supplier1, supplier2, supplier3);
    }

    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> tupleMSupplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2, supplier3);
        return CompletableFutureUtils.mostSuccessTupleOf0(executor, timeout, unit, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> tupleMSupplyMostSuccessAsync(long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        return CompletableFutureUtils.tupleMSupplyMostSuccessAsync(AsyncPoolHolder.ASYNC_POOL, timeout, unit, supplier1, supplier2, supplier3, supplier4);
    }

    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> tupleMSupplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2, supplier3, supplier4);
        return CompletableFutureUtils.mostSuccessTupleOf0(executor, timeout, unit, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyMostSuccessAsync(long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        return CompletableFutureUtils.tupleMSupplyMostSuccessAsync(AsyncPoolHolder.ASYNC_POOL, timeout, unit, supplier1, supplier2, supplier3, supplier4, supplier5);
    }

    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyMostSuccessAsync(Executor executor, long timeout, TimeUnit unit, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2, supplier3, supplier4, supplier5);
        return CompletableFutureUtils.mostSuccessTupleOf0(executor, timeout, unit, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    private static <T> CompletableFuture<T> mostSuccessTupleOf0(Executor executorWhenTimeout, long timeout, TimeUnit unit, CompletionStage<?> ... css) {
        Objects.requireNonNull(executorWhenTimeout, "executorWhenTimeout is null");
        Objects.requireNonNull(unit, "unit is null");
        CompletableFuture[] cfArray = CompletableFutureUtils.toNonMinCfArray(css);
        return CompletableFutureUtils.cffuCompleteOnTimeout(CompletableFuture.allOf(cfArray), null, executorWhenTimeout, timeout, unit).handle((unused, ex) -> CompletableFutureUtils.tupleOf0(CompletableFutureUtils.MGetSuccessNow0(null, cfArray)));
    }

    private static <T> T[] MGetSuccessNow0(@Nullable Object valueIfNotSuccess, CompletableFuture<?> ... cfs) {
        Object[] ret = new Object[cfs.length];
        for (int i = 0; i < cfs.length; ++i) {
            ret[i] = CompletableFutureUtils.getSuccessNow(cfs[i], valueIfNotSuccess);
        }
        return ret;
    }

    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> tupleMSupplyAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        return CompletableFutureUtils.tupleMSupplyAsync(AsyncPoolHolder.ASYNC_POOL, supplier1, supplier2);
    }

    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> tupleMSupplyAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2) {
        Objects.requireNonNull(executor, "executor is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2);
        return CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> tupleMSupplyAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        return CompletableFutureUtils.tupleMSupplyAsync(AsyncPoolHolder.ASYNC_POOL, supplier1, supplier2, supplier3);
    }

    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> tupleMSupplyAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3) {
        Objects.requireNonNull(executor, "executor is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2, supplier3);
        return CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> tupleMSupplyAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        return CompletableFutureUtils.tupleMSupplyAsync(AsyncPoolHolder.ASYNC_POOL, supplier1, supplier2, supplier3, supplier4);
    }

    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> tupleMSupplyAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4) {
        Objects.requireNonNull(executor, "executor is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2, supplier3, supplier4);
        return CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyAsync(Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        return CompletableFutureUtils.tupleMSupplyAsync(AsyncPoolHolder.ASYNC_POOL, supplier1, supplier2, supplier3, supplier4, supplier5);
    }

    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> tupleMSupplyAsync(Executor executor, Supplier<? extends T1> supplier1, Supplier<? extends T2> supplier2, Supplier<? extends T3> supplier3, Supplier<? extends T4> supplier4, Supplier<? extends T5> supplier5) {
        Objects.requireNonNull(executor, "executor is null");
        Supplier[] suppliers = CompletableFutureUtils.requireArrayAndEleNonNull("supplier", supplier1, supplier2, supplier3, supplier4, supplier5);
        return CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.wrapSuppliers(executor, suppliers));
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<List<T>> allResultsFastFailOf(CompletionStage<? extends T> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])cfs);
        int len = cfs.length;
        if (len == 0) {
            return CompletableFuture.completedFuture(CompletableFutureUtils.arrayList(new Object[0]));
        }
        if (len == 1) {
            return CompletableFutureUtils.toNonMinCfCopy(cfs[0]).thenApply(xva$0 -> CompletableFutureUtils.arrayList(xva$0));
        }
        CompletableFuture[] successOrBeIncomplete = new CompletableFuture[len];
        CompletableFuture[] failedOrBeIncomplete = new CompletableFuture[len + 1];
        CompletableFutureUtils.fill(cfs, successOrBeIncomplete, failedOrBeIncomplete);
        failedOrBeIncomplete[len] = CompletableFutureUtils.allResultsOf(successOrBeIncomplete);
        CompletableFuture<Object> ret = CompletableFuture.anyOf(failedOrBeIncomplete);
        return CompletableFutureUtils.f_cast(ret);
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<List<T>> mostSuccessResultsOf(@Nullable T valueIfNotSuccess, long timeout, TimeUnit unit, CompletionStage<? extends T> ... cfs) {
        return CompletableFutureUtils.mostSuccessResultsOf(valueIfNotSuccess, AsyncPoolHolder.ASYNC_POOL, timeout, unit, cfs);
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<List<T>> mostSuccessResultsOf(@Nullable T valueIfNotSuccess, Executor executorWhenTimeout, long timeout, TimeUnit unit, CompletionStage<? extends T> ... cfs) {
        Objects.requireNonNull(executorWhenTimeout, "executorWhenTimeout is null");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(cfs, "cfs is null");
        if (cfs.length == 0) {
            return CompletableFuture.completedFuture(CompletableFutureUtils.arrayList(new Object[0]));
        }
        if (cfs.length == 1) {
            CompletableFuture f = CompletableFutureUtils.toNonMinCfCopy(Objects.requireNonNull(cfs[0], "cf1 is null"));
            return CompletableFutureUtils.cffuCompleteOnTimeout(f, valueIfNotSuccess, executorWhenTimeout, timeout, unit).handle((unused, ex) -> CompletableFutureUtils.arrayList(CompletableFutureUtils.getSuccessNow(f, valueIfNotSuccess)));
        }
        CompletableFuture[] cfArray = CompletableFutureUtils.toNonMinCfArray(cfs);
        return CompletableFutureUtils.cffuCompleteOnTimeout(CompletableFuture.allOf(cfArray), null, executorWhenTimeout, timeout, unit).handle((unused, ex) -> CompletableFutureUtils.arrayList(CompletableFutureUtils.MGetSuccessNow0(valueIfNotSuccess, cfArray)));
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<List<T>> allResultsOf(CompletionStage<? extends T> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])cfs);
        int len = cfs.length;
        if (len == 0) {
            return CompletableFuture.completedFuture(CompletableFutureUtils.arrayList(new Object[0]));
        }
        if (len == 1) {
            return CompletableFutureUtils.toNonMinCfCopy(cfs[0]).thenApply(xva$0 -> CompletableFutureUtils.arrayList(xva$0));
        }
        Object[] result = new Object[len];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(cfs, result);
        CompletionStage ret = CompletableFuture.allOf(resultSetterCfs).thenApply(unused -> CompletableFutureUtils.arrayList(result));
        return CompletableFutureUtils.f_cast(ret);
    }

    @Contract(pure=true)
    public static CompletableFuture<Void> allFastFailOf(CompletionStage<?> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])cfs);
        int len = cfs.length;
        if (len == 0) {
            return CompletableFuture.completedFuture(null);
        }
        if (len == 1) {
            return CompletableFutureUtils.toNonMinCfCopy(cfs[0]).thenApply(unused -> null);
        }
        CompletableFuture[] successOrBeIncomplete = new CompletableFuture[len];
        CompletableFuture[] failedOrBeIncomplete = new CompletableFuture[len + 1];
        CompletableFutureUtils.fill(cfs, successOrBeIncomplete, failedOrBeIncomplete);
        failedOrBeIncomplete[len] = CompletableFuture.allOf(successOrBeIncomplete);
        CompletableFuture<Object> ret = CompletableFuture.anyOf(failedOrBeIncomplete);
        return CompletableFutureUtils.f_cast(ret);
    }

    public static CompletableFuture<Void> allOf(CompletionStage<?> ... cfs) {
        Objects.requireNonNull(cfs, "cfs is null");
        if (cfs.length == 0) {
            return CompletableFuture.completedFuture(null);
        }
        if (cfs.length == 1) {
            return CompletableFutureUtils.toNonMinCfCopy(Objects.requireNonNull(cfs[0], "cf1 is null")).thenApply(unused -> null);
        }
        return CompletableFuture.allOf(CompletableFutureUtils.f_toCfArray(cfs));
    }

    @SafeVarargs
    private static <S extends CompletionStage<?>> S[] requireCfsAndEleNonNull(S ... css) {
        return (CompletionStage[])CompletableFutureUtils.requireArrayAndEleNonNull("cf", css);
    }

    @SafeVarargs
    private static <T> List<T> arrayList(T ... elements) {
        ArrayList<T> ret = new ArrayList<T>(elements.length);
        ret.addAll(Arrays.asList(elements));
        return ret;
    }

    private static <T> CompletableFuture<Void>[] createResultSetterCfs(CompletionStage<? extends T>[] css, T[] result) {
        CompletableFuture[] resultSetterCfs = new CompletableFuture[result.length];
        int i = 0;
        while (i < result.length) {
            int index = i++;
            resultSetterCfs[index] = CompletableFutureUtils.f_toCf(css[index]).thenAccept(v -> {
                result[index] = v;
            });
        }
        return resultSetterCfs;
    }

    private static <T> void fill(CompletionStage<? extends T>[] css, CompletableFuture<? extends T>[] successOrBeIncomplete, CompletableFuture<? extends T>[] failedOrBeIncomplete) {
        CompletableFuture incomplete = new CompletableFuture();
        for (int i = 0; i < css.length; ++i) {
            CompletableFuture f = CompletableFutureUtils.f_toCf(css[i]);
            successOrBeIncomplete[i] = ((CompletableFuture)f.handle((v, ex) -> ex == null ? f : incomplete)).thenCompose(x -> x);
            failedOrBeIncomplete[i] = ((CompletableFuture)f.handle((v, ex) -> ex == null ? incomplete : f)).thenCompose(x -> x);
        }
    }

    private static <T> CompletableFuture<T> f_cast(CompletableFuture<?> cf) {
        return cf;
    }

    private static <T> CompletableFuture<T>[] f_toCfArray(CompletionStage<? extends T>[] stages) {
        return CompletableFutureUtils.toCfArray0(CompletableFutureUtils::f_toCf, stages);
    }

    private static <T> CompletableFuture<T>[] toNonMinCfArray(CompletionStage<? extends T>[] stages) {
        return CompletableFutureUtils.toCfArray0(CompletableFutureUtils::toNonMinCf, stages);
    }

    private static <T> CompletableFuture<T>[] toCfArray0(Function<CompletionStage<? extends T>, CompletableFuture<T>> converter, CompletionStage<? extends T>[] stages) {
        Objects.requireNonNull(stages, "cfs is null");
        CompletableFuture[] ret = new CompletableFuture[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            ret[i] = converter.apply(Objects.requireNonNull(stages[i], "cf" + (i + 1) + " is null"));
        }
        return ret;
    }

    private static <T> CompletableFuture<T> f_toCf(CompletionStage<? extends T> s) {
        if (s instanceof CompletableFuture) {
            return (CompletableFuture)s;
        }
        if (s instanceof Cffu) {
            return ((Cffu)s).cffuUnwrap();
        }
        return s.toCompletableFuture();
    }

    private static <T> CompletableFuture<T> toNonMinCf(CompletionStage<? extends T> s) {
        CompletableFuture<T> f = CompletableFutureUtils.f_toCf(s);
        return CompletableFutureUtils.isMinStageCf(f) ? f.toCompletableFuture() : f;
    }

    private static <T> CompletableFuture<T> toNonMinCfCopy(CompletionStage<? extends T> s) {
        CompletableFuture<T> f = CompletableFutureUtils.f_toCf(s);
        return CompletableFutureUtils.isMinStageCf(f) ? f.toCompletableFuture() : CompletableFutureUtils.copy(f);
    }

    private static boolean isMinStageCf(CompletableFuture<?> cf) {
        return "java.util.concurrent.CompletableFuture$MinimalStage".equals(cf.getClass().getName());
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T> anySuccessOf(CompletionStage<? extends T> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])cfs);
        int len = cfs.length;
        if (len == 0) {
            return CompletableFutureUtils.failedFuture(new NoCfsProvidedException());
        }
        if (len == 1) {
            return CompletableFutureUtils.toNonMinCfCopy(cfs[0]);
        }
        CompletableFuture[] successOrBeIncomplete = new CompletableFuture[len + 1];
        CompletableFuture[] failedOrBeIncomplete = new CompletableFuture[len];
        CompletableFutureUtils.fill(cfs, successOrBeIncomplete, failedOrBeIncomplete);
        successOrBeIncomplete[len] = CompletableFuture.allOf(failedOrBeIncomplete);
        CompletableFuture<Object> ret = CompletableFuture.anyOf(successOrBeIncomplete);
        return CompletableFutureUtils.f_cast(ret);
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T> anyOf(CompletionStage<? extends T> ... cfs) {
        Objects.requireNonNull(cfs, "cfs is null");
        if (cfs.length == 0) {
            return new CompletableFuture();
        }
        if (cfs.length == 1) {
            return CompletableFutureUtils.toNonMinCfCopy(Objects.requireNonNull(cfs[0], "cf1 is null"));
        }
        CompletableFuture<Object> ret = CompletableFuture.anyOf(CompletableFutureUtils.f_toCfArray(cfs));
        return CompletableFutureUtils.f_cast(ret);
    }

    @Contract(pure=true)
    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> allTupleFastFailOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2}));
    }

    @Contract(pure=true)
    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> allTupleFastFailOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3}));
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> allTupleFastFailOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3, cf4}));
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> allTupleFastFailOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3, cf4, cf5}));
    }

    @Contract(pure=true)
    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> mostSuccessTupleOf(long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return CompletableFutureUtils.mostSuccessTupleOf(AsyncPoolHolder.ASYNC_POOL, timeout, unit, cf1, cf2);
    }

    @Contract(pure=true)
    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> mostSuccessTupleOf(Executor executorWhenTimeout, long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return CompletableFutureUtils.mostSuccessTupleOf0(executorWhenTimeout, timeout, unit, cf1, cf2);
    }

    @Contract(pure=true)
    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> mostSuccessTupleOf(long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return CompletableFutureUtils.mostSuccessTupleOf(AsyncPoolHolder.ASYNC_POOL, timeout, unit, cf1, cf2, cf3);
    }

    @Contract(pure=true)
    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> mostSuccessTupleOf(Executor executorWhenTimeout, long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return CompletableFutureUtils.mostSuccessTupleOf0(executorWhenTimeout, timeout, unit, cf1, cf2, cf3);
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> mostSuccessTupleOf(long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return CompletableFutureUtils.mostSuccessTupleOf(AsyncPoolHolder.ASYNC_POOL, timeout, unit, cf1, cf2, cf3, cf4);
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> mostSuccessTupleOf(Executor executorWhenTimeout, long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return CompletableFutureUtils.mostSuccessTupleOf0(executorWhenTimeout, timeout, unit, cf1, cf2, cf3, cf4);
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> mostSuccessTupleOf(long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return CompletableFutureUtils.mostSuccessTupleOf(AsyncPoolHolder.ASYNC_POOL, timeout, unit, cf1, cf2, cf3, cf4, cf5);
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> mostSuccessTupleOf(Executor executorWhenTimeout, long timeout, TimeUnit unit, CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return CompletableFutureUtils.mostSuccessTupleOf0(executorWhenTimeout, timeout, unit, cf1, cf2, cf3, cf4, cf5);
    }

    @Contract(pure=true)
    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2}));
    }

    @Contract(pure=true)
    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3}));
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3, cf4}));
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3, cf4, cf5}));
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        Objects.requireNonNull(ex, "ex is null");
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.failedFuture(ex);
        }
        CompletableFuture cf = new CompletableFuture();
        cf.completeExceptionally(ex);
        return cf;
    }

    @Contract(pure=true)
    public static <T> CompletionStage<T> completedStage(@Nullable T value) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.completedStage(value);
        }
        return CompletableFuture.completedFuture(value);
    }

    @Contract(pure=true)
    public static <T> CompletionStage<T> failedStage(Throwable ex) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.failedStage(ex);
        }
        return CompletableFutureUtils.failedFuture(ex);
    }

    @Contract(pure=true)
    public static Executor delayedExecutor(long delay, TimeUnit unit) {
        return CompletableFutureUtils.delayedExecutor(delay, unit, AsyncPoolHolder.ASYNC_POOL);
    }

    @Contract(pure=true)
    public static Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.delayedExecutor(delay, unit, executor);
        }
        return new DelayedExecutor(delay, unit, executor);
    }

    @Contract(pure=true)
    public static Executor defaultExecutor() {
        return AsyncPoolHolder.ASYNC_POOL;
    }

    @SafeVarargs
    public static <T, U> CompletableFuture<List<U>> thenMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U> ... fns) {
        return CompletableFutureUtils.thenMApplyFastFailAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fns);
    }

    @SafeVarargs
    public static <T, U> CompletableFuture<List<U>> thenMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U> ... fns) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("fn", fns);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allResultsFastFailOf(CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    @SafeVarargs
    public static <T, U> CompletableFuture<List<U>> thenMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, @Nullable U valueIfNotSuccess, long timeout, TimeUnit unit, Function<? super T, ? extends U> ... fns) {
        return CompletableFutureUtils.thenMApplyMostSuccessAsync(cfThis, valueIfNotSuccess, AsyncPoolHolder.ASYNC_POOL, timeout, unit, fns);
    }

    @SafeVarargs
    public static <T, U> CompletableFuture<List<U>> thenMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, @Nullable U valueIfNotSuccess, Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U> ... fns) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("fn", fns);
        return cfThis.thenCompose(v -> CompletableFutureUtils.mostSuccessResultsOf(valueIfNotSuccess, executor, timeout, unit, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    @SafeVarargs
    public static <T, U> CompletableFuture<List<U>> thenMApplyAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U> ... fns) {
        return CompletableFutureUtils.thenMApplyAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fns);
    }

    @SafeVarargs
    public static <T, U> CompletableFuture<List<U>> thenMApplyAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U> ... fns) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("fn", fns);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allResultsOf(CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    private static <T, U> CompletableFuture<U>[] wrapFunctions(Executor executor, @Nullable T v, Function<? super T, ? extends U>[] fns) {
        CompletableFuture[] cfs = new CompletableFuture[fns.length];
        for (int i = 0; i < fns.length; ++i) {
            int idx = i;
            cfs[i] = CompletableFuture.supplyAsync(() -> fns[idx].apply(v), executor);
        }
        return cfs;
    }

    @SafeVarargs
    public static <T> CompletableFuture<Void> thenMAcceptAsync(CompletableFuture<? extends T> cfThis, Consumer<? super T> ... actions) {
        return CompletableFutureUtils.thenMAcceptAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, actions);
    }

    @SafeVarargs
    public static <T> CompletableFuture<Void> thenMAcceptAsync(CompletableFuture<? extends T> cfThis, Executor executor, Consumer<? super T> ... actions) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("action", actions);
        return cfThis.thenCompose(v -> CompletableFuture.allOf(CompletableFutureUtils.wrapConsumers(executor, v, actions)));
    }

    @SafeVarargs
    public static <T> CompletableFuture<Void> thenMAcceptFastFailAsync(CompletableFuture<? extends T> cfThis, Consumer<? super T> ... actions) {
        return CompletableFutureUtils.thenMAcceptFastFailAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, actions);
    }

    @SafeVarargs
    public static <T> CompletableFuture<Void> thenMAcceptFastFailAsync(CompletableFuture<? extends T> cfThis, Executor executor, Consumer<? super T> ... actions) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("action", actions);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allFastFailOf(CompletableFutureUtils.wrapConsumers(executor, v, actions)));
    }

    private static <T> CompletableFuture<Void>[] wrapConsumers(Executor executor, T v, Consumer<? super T>[] actions) {
        CompletableFuture[] cfs = new CompletableFuture[actions.length];
        int i = 0;
        while (i < actions.length) {
            int idx = i++;
            cfs[idx] = CompletableFuture.runAsync(() -> actions[idx].accept(v), executor);
        }
        return cfs;
    }

    public static CompletableFuture<Void> thenMRunFastFailAsync(CompletableFuture<?> cfThis, Runnable ... actions) {
        return CompletableFutureUtils.thenMRunFastFailAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, actions);
    }

    public static CompletableFuture<Void> thenMRunFastFailAsync(CompletableFuture<?> cfThis, Executor executor, Runnable ... actions) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("action", actions);
        return cfThis.thenCompose(unused -> CompletableFutureUtils.allFastFailOf(CompletableFutureUtils.wrapRunnables(executor, actions)));
    }

    public static CompletableFuture<Void> thenMRunAsync(CompletableFuture<?> cfThis, Runnable ... actions) {
        return CompletableFutureUtils.thenMRunAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, actions);
    }

    public static CompletableFuture<Void> thenMRunAsync(CompletableFuture<?> cfThis, Executor executor, Runnable ... actions) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        CompletableFutureUtils.requireArrayAndEleNonNull("action", actions);
        return cfThis.thenCompose(unused -> CompletableFuture.allOf(CompletableFutureUtils.wrapRunnables(executor, actions)));
    }

    public static <T, U1, U2> CompletableFuture<Tuple2<U1, U2>> thenTupleMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        return CompletableFutureUtils.thenTupleMApplyFastFailAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fn1, fn2);
    }

    public static <T, U1, U2> CompletableFuture<Tuple2<U1, U2>> thenTupleMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2, U3> CompletableFuture<Tuple3<U1, U2, U3>> thenTupleMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        return CompletableFutureUtils.thenTupleMApplyFastFailAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fn1, fn2, fn3);
    }

    public static <T, U1, U2, U3> CompletableFuture<Tuple3<U1, U2, U3>> thenTupleMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2, fn3);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2, U3, U4> CompletableFuture<Tuple4<U1, U2, U3, U4>> thenTupleMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        return CompletableFutureUtils.thenTupleMApplyFastFailAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fn1, fn2, fn3, fn4);
    }

    public static <T, U1, U2, U3, U4> CompletableFuture<Tuple4<U1, U2, U3, U4>> thenTupleMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2, fn3, fn4);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2, U3, U4, U5> CompletableFuture<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        return CompletableFutureUtils.thenTupleMApplyFastFailAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fn1, fn2, fn3, fn4, fn5);
    }

    public static <T, U1, U2, U3, U4, U5> CompletableFuture<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyFastFailAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2, fn3, fn4, fn5);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allTupleOf0(true, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2> CompletableFuture<Tuple2<U1, U2>> thenTupleMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        return CompletableFutureUtils.thenTupleMApplyMostSuccessAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, timeout, unit, fn1, fn2);
    }

    public static <T, U1, U2> CompletableFuture<Tuple2<U1, U2>> thenTupleMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2);
        return cfThis.thenCompose(v -> CompletableFutureUtils.mostSuccessTupleOf0(executor, timeout, unit, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2, U3> CompletableFuture<Tuple3<U1, U2, U3>> thenTupleMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        return CompletableFutureUtils.thenTupleMApplyMostSuccessAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, timeout, unit, fn1, fn2, fn3);
    }

    public static <T, U1, U2, U3> CompletableFuture<Tuple3<U1, U2, U3>> thenTupleMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2, fn3);
        return cfThis.thenCompose(v -> CompletableFutureUtils.mostSuccessTupleOf0(executor, timeout, unit, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2, U3, U4> CompletableFuture<Tuple4<U1, U2, U3, U4>> thenTupleMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        return CompletableFutureUtils.thenTupleMApplyMostSuccessAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, timeout, unit, fn1, fn2, fn3, fn4);
    }

    public static <T, U1, U2, U3, U4> CompletableFuture<Tuple4<U1, U2, U3, U4>> thenTupleMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2, fn3, fn4);
        return cfThis.thenCompose(v -> CompletableFutureUtils.mostSuccessTupleOf0(executor, timeout, unit, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2, U3, U4, U5> CompletableFuture<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        return CompletableFutureUtils.thenTupleMApplyMostSuccessAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, timeout, unit, fn1, fn2, fn3, fn4, fn5);
    }

    public static <T, U1, U2, U3, U4, U5> CompletableFuture<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyMostSuccessAsync(CompletableFuture<? extends T> cfThis, Executor executor, long timeout, TimeUnit unit, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(unit, "unit is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2, fn3, fn4, fn5);
        return cfThis.thenCompose(v -> CompletableFutureUtils.mostSuccessTupleOf0(executor, timeout, unit, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2> CompletableFuture<Tuple2<U1, U2>> thenTupleMApplyAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        return CompletableFutureUtils.thenTupleMApplyAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fn1, fn2);
    }

    public static <T, U1, U2> CompletableFuture<Tuple2<U1, U2>> thenTupleMApplyAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2, U3> CompletableFuture<Tuple3<U1, U2, U3>> thenTupleMApplyAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        return CompletableFutureUtils.thenTupleMApplyAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fn1, fn2, fn3);
    }

    public static <T, U1, U2, U3> CompletableFuture<Tuple3<U1, U2, U3>> thenTupleMApplyAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2, fn3);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2, U3, U4> CompletableFuture<Tuple4<U1, U2, U3, U4>> thenTupleMApplyAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        return CompletableFutureUtils.thenTupleMApplyAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fn1, fn2, fn3, fn4);
    }

    public static <T, U1, U2, U3, U4> CompletableFuture<Tuple4<U1, U2, U3, U4>> thenTupleMApplyAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2, fn3, fn4);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U1, U2, U3, U4, U5> CompletableFuture<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyAsync(CompletableFuture<? extends T> cfThis, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        return CompletableFutureUtils.thenTupleMApplyAsync(cfThis, AsyncPoolHolder.ASYNC_POOL, fn1, fn2, fn3, fn4, fn5);
    }

    public static <T, U1, U2, U3, U4, U5> CompletableFuture<Tuple5<U1, U2, U3, U4, U5>> thenTupleMApplyAsync(CompletableFuture<? extends T> cfThis, Executor executor, Function<? super T, ? extends U1> fn1, Function<? super T, ? extends U2> fn2, Function<? super T, ? extends U3> fn3, Function<? super T, ? extends U4> fn4, Function<? super T, ? extends U5> fn5) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executor, "executor is null");
        Function[] fns = CompletableFutureUtils.requireArrayAndEleNonNull("fn", fn1, fn2, fn3, fn4, fn5);
        return cfThis.thenCompose(v -> CompletableFutureUtils.allTupleOf0(false, CompletableFutureUtils.wrapFunctions(executor, v, fns)));
    }

    public static <T, U, V> CompletableFuture<V> thenCombineFastFail(CompletableFuture<? extends T> cfThis, CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(fn, "fn is null");
        return CompletableFutureUtils.bothFastFail0(cfThis, other).thenApply(t -> fn.apply((Object)t._1, (Object)t._2));
    }

    public static <T, U, V> CompletableFuture<V> thenCombineFastFailAsync(CompletableFuture<? extends T> cfThis, CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return CompletableFutureUtils.thenCombineFastFailAsync(cfThis, other, fn, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T, U, V> CompletableFuture<V> thenCombineFastFailAsync(CompletableFuture<? extends T> cfThis, CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.bothFastFail0(cfThis, other).thenApplyAsync(t -> fn.apply((Object)t._1, (Object)t._2), executor);
    }

    private static <T> void requireThisAndOtherNonNull(CompletionStage<? extends T> cfThis, CompletionStage<? extends T> other) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(other, "other is null");
    }

    private static <T1, T2> CompletableFuture<Tuple2<T1, T2>> bothFastFail0(CompletableFuture<? extends T1> cfThis, CompletionStage<? extends T2> other) {
        CompletableFuture incomplete = new CompletableFuture();
        CompletionStage thisSuccessOrBeIncomplete = ((CompletableFuture)cfThis.handle((v, ex) -> ex == null ? cfThis : incomplete)).thenCompose(x -> x);
        CompletionStage otherSuccessOrBeIncomplete = other.handle((v, ex) -> ex == null ? other : incomplete).thenCompose(x -> x);
        CompletionStage cfValue = ((CompletableFuture)thisSuccessOrBeIncomplete).thenCombine(otherSuccessOrBeIncomplete, Tuple2::of);
        CompletionStage thisFailedOrBeIncomplete = ((CompletableFuture)cfThis.handle((v, ex) -> ex == null ? incomplete : cfThis)).thenCompose(x -> x);
        CompletionStage otherFailedOrBeIncomplete = other.handle((v, ex) -> ex == null ? incomplete : other).thenCompose(x -> x);
        CompletionStage cfEx = ((CompletableFuture)thisFailedOrBeIncomplete).applyToEither(otherFailedOrBeIncomplete, v -> null);
        return ((CompletableFuture)cfValue).applyToEither(cfEx, x -> x);
    }

    public static <T, U> CompletableFuture<Void> thenAcceptBothFastFail(CompletableFuture<? extends T> cfThis, CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.bothFastFail0(cfThis, other).thenAccept(t -> action.accept((Object)t._1, (Object)t._2));
    }

    public static <T, U> CompletableFuture<Void> thenAcceptBothFastFailAsync(CompletableFuture<? extends T> cfThis, CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return CompletableFutureUtils.thenAcceptBothFastFailAsync(cfThis, other, action, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T, U> CompletableFuture<Void> thenAcceptBothFastFailAsync(CompletableFuture<? extends T> cfThis, CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.bothFastFail0(cfThis, other).thenAcceptAsync(t -> action.accept((Object)t._1, (Object)t._2), executor);
    }

    public static CompletableFuture<Void> runAfterBothFastFail(CompletableFuture<?> cfThis, CompletionStage<?> other, Runnable action) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.bothFastFail0(cfThis, other).thenRun(action);
    }

    public static CompletableFuture<Void> runAfterBothFastFailAsync(CompletableFuture<?> cfThis, CompletionStage<?> other, Runnable action) {
        return CompletableFutureUtils.runAfterBothFastFailAsync(cfThis, other, action, AsyncPoolHolder.ASYNC_POOL);
    }

    public static CompletableFuture<Void> runAfterBothFastFailAsync(CompletableFuture<?> cfThis, CompletionStage<?> other, Runnable action, Executor executor) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.bothFastFail0(cfThis, other).thenRunAsync(action, executor);
    }

    public static <T, U> CompletableFuture<U> applyToEitherSuccess(CompletableFuture<? extends T> cfThis, CompletionStage<? extends T> other, Function<? super T, ? extends U> fn) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(fn, "fn is null");
        return CompletableFutureUtils.eitherSuccess0(cfThis, other).thenApply(fn);
    }

    public static <T, U> CompletableFuture<U> applyToEitherSuccessAsync(CompletableFuture<? extends T> cfThis, CompletionStage<? extends T> other, Function<? super T, ? extends U> fn) {
        return CompletableFutureUtils.applyToEitherSuccessAsync(cfThis, other, fn, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T, U> CompletableFuture<U> applyToEitherSuccessAsync(CompletableFuture<? extends T> cfThis, CompletionStage<? extends T> other, Function<? super T, ? extends U> fn, Executor executor) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.eitherSuccess0(cfThis, other).thenApplyAsync(fn, executor);
    }

    private static <T> CompletableFuture<T> eitherSuccess0(CompletableFuture<? extends T> cfThis, CompletionStage<? extends T> other) {
        CompletableFuture incomplete = new CompletableFuture();
        CompletionStage thisSuccessOrBeIncomplete = ((CompletableFuture)cfThis.handle((v, ex) -> ex == null ? cfThis : incomplete)).thenCompose(x -> x);
        CompletionStage otherSuccessOrBeIncomplete = other.handle((v, ex) -> ex == null ? other : incomplete).thenCompose(x -> x);
        CompletionStage cfValue = ((CompletableFuture)thisSuccessOrBeIncomplete).applyToEither(otherSuccessOrBeIncomplete, x -> x);
        CompletionStage thisFailedOrBeIncomplete = ((CompletableFuture)cfThis.handle((v, ex) -> ex == null ? incomplete : cfThis)).thenCompose(x -> x);
        CompletionStage otherFailedOrBeIncomplete = other.handle((v, ex) -> ex == null ? incomplete : other).thenCompose(x -> x);
        CompletionStage cfEx = ((CompletableFuture)thisFailedOrBeIncomplete).thenCombine(otherFailedOrBeIncomplete, (v1, v2) -> null);
        return ((CompletableFuture)cfValue).applyToEither(cfEx, x -> x);
    }

    public static <T> CompletableFuture<Void> acceptEitherSuccess(CompletableFuture<? extends T> cfThis, CompletionStage<? extends T> other, Consumer<? super T> action) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.eitherSuccess0(cfThis, other).thenAccept((Consumer)action);
    }

    public static <T> CompletableFuture<Void> acceptEitherSuccessAsync(CompletableFuture<? extends T> cfThis, CompletionStage<? extends T> other, Consumer<? super T> action) {
        return CompletableFutureUtils.acceptEitherSuccessAsync(cfThis, other, action, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T> CompletableFuture<Void> acceptEitherSuccessAsync(CompletableFuture<? extends T> cfThis, CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.eitherSuccess0(cfThis, other).thenAcceptAsync((Consumer)action, executor);
    }

    public static CompletableFuture<Void> runAfterEitherSuccess(CompletableFuture<?> cfThis, CompletionStage<?> other, Runnable action) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.eitherSuccess0(cfThis, other).thenRun(action);
    }

    public static CompletableFuture<Void> runAfterEitherSuccessAsync(CompletableFuture<?> cfThis, CompletionStage<?> other, Runnable action) {
        return CompletableFutureUtils.runAfterEitherSuccessAsync(cfThis, other, action, AsyncPoolHolder.ASYNC_POOL);
    }

    public static CompletableFuture<Void> runAfterEitherSuccessAsync(CompletableFuture<?> cfThis, CompletionStage<?> other, Runnable action, Executor executor) {
        CompletableFutureUtils.requireThisAndOtherNonNull(cfThis, other);
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.eitherSuccess0(cfThis, other).thenRunAsync(action, executor);
    }

    public static <T, C extends CompletionStage<? super T>> C exceptionallyAsync(C cfThis, Function<Throwable, ? extends T> fn) {
        return CompletableFutureUtils.exceptionallyAsync(cfThis, fn, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T, C extends CompletionStage<? super T>> C exceptionallyAsync(C cfThis, Function<Throwable, ? extends T> fn, Executor executor) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        if (IS_JAVA12_PLUS) {
            return (C)cfThis.exceptionallyAsync(fn, executor);
        }
        return (C)cfThis.handle((r, ex) -> ex == null ? cfThis : cfThis.handleAsync((r1, ex1) -> fn.apply((Throwable)ex1), executor)).thenCompose(x -> x);
    }

    public static <C extends CompletableFuture<?>> C cffuOrTimeout(C cfThis, long timeout, TimeUnit unit) {
        return CompletableFutureUtils.cffuOrTimeout(cfThis, AsyncPoolHolder.ASYNC_POOL, timeout, unit);
    }

    public static <C extends CompletableFuture<?>> C cffuOrTimeout(C cfThis, Executor executorWhenTimeout, long timeout, TimeUnit unit) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executorWhenTimeout, "executorWhenTimeout is null");
        Objects.requireNonNull(unit, "unit is null");
        return CompletableFutureUtils.hopExecutorIfAtCfDelayerThread(CompletableFutureUtils.orTimeout(cfThis, timeout, unit), executorWhenTimeout);
    }

    public static <C extends CompletableFuture<?>> C orTimeout(C cfThis, long timeout, TimeUnit unit) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(unit, "unit is null");
        if (IS_JAVA9_PLUS) {
            cfThis.orTimeout(timeout, unit);
        } else if (!cfThis.isDone()) {
            ScheduledFuture<?> f = Delayer.delayToTimoutCf(cfThis, timeout, unit);
            cfThis.whenComplete((BiConsumer)new FutureCanceller(f));
        }
        return cfThis;
    }

    public static <T, C extends CompletableFuture<? super T>> C cffuCompleteOnTimeout(C cfThis, @Nullable T value, long timeout, TimeUnit unit) {
        return CompletableFutureUtils.cffuCompleteOnTimeout(cfThis, value, AsyncPoolHolder.ASYNC_POOL, timeout, unit);
    }

    public static <T, C extends CompletableFuture<? super T>> C cffuCompleteOnTimeout(C cfThis, @Nullable T value, Executor executorWhenTimeout, long timeout, TimeUnit unit) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(executorWhenTimeout, "executorWhenTimeout is null");
        Objects.requireNonNull(unit, "unit is null");
        return CompletableFutureUtils.hopExecutorIfAtCfDelayerThread(CompletableFutureUtils.completeOnTimeout(cfThis, value, timeout, unit), executorWhenTimeout);
    }

    public static <T, C extends CompletableFuture<? super T>> C completeOnTimeout(C cfThis, @Nullable T value, long timeout, TimeUnit unit) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(unit, "unit is null");
        if (IS_JAVA9_PLUS) {
            cfThis.completeOnTimeout(value, timeout, unit);
        } else if (!cfThis.isDone()) {
            ScheduledFuture<?> f = Delayer.delayToCompleteCf(cfThis, value, timeout, unit);
            cfThis.whenComplete((BiConsumer)new FutureCanceller(f));
        }
        return cfThis;
    }

    private static <C extends CompletableFuture<?>> C hopExecutorIfAtCfDelayerThread(C cf, Executor asyncExecutor) {
        CompletableFuture ret = CompletableFutureUtils.newIncompleteFuture(cf);
        ((CompletableFuture)cf.handle((v, ex) -> {
            if (!Delayer.atCfDelayerThread()) {
                CompletableFutureUtils.completeCf(ret, v, ex);
            } else {
                CompletableFutureUtils.delayedExecutor(0L, TimeUnit.SECONDS, asyncExecutor).execute(() -> CompletableFutureUtils.completeCf(ret, v, ex));
            }
            return null;
        })).exceptionally(ex -> ExceptionReporter.reportException("Exception occurred in handle of executor hop", ex));
        return (C)ret;
    }

    private static void completeCf(CompletableFuture<Object> cf, Object value, @Nullable Throwable ex) {
        try {
            if (ex == null) {
                cf.complete(value);
            } else {
                cf.completeExceptionally(ex);
            }
        }
        catch (Throwable t) {
            if (ex != null) {
                t.addSuppressed(ex);
            }
            ExceptionReporter.reportException("Exception occurred in completeCf", t);
            throw t;
        }
    }

    public static <T, C extends CompletionStage<? super T>> C exceptionallyCompose(C cfThis, Function<Throwable, ? extends CompletionStage<T>> fn) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(fn, "fn is null");
        if (IS_JAVA12_PLUS) {
            return (C)cfThis.exceptionallyCompose(fn);
        }
        return (C)cfThis.handle((r, ex) -> ex == null ? cfThis : (CompletionStage)fn.apply((Throwable)ex)).thenCompose(x -> x);
    }

    public static <T, C extends CompletionStage<? super T>> C exceptionallyComposeAsync(C cfThis, Function<Throwable, ? extends CompletionStage<T>> fn) {
        return CompletableFutureUtils.exceptionallyComposeAsync(cfThis, fn, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T, C extends CompletionStage<? super T>> C exceptionallyComposeAsync(C cfThis, Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        if (IS_JAVA12_PLUS) {
            return (C)cfThis.exceptionallyComposeAsync(fn, executor);
        }
        return (C)cfThis.handle((r, ex) -> ex == null ? cfThis : cfThis.handleAsync((r1, ex1) -> (CompletionStage)fn.apply((Throwable)ex1), executor).thenCompose(x -> x)).thenCompose(x -> x);
    }

    public static <T, C extends CompletionStage<? extends T>> C peek(C cfThis, BiConsumer<? super T, ? super Throwable> action) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(action, "action is null");
        cfThis.whenComplete(action).exceptionally(ex -> ExceptionReporter.reportException("Exception occurred in the action of peek", ex));
        return cfThis;
    }

    public static <T, C extends CompletionStage<? extends T>> C peekAsync(C cfThis, BiConsumer<? super T, ? super Throwable> action) {
        return CompletableFutureUtils.peekAsync(cfThis, action, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T, C extends CompletionStage<? extends T>> C peekAsync(C cfThis, BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        cfThis.whenCompleteAsync(action, executor).exceptionally(ex -> ExceptionReporter.reportException("Exception occurred in the action of peekAsync", ex));
        return cfThis;
    }

    @Blocking
    @Nullable
    public static <T> T join(CompletableFuture<T> cfThis, long timeout, TimeUnit unit) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(unit, "unit is null");
        if (cfThis.isDone()) {
            return cfThis.join();
        }
        return CompletableFutureUtils.orTimeout(CompletableFutureUtils.copy(cfThis), timeout, unit).join();
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T getSuccessNow(CompletableFuture<? extends T> cfThis, @Nullable T valueIfNotSuccess) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        return cfThis.isDone() && !cfThis.isCompletedExceptionally() ? cfThis.join() : valueIfNotSuccess;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T resultNow(Future<T> cfThis) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        if (IS_JAVA19_PLUS) {
            return cfThis.resultNow();
        }
        if (!cfThis.isDone()) {
            throw new IllegalStateException("Task has not completed");
        }
        if (cfThis.isCancelled()) {
            throw new IllegalStateException("Task was cancelled");
        }
        if (cfThis instanceof CompletableFuture ? ((CompletableFuture)cfThis).isCompletedExceptionally() : cfThis instanceof Cffu && ((Cffu)cfThis).isCompletedExceptionally()) {
            throw new IllegalStateException("Task completed with exception");
        }
        boolean interrupted = false;
        while (true) {
            try {
                T t = cfThis.get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Task completed with exception");
            }
            catch (CancellationException e) {
                throw new IllegalStateException("Task was cancelled");
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    public static Throwable exceptionNow(Future<?> cfThis) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        if (IS_JAVA19_PLUS) {
            return cfThis.exceptionNow();
        }
        if (!cfThis.isDone()) {
            throw new IllegalStateException("Task has not completed");
        }
        if (cfThis.isCancelled()) {
            throw new IllegalStateException("Task was cancelled");
        }
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    cfThis.get();
                    throw new IllegalStateException("Task completed with a result");
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    return throwable;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    public static CffuState state(Future<?> cfThis) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        if (IS_JAVA19_PLUS) {
            return CffuState.toCffuState(cfThis.state());
        }
        if (!cfThis.isDone()) {
            return CffuState.RUNNING;
        }
        if (cfThis.isCancelled()) {
            return CffuState.CANCELLED;
        }
        if (cfThis instanceof CompletableFuture) {
            if (((CompletableFuture)cfThis).isCompletedExceptionally()) {
                return CffuState.FAILED;
            }
            return CffuState.SUCCESS;
        }
        if (cfThis instanceof Cffu) {
            if (((Cffu)cfThis).isCompletedExceptionally()) {
                return CffuState.FAILED;
            }
            return CffuState.SUCCESS;
        }
        boolean interrupted = false;
        while (true) {
            try {
                cfThis.get();
                CffuState cffuState = CffuState.SUCCESS;
                return cffuState;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                CffuState cffuState = CffuState.FAILED;
                return cffuState;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T, C extends CompletableFuture<? super T>> C completeAsync(C cfThis, Supplier<? extends T> supplier) {
        return CompletableFutureUtils.completeAsync(cfThis, supplier, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T, C extends CompletableFuture<? super T>> C completeAsync(C cfThis, Supplier<? extends T> supplier, Executor executor) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(supplier, "supplier is null");
        Objects.requireNonNull(executor, "executor is null");
        if (IS_JAVA9_PLUS) {
            cfThis.completeAsync(supplier, executor);
        } else {
            executor.execute(new CfCompleterBySupplier<T>(cfThis, supplier));
        }
        return cfThis;
    }

    public static <C extends CompletableFuture<?>> C completeExceptionallyAsync(C cfThis, Supplier<? extends Throwable> supplier) {
        return CompletableFutureUtils.completeExceptionallyAsync(cfThis, supplier, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <C extends CompletableFuture<?>> C completeExceptionallyAsync(C cfThis, Supplier<? extends Throwable> supplier, Executor executor) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        Objects.requireNonNull(supplier, "supplier is null");
        Objects.requireNonNull(executor, "executor is null");
        if (CompletableFutureUtils.isMinStageCf(cfThis)) {
            throw new UnsupportedOperationException();
        }
        executor.execute(new CfExCompleterBySupplier(cfThis, supplier));
        return cfThis;
    }

    @Contract(pure=true)
    public static <T> CompletionStage<T> minimalCompletionStage(CompletableFuture<T> cfThis) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        if (IS_JAVA9_PLUS) {
            return cfThis.minimalCompletionStage();
        }
        return cfThis.thenApply(x -> x);
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T> copy(CompletableFuture<T> cfThis) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        if (IS_JAVA9_PLUS) {
            return cfThis.copy();
        }
        return cfThis.thenApply(x -> x);
    }

    @Contract(pure=true)
    public static <U> CompletableFuture<U> newIncompleteFuture(CompletableFuture<?> cfThis) {
        Objects.requireNonNull(cfThis, "cfThis is null");
        if (IS_JAVA9_PLUS) {
            return cfThis.newIncompleteFuture();
        }
        return new CompletableFuture();
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] toCompletableFutureArray(CompletionStage<T> ... stages) {
        Objects.requireNonNull(stages, "stages is null");
        CompletableFuture[] ret = new CompletableFuture[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            ret[i] = Objects.requireNonNull(stages[i], "stage" + (i + 1) + " is null").toCompletableFuture();
        }
        return ret;
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] completableFutureListToArray(List<CompletableFuture<T>> cfList) {
        Objects.requireNonNull(cfList, "cfList is null");
        CompletableFuture[] a = new CompletableFuture[cfList.size()];
        return cfList.toArray(a);
    }

    public static Throwable unwrapCfException(Throwable ex) {
        if (!(ex instanceof CompletionException) && !(ex instanceof ExecutionException)) {
            return ex;
        }
        if (ex.getCause() == null) {
            return ex;
        }
        return ex.getCause();
    }

    static Executor screenExecutor(Executor e) {
        if (!USE_COMMON_POOL && e == ForkJoinPool.commonPool()) {
            return AsyncPoolHolder.ASYNC_POOL;
        }
        return Objects.requireNonNull(e, "defaultExecutor is null");
    }

    private CompletableFutureUtils() {
    }

    static {
        boolean b;
        USE_COMMON_POOL = ForkJoinPool.getCommonPoolParallelism() > 1;
        try {
            CompletableFuture.completedStage(null);
            b = true;
        }
        catch (NoSuchMethodError e) {
            b = false;
        }
        IS_JAVA9_PLUS = b;
        CompletableFuture<Integer> cf = CompletableFuture.completedFuture(42);
        try {
            cf.exceptionallyCompose(v -> cf);
            b = true;
        }
        catch (NoSuchMethodError e) {
            b = false;
        }
        IS_JAVA12_PLUS = b;
        try {
            cf.resultNow();
            b = true;
        }
        catch (NoSuchMethodError e) {
            b = false;
        }
        IS_JAVA19_PLUS = b;
    }

    private static class AsyncPoolHolder {
        private static final Executor ASYNC_POOL = AsyncPoolHolder._asyncPool0();

        private AsyncPoolHolder() {
        }

        private static Executor _asyncPool0() {
            if (IS_JAVA9_PLUS) {
                return CompletableFuture.completedFuture(null).defaultExecutor();
            }
            if (USE_COMMON_POOL) {
                return ForkJoinPool.commonPool();
            }
            return new ThreadPerTaskExecutor();
        }
    }

    private static final class ThreadPerTaskExecutor
    implements Executor {
        private ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(Objects.requireNonNull(r)).start();
        }
    }
}

