/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.foldright.cffu.CfCompleter;
import io.foldright.cffu.CfTimeout;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class Delayer {
    private static final String THREAD_NAME_OF_CFFU_DELAY_SCHEDULER = "CffuBuiltinDelayScheduler";

    static ScheduledFuture<?> delay(Runnable command, long delay, TimeUnit unit) {
        return DelayerHolder.delayer.schedule(command, delay, unit);
    }

    static ScheduledFuture<?> delayToTimoutCf(CompletableFuture<?> cf, long delay, TimeUnit unit) {
        return Delayer.delay(new CfTimeout(cf), delay, unit);
    }

    static <T> ScheduledFuture<?> delayToCompleteCf(CompletableFuture<? super T> cf, @Nullable T value, long delay, TimeUnit unit) {
        return Delayer.delay(new CfCompleter<T>(cf, value), delay, unit);
    }

    static boolean atCfDelayerThread() {
        String name = Thread.currentThread().getName();
        return "CompletableFutureDelayScheduler".equals(name) || THREAD_NAME_OF_CFFU_DELAY_SCHEDULER.equals(name);
    }

    private Delayer() {
    }

    private static class DelayerHolder {
        static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

        private DelayerHolder() {
        }

        static {
            delayer.setRemoveOnCancelPolicy(true);
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(Delayer.THREAD_NAME_OF_CFFU_DELAY_SCHEDULER);
            return t;
        }
    }
}

