/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

class ExceptionReporter {
    private static final String CFFU_PACKAGE_NAME = ExceptionReporter.class.getName().replaceFirst("\\.[^.]*$", "");
    private static final LoggerAdapter logger = ExceptionReporter.getLogger();

    ExceptionReporter() {
    }

    @Nullable
    static <T> T reportException(String msg, Throwable ex) {
        String fullReport = "full";
        String shortReport = "short";
        String report = System.getProperty("cffu.uncaught.exception.report", "short");
        if ("full".equals(report)) {
            logger.error(msg, ex);
        } else if ("short".equals(report)) {
            logger.error(msg + ", " + ex, null);
        }
        return null;
    }

    private static LoggerAdapter getLogger() {
        try {
            return new Slf4jLoggerAdapter();
        }
        catch (NoClassDefFoundError e) {
            return new JulLoggerAdapter();
        }
    }

    static /* synthetic */ String access$200() {
        return CFFU_PACKAGE_NAME;
    }

    private static interface LoggerAdapter {
        public void error(String var1, @Nullable Throwable var2);
    }

    private static class Slf4jLoggerAdapter
    implements LoggerAdapter {
        private final String FQCN = Slf4jLoggerAdapter.class.getName();
        private final Logger logger = LoggerFactory.getLogger((String)ExceptionReporter.access$200());

        private Slf4jLoggerAdapter() {
        }

        @Override
        public void error(String msg, @Nullable Throwable ex) {
            if (this.logger instanceof LocationAwareLogger) {
                ((LocationAwareLogger)this.logger).log(null, this.FQCN, 40, msg, null, ex);
            } else {
                this.logger.error(msg, ex);
            }
        }
    }

    private static class JulLoggerAdapter
    implements LoggerAdapter {
        private final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(ExceptionReporter.access$200());

        private JulLoggerAdapter() {
        }

        @Override
        public void error(String msg, @Nullable Throwable ex) {
            this.logger.log(Level.SEVERE, msg, ex);
        }
    }
}

