/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public enum CffuState {
    RUNNING{

        @Override
        public Future.State toFutureState() {
            return Future.State.RUNNING;
        }
    }
    ,
    SUCCESS{

        @Override
        public Future.State toFutureState() {
            return Future.State.SUCCESS;
        }
    }
    ,
    FAILED{

        @Override
        public Future.State toFutureState() {
            return Future.State.FAILED;
        }
    }
    ,
    CANCELLED{

        @Override
        public Future.State toFutureState() {
            return Future.State.CANCELLED;
        }
    };


    @Contract(pure=true)
    public abstract Future.State toFutureState();

    @Contract(pure=true)
    public static CffuState toCffuState(Future.State state) {
        switch (Objects.requireNonNull(state, "state argument is null")) {
            case RUNNING: {
                return RUNNING;
            }
            case SUCCESS: {
                return SUCCESS;
            }
            case FAILED: {
                return FAILED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
        }
        throw new IllegalStateException("unknown Future.State: " + (Object)((Object)state));
    }
}

