/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import io.foldright.cffu.CfCompleterBySupplier;
import io.foldright.cffu.CffuState;
import io.foldright.cffu.DelayedExecutor;
import io.foldright.cffu.Delayer;
import io.foldright.cffu.FutureCanceller;
import io.foldright.cffu.NoCfsProvidedException;
import io.foldright.cffu.tuple.Tuple2;
import io.foldright.cffu.tuple.Tuple3;
import io.foldright.cffu.tuple.Tuple4;
import io.foldright.cffu.tuple.Tuple5;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public final class CompletableFutureUtils {
    private static final boolean USE_COMMON_POOL;
    private static final boolean IS_JAVA9_PLUS;
    private static final boolean IS_JAVA12_PLUS;
    private static final boolean IS_JAVA19_PLUS;

    public static CompletableFuture<Void> allOf(CompletionStage<?> ... cfs) {
        return CompletableFuture.allOf(CompletableFutureUtils.f_toCfArray(cfs));
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<List<T>> allResultsOf(CompletionStage<? extends T> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])cfs);
        int size = cfs.length;
        if (size == 0) {
            return CompletableFuture.completedFuture(CompletableFutureUtils.arrayList(new Object[0]));
        }
        if (size == 1) {
            return CompletableFutureUtils.csToListCf(cfs[0]);
        }
        Object[] result = new Object[size];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(cfs, result);
        CompletionStage ret = CompletableFuture.allOf(resultSetterCfs).thenApply(unused -> CompletableFutureUtils.arrayList(result));
        return CompletableFutureUtils.f_cast(ret);
    }

    @Contract(pure=true)
    public static CompletableFuture<Void> allOfFastFail(CompletionStage<?> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])cfs);
        int size = cfs.length;
        if (size == 0) {
            return CompletableFuture.completedFuture(null);
        }
        if (size == 1) {
            return cfs[0].toCompletableFuture().thenApply(v -> null);
        }
        CompletableFuture[] successOrBeIncomplete = new CompletableFuture[size];
        CompletableFuture[] failedOrBeIncomplete = new CompletableFuture[size + 1];
        CompletableFutureUtils.fill(cfs, successOrBeIncomplete, failedOrBeIncomplete);
        failedOrBeIncomplete[size] = CompletableFuture.allOf(successOrBeIncomplete);
        CompletableFuture<Object> ret = CompletableFuture.anyOf(failedOrBeIncomplete);
        return CompletableFutureUtils.f_cast(ret);
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<List<T>> allResultsOfFastFail(CompletionStage<? extends T> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])cfs);
        int size = cfs.length;
        if (size == 0) {
            return CompletableFuture.completedFuture(CompletableFutureUtils.arrayList(new Object[0]));
        }
        if (size == 1) {
            return CompletableFutureUtils.csToListCf(cfs[0]);
        }
        CompletableFuture[] successOrBeIncomplete = new CompletableFuture[size];
        CompletableFuture[] failedOrBeIncomplete = new CompletableFuture[size + 1];
        CompletableFutureUtils.fill(cfs, successOrBeIncomplete, failedOrBeIncomplete);
        failedOrBeIncomplete[size] = CompletableFutureUtils.allResultsOf(successOrBeIncomplete);
        CompletableFuture<Object> ret = CompletableFuture.anyOf(failedOrBeIncomplete);
        return CompletableFutureUtils.f_cast(ret);
    }

    @SafeVarargs
    private static <S extends CompletionStage<?>> S[] requireCfsAndEleNonNull(S ... css) {
        Objects.requireNonNull(css, "cfs is null");
        for (int i = 0; i < css.length; ++i) {
            Objects.requireNonNull(css[i], "cf" + (i + 1) + " is null");
        }
        return css;
    }

    @SafeVarargs
    private static <T> List<T> arrayList(T ... elements) {
        ArrayList<T> ret = new ArrayList<T>(elements.length);
        ret.addAll(Arrays.asList(elements));
        return ret;
    }

    private static <T> CompletableFuture<List<T>> csToListCf(CompletionStage<? extends T> s) {
        return s.toCompletableFuture().thenApply(xva$0 -> CompletableFutureUtils.arrayList(xva$0));
    }

    private static <T> CompletableFuture<Void>[] createResultSetterCfs(CompletionStage<? extends T>[] css, T[] result) {
        CompletableFuture[] resultSetterCfs = new CompletableFuture[result.length];
        int i = 0;
        while (i < result.length) {
            int index = i++;
            resultSetterCfs[index] = css[index].toCompletableFuture().thenAccept(v -> {
                result[index] = v;
            });
        }
        return resultSetterCfs;
    }

    private static <T> void fill(CompletionStage<? extends T>[] cfs, CompletableFuture<? extends T>[] successOrBeIncomplete, CompletableFuture<? extends T>[] failedOrBeIncomplete) {
        CompletableFuture incomplete = new CompletableFuture();
        for (int i = 0; i < cfs.length; ++i) {
            CompletionStage cf = cfs[i];
            successOrBeIncomplete[i] = ((CompletableFuture)cf.toCompletableFuture().handle((v, ex) -> ex == null ? cf : incomplete)).thenCompose(x -> x);
            failedOrBeIncomplete[i] = ((CompletableFuture)cf.toCompletableFuture().handle((v, ex) -> ex == null ? incomplete : cf)).thenCompose(x -> x);
        }
    }

    private static <T> CompletableFuture<T> f_cast(CompletableFuture<?> f) {
        return f;
    }

    private static <T> CompletableFuture<T>[] f_toCfArray(CompletionStage<? extends T>[] cfs) {
        return CompletableFutureUtils.toCompletableFutureArray(cfs);
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T> anyOf(CompletionStage<? extends T> ... cfs) {
        CompletableFuture<Object> ret = CompletableFuture.anyOf(CompletableFutureUtils.f_toCfArray(cfs));
        return CompletableFutureUtils.f_cast(ret);
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T> anyOfSuccess(CompletionStage<? extends T> ... cfs) {
        CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])cfs);
        int size = cfs.length;
        if (size == 0) {
            return CompletableFutureUtils.failedFuture(new NoCfsProvidedException());
        }
        if (size == 1) {
            return CompletableFutureUtils.f_cast(CompletableFutureUtils.copy(cfs[0].toCompletableFuture()));
        }
        CompletableFuture[] successOrBeIncomplete = new CompletableFuture[size + 1];
        CompletableFuture[] failedOrBeIncomplete = new CompletableFuture[size];
        CompletableFutureUtils.fill(cfs, successOrBeIncomplete, failedOrBeIncomplete);
        successOrBeIncomplete[size] = CompletableFuture.allOf(failedOrBeIncomplete);
        CompletableFuture<Object> ret = CompletableFuture.anyOf(successOrBeIncomplete);
        return CompletableFutureUtils.f_cast(ret);
    }

    @Contract(pure=true)
    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return CompletableFutureUtils.allTupleOf0(CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2}), false);
    }

    @Contract(pure=true)
    public static <T1, T2> CompletableFuture<Tuple2<T1, T2>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2) {
        return CompletableFutureUtils.allTupleOf0(CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2}), true);
    }

    @Contract(pure=true)
    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return CompletableFutureUtils.allTupleOf0(CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3}), false);
    }

    @Contract(pure=true)
    public static <T1, T2, T3> CompletableFuture<Tuple3<T1, T2, T3>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3) {
        return CompletableFutureUtils.allTupleOf0(CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3}), true);
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return CompletableFutureUtils.allTupleOf0(CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3, cf4}), false);
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4> CompletableFuture<Tuple4<T1, T2, T3, T4>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4) {
        return CompletableFutureUtils.allTupleOf0(CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3, cf4}), true);
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> allTupleOf(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return CompletableFutureUtils.allTupleOf0(CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3, cf4, cf5}), false);
    }

    @Contract(pure=true)
    public static <T1, T2, T3, T4, T5> CompletableFuture<Tuple5<T1, T2, T3, T4, T5>> allTupleOfFastFail(CompletionStage<? extends T1> cf1, CompletionStage<? extends T2> cf2, CompletionStage<? extends T3> cf3, CompletionStage<? extends T4> cf4, CompletionStage<? extends T5> cf5) {
        return CompletableFutureUtils.allTupleOf0(CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2, cf3, cf4, cf5}), true);
    }

    private static <T> CompletableFuture<T> allTupleOf0(CompletionStage<?>[] css, boolean fastFail) {
        int length = css.length;
        Object[] result = new Object[length];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(css, result);
        CompletableFuture<Void> resultSetter = fastFail ? CompletableFutureUtils.allOfFastFail(resultSetterCfs) : CompletableFuture.allOf(resultSetterCfs);
        CompletionStage ret = resultSetter.thenApply(unused -> {
            if (length == 2) {
                return Tuple2.of(result[0], result[1]);
            }
            if (length == 3) {
                return Tuple3.of(result[0], result[1], result[2]);
            }
            if (length == 4) {
                return Tuple4.of(result[0], result[1], result[2], result[3]);
            }
            return Tuple5.of(result[0], result[1], result[2], result[3], result[4]);
        });
        return CompletableFutureUtils.f_cast(ret);
    }

    public static CompletableFuture<Void> runAfterBothFastFail(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.allOfFastFail(css).thenRun(action);
    }

    public static CompletableFuture<Void> runAfterBothFastFailAsync(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.allOfFastFail(css).thenRunAsync(action);
    }

    public static CompletableFuture<Void> runAfterBothFastFailAsync(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action, Executor executor) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.allOfFastFail(css).thenRunAsync(action, executor);
    }

    public static <T, U> CompletableFuture<Void> thenAcceptBothFastFail(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiConsumer<? super T, ? super U> action) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        Object[] result = new Object[css.length];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(css, result);
        return CompletableFutureUtils.allOfFastFail(resultSetterCfs).thenAccept(unused -> action.accept(result[0], result[1]));
    }

    public static <T, U> CompletableFuture<Void> thenAcceptBothFastFailAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiConsumer<? super T, ? super U> action) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        Object[] result = new Object[css.length];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(css, result);
        return CompletableFutureUtils.allOfFastFail(resultSetterCfs).thenAcceptAsync(unused -> action.accept(result[0], result[1]));
    }

    public static <T, U> CompletableFuture<Void> thenAcceptBothFastFailAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiConsumer<? super T, ? super U> action, Executor executor) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        Object[] result = new Object[css.length];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(css, result);
        return CompletableFutureUtils.allOfFastFail(resultSetterCfs).thenAcceptAsync(unused -> action.accept(result[0], result[1]), executor);
    }

    public static <T, U, V> CompletableFuture<V> thenCombineFastFail(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiFunction<? super T, ? super U, ? extends V> fn) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(fn, "fn is null");
        Object[] result = new Object[css.length];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(css, result);
        return CompletableFutureUtils.allOfFastFail(resultSetterCfs).thenApply(unused -> fn.apply(result[0], result[1]));
    }

    public static <T, U, V> CompletableFuture<V> thenCombineFastFailAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiFunction<? super T, ? super U, ? extends V> fn) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(fn, "fn is null");
        Object[] result = new Object[css.length];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(css, result);
        return CompletableFutureUtils.allOfFastFail(resultSetterCfs).thenApplyAsync(unused -> fn.apply(result[0], result[1]));
    }

    public static <T, U, V> CompletableFuture<V> thenCombineFastFailAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends U> cf2, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        Object[] result = new Object[css.length];
        CompletableFuture<Void>[] resultSetterCfs = CompletableFutureUtils.createResultSetterCfs(css, result);
        return CompletableFutureUtils.allOfFastFail(resultSetterCfs).thenApplyAsync(unused -> fn.apply(result[0], result[1]), executor);
    }

    public static CompletableFuture<Void> runAfterEitherSuccess(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.anyOfSuccess(css).thenRun(action);
    }

    public static CompletableFuture<Void> runAfterEitherSuccessAsync(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.anyOfSuccess(css).thenRunAsync(action);
    }

    public static CompletableFuture<Void> runAfterEitherSuccessAsync(CompletionStage<?> cf1, CompletionStage<?> cf2, Runnable action, Executor executor) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.anyOfSuccess(css).thenRunAsync(action, executor);
    }

    public static <T> CompletableFuture<Void> acceptEitherSuccess(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Consumer<? super T> action) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.anyOfSuccess(css).thenAccept((Consumer)action);
    }

    public static <T> CompletableFuture<Void> acceptEitherSuccessAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Consumer<? super T> action) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        return CompletableFutureUtils.anyOfSuccess(css).thenAcceptAsync((Consumer)action);
    }

    public static <T> CompletableFuture<Void> acceptEitherSuccessAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Consumer<? super T> action, Executor executor) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(action, "action is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.anyOfSuccess(css).thenAcceptAsync((Consumer)action, executor);
    }

    public static <T, U> CompletableFuture<U> applyToEitherSuccess(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Function<? super T, ? extends U> fn) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(fn, "fn is null");
        return CompletableFutureUtils.anyOfSuccess(css).thenApply(fn);
    }

    public static <T, U> CompletableFuture<U> applyToEitherSuccessAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Function<? super T, ? extends U> fn) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(fn, "fn is null");
        return CompletableFutureUtils.anyOfSuccess(css).thenApplyAsync(fn);
    }

    public static <T, U> CompletableFuture<U> applyToEitherSuccessAsync(CompletionStage<? extends T> cf1, CompletionStage<? extends T> cf2, Function<? super T, ? extends U> fn, Executor executor) {
        CompletionStage[] css = CompletableFutureUtils.requireCfsAndEleNonNull((CompletionStage[])new CompletionStage[]{cf1, cf2});
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        return CompletableFutureUtils.anyOfSuccess(css).thenApplyAsync(fn, executor);
    }

    public static <T, C extends CompletionStage<? extends T>> C peek(C cf, BiConsumer<? super T, ? super Throwable> action) {
        cf.whenComplete(action);
        return cf;
    }

    public static <T, C extends CompletionStage<? extends T>> C peekAsync(C cf, BiConsumer<? super T, ? super Throwable> action) {
        cf.whenCompleteAsync(action);
        return cf;
    }

    public static <T, C extends CompletionStage<? extends T>> C peekAsync(C cf, BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        cf.whenCompleteAsync(action, executor);
        return cf;
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.failedFuture(ex);
        }
        Objects.requireNonNull(ex, "ex is null");
        CompletableFuture cf = new CompletableFuture();
        cf.completeExceptionally(ex);
        return cf;
    }

    @Contract(pure=true)
    public static <T> CompletionStage<T> completedStage(@Nullable T value) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.completedStage(value);
        }
        return CompletableFuture.completedFuture(value);
    }

    @Contract(pure=true)
    public static <T> CompletionStage<T> failedStage(Throwable ex) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.failedStage(ex);
        }
        CompletableFuture cf = new CompletableFuture();
        cf.completeExceptionally(ex);
        return cf;
    }

    @Contract(pure=true)
    public static Executor delayedExecutor(long delay, TimeUnit unit) {
        return CompletableFutureUtils.delayedExecutor(delay, unit, AsyncPoolHolder.ASYNC_POOL);
    }

    @Contract(pure=true)
    public static Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        if (IS_JAVA9_PLUS) {
            return CompletableFuture.delayedExecutor(delay, unit, executor);
        }
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        return new DelayedExecutor(delay, unit, executor);
    }

    public static <T> CompletableFuture<T> exceptionallyAsync(CompletableFuture<T> cf, Function<Throwable, ? extends T> fn) {
        return CompletableFutureUtils.exceptionallyAsync(cf, fn, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T> CompletableFuture<T> exceptionallyAsync(CompletableFuture<T> cf, Function<Throwable, ? extends T> fn, Executor executor) {
        if (IS_JAVA12_PLUS) {
            return cf.exceptionallyAsync(fn, executor);
        }
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        return ((CompletableFuture)cf.handle((r, ex) -> ex == null ? cf : cf.handleAsync((r1, ex1) -> fn.apply((Throwable)ex1), executor))).thenCompose(x -> x);
    }

    public static <C extends CompletableFuture<?>> C orTimeout(C cf, long timeout, TimeUnit unit) {
        if (IS_JAVA9_PLUS) {
            cf.orTimeout(timeout, unit);
        } else {
            Objects.requireNonNull(unit, "unit is null");
            if (!cf.isDone()) {
                ScheduledFuture<?> f = Delayer.delayToTimoutCf(cf, timeout, unit);
                cf.whenComplete((BiConsumer)new FutureCanceller(f));
            }
        }
        return cf;
    }

    public static <T, C extends CompletableFuture<? super T>> C completeOnTimeout(C cf, @Nullable T value, long timeout, TimeUnit unit) {
        if (IS_JAVA9_PLUS) {
            cf.completeOnTimeout(value, timeout, unit);
        } else {
            Objects.requireNonNull(unit, "unit is null");
            if (!cf.isDone()) {
                ScheduledFuture<?> f = Delayer.delayToCompleteCf(cf, value, timeout, unit);
                cf.whenComplete((BiConsumer)new FutureCanceller(f));
            }
        }
        return cf;
    }

    public static <T> CompletableFuture<T> exceptionallyCompose(CompletableFuture<T> cf, Function<Throwable, ? extends CompletionStage<T>> fn) {
        if (IS_JAVA12_PLUS) {
            return cf.exceptionallyCompose(fn);
        }
        Objects.requireNonNull(fn, "fn is null");
        return ((CompletableFuture)cf.handle((r, ex) -> ex == null ? cf : (CompletionStage)fn.apply((Throwable)ex))).thenCompose(x -> x);
    }

    public static <T> CompletableFuture<T> exceptionallyComposeAsync(CompletableFuture<T> cf, Function<Throwable, ? extends CompletionStage<T>> fn) {
        return CompletableFutureUtils.exceptionallyComposeAsync(cf, fn, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T> CompletableFuture<T> exceptionallyComposeAsync(CompletableFuture<T> cf, Function<Throwable, ? extends CompletionStage<T>> fn, Executor executor) {
        if (IS_JAVA12_PLUS) {
            return cf.exceptionallyComposeAsync(fn, executor);
        }
        Objects.requireNonNull(fn, "fn is null");
        Objects.requireNonNull(executor, "executor is null");
        return ((CompletableFuture)cf.handle((r, ex) -> ex == null ? cf : ((CompletableFuture)cf.handleAsync((r1, ex1) -> (CompletionStage)fn.apply((Throwable)ex1), executor)).thenCompose(x -> x))).thenCompose(x -> x);
    }

    @Blocking
    @Nullable
    public static <T> T join(CompletableFuture<T> cf, long timeout, TimeUnit unit) {
        if (cf.isDone()) {
            return cf.join();
        }
        return CompletableFutureUtils.orTimeout(CompletableFutureUtils.copy(cf), timeout, unit).join();
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T resultNow(CompletableFuture<? extends T> cf) {
        if (IS_JAVA19_PLUS) {
            return cf.resultNow();
        }
        if (!cf.isDone()) {
            throw new IllegalStateException("Task has not completed");
        }
        boolean interrupted = false;
        while (true) {
            try {
                T t = cf.get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Task completed with exception");
            }
            catch (CancellationException e) {
                throw new IllegalStateException("Task was cancelled");
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    public static Throwable exceptionNow(CompletableFuture<?> cf) {
        if (IS_JAVA19_PLUS) {
            return cf.exceptionNow();
        }
        if (!cf.isDone()) {
            throw new IllegalStateException("Task has not completed");
        }
        if (cf.isCancelled()) {
            throw new IllegalStateException("Task was cancelled");
        }
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    cf.get();
                    throw new IllegalStateException("Task completed with a result");
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    return throwable;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    public static CffuState state(CompletableFuture<?> cf) {
        if (IS_JAVA19_PLUS) {
            return CffuState.toCffuState(cf.state());
        }
        if (!cf.isDone()) {
            return CffuState.RUNNING;
        }
        if (cf.isCancelled()) {
            return CffuState.CANCELLED;
        }
        boolean interrupted = false;
        while (true) {
            try {
                cf.get();
                CffuState cffuState = CffuState.SUCCESS;
                return cffuState;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                CffuState cffuState = CffuState.FAILED;
                return cffuState;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T, C extends CompletableFuture<? super T>> C completeAsync(C cf, Supplier<? extends T> supplier) {
        return CompletableFutureUtils.completeAsync(cf, supplier, AsyncPoolHolder.ASYNC_POOL);
    }

    public static <T, C extends CompletableFuture<? super T>> C completeAsync(C cf, Supplier<? extends T> supplier, Executor executor) {
        if (IS_JAVA9_PLUS) {
            cf.completeAsync(supplier, executor);
        } else {
            Objects.requireNonNull(supplier, "supplier is null");
            Objects.requireNonNull(executor, "executor is null");
            executor.execute(new CfCompleterBySupplier<T>(cf, supplier));
        }
        return cf;
    }

    @Contract(pure=true)
    public static <T> CompletionStage<T> minimalCompletionStage(CompletableFuture<T> cf) {
        if (IS_JAVA9_PLUS) {
            return cf.minimalCompletionStage();
        }
        return cf.thenApply(x -> x);
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T> copy(CompletableFuture<T> cf) {
        if (IS_JAVA9_PLUS) {
            return cf.copy();
        }
        return cf.thenApply(x -> x);
    }

    @Contract(pure=true)
    public static <U> CompletableFuture<U> newIncompleteFuture(CompletableFuture<?> cf) {
        if (IS_JAVA9_PLUS) {
            return cf.newIncompleteFuture();
        }
        return new CompletableFuture();
    }

    @Contract(pure=true)
    public static Executor defaultExecutor() {
        return AsyncPoolHolder.ASYNC_POOL;
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] toCompletableFutureArray(CompletionStage<T> ... stages) {
        Objects.requireNonNull(stages, "stages is null");
        CompletableFuture[] ret = new CompletableFuture[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            ret[i] = Objects.requireNonNull(stages[i], "stage" + (i + 1) + " is null").toCompletableFuture();
        }
        return ret;
    }

    @Contract(pure=true)
    public static <T> CompletableFuture<T>[] completableFutureListToArray(List<CompletableFuture<T>> cfList) {
        CompletableFuture[] a = new CompletableFuture[cfList.size()];
        return cfList.toArray(a);
    }

    static Executor screenExecutor(Executor e) {
        if (!USE_COMMON_POOL && e == ForkJoinPool.commonPool()) {
            return AsyncPoolHolder.ASYNC_POOL;
        }
        return Objects.requireNonNull(e, "defaultExecutor is null");
    }

    private CompletableFutureUtils() {
    }

    static {
        boolean b;
        USE_COMMON_POOL = ForkJoinPool.getCommonPoolParallelism() > 1;
        try {
            CompletableFuture.completedStage(null);
            b = true;
        }
        catch (NoSuchMethodError e) {
            b = false;
        }
        IS_JAVA9_PLUS = b;
        CompletableFuture<Integer> cf = CompletableFuture.completedFuture(42);
        try {
            cf.exceptionallyCompose(v -> cf);
            b = true;
        }
        catch (NoSuchMethodError e) {
            b = false;
        }
        IS_JAVA12_PLUS = b;
        try {
            cf.resultNow();
            b = true;
        }
        catch (NoSuchMethodError e) {
            b = false;
        }
        IS_JAVA19_PLUS = b;
    }

    private static class AsyncPoolHolder {
        private static final Executor ASYNC_POOL = AsyncPoolHolder._asyncPool0();

        private AsyncPoolHolder() {
        }

        private static Executor _asyncPool0() {
            if (IS_JAVA9_PLUS) {
                return CompletableFuture.completedFuture(null).defaultExecutor();
            }
            if (USE_COMMON_POOL) {
                return ForkJoinPool.commonPool();
            }
            return new ThreadPerTaskExecutor();
        }
    }

    private static final class ThreadPerTaskExecutor
    implements Executor {
        private ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(Objects.requireNonNull(r)).start();
        }
    }
}

