/*
 * Decompiled with CFR 0.152.
 */
package io.foldright.cffu;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.foldright.cffu.CfCompleter;
import io.foldright.cffu.CfTimeout;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class Delayer {
    private static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

    static ScheduledFuture<?> delay(Runnable command, long delay, TimeUnit unit) {
        return delayer.schedule(command, delay, unit);
    }

    public static ScheduledFuture<?> delayToTimoutCf(CompletableFuture<?> cf, long delay, TimeUnit unit) {
        return Delayer.delay(new CfTimeout(cf), delay, unit);
    }

    public static <T> ScheduledFuture<?> delayToCompleteCf(CompletableFuture<? super T> cf, T value, long delay, TimeUnit unit) {
        return Delayer.delay(new CfCompleter<T>(cf, value), delay, unit);
    }

    private Delayer() {
    }

    static {
        delayer.setRemoveOnCancelPolicy(true);
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("CffuDelayScheduler");
            return t;
        }
    }
}

