/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.Asserts;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.GuiceExt;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.LookupInterceptor;
import com.google.inject.Module;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import junit.framework.TestCase;

public class InterceptorTest
extends TestCase {
    public void testInterceptor() {
        Injector injector = GuiceExt.createInjector((LookupInterceptor)new ConfigProvider(), (Module[])new Module[0]);
        InterceptorTest.assertEquals((String)"a", (String)((A)injector.getInstance(A.class)).config);
        InterceptorTest.assertEquals((int)42, (int)((B)injector.getInstance(B.class)).config);
    }

    public void testInterceptorFail() {
        try {
            Injector injector = GuiceExt.createInjector((LookupInterceptor)new LookupInterceptor(){

                public <T> T intercept(Key<T> key) {
                    return null;
                }
            }, (Module[])new Module[0]);
            injector.getInstance(A.class);
            InterceptorTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "No implementation for String annotated");
        }
    }

    public static class ConfigProvider
    implements LookupInterceptor {
        public <T> T getInstance(String configValue, Class<T> klass) {
            if (klass == String.class) {
                return (T)configValue;
            }
            if (klass == Integer.class) {
                return (T)Integer.valueOf(configValue);
            }
            throw new RuntimeException();
        }

        public <T> T intercept(Key<T> key) {
            if (key.getAnnotation() != null && key.getAnnotation().annotationType() == Config.class) {
                return this.getInstance(((Config)key.getAnnotation()).value(), key.getTypeLiteral().getRawType());
            }
            return null;
        }
    }

    public static class B {
        int config;

        @Inject
        public B(@Config(value="42") int config) {
            this.config = config;
        }
    }

    public static class A {
        String config;

        @Inject
        public A(@Config(value="a") String config) {
            this.config = config;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    static @interface Config {
        public String value();
    }
}

