/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ScopeAnnotation;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.InternalFlags;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import com.google.inject.spi.TypeConverter;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ParentInjectorTest {
    private final MethodInterceptor returnNullInterceptor = new MethodInterceptor(){

        public Object invoke(MethodInvocation methodInvocation) {
            return null;
        }
    };
    private final Module bindsA = new AbstractModule(){

        protected void configure() {
            this.bind(A.class).toInstance((Object)new A());
        }
    };
    private final Module bindsB = new AbstractModule(){

        protected void configure() {
            this.bind(B.class).to(RealB.class);
        }
    };
    private final TypeConverter listConverter = new TypeConverter(){

        public Object convert(String value, TypeLiteral<?> toType) {
            return ImmutableList.of();
        }
    };
    private final Module bindListConverterModule = new AbstractModule(){

        protected void configure() {
            this.convertToTypes(Matchers.any(), ParentInjectorTest.this.listConverter);
        }
    };
    private final Module bindStringNamedB = new AbstractModule(){

        protected void configure() {
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"B")).toInstance((Object)"buzz");
        }
    };
    private final Module bindsD = new AbstractModule(){

        protected void configure() {
            this.bind(D.class);
        }
    };

    @Test
    public void testParentAndChildCannotShareExplicitBindings() {
        Injector parent = Guice.createInjector((Module[])new Module[]{this.bindsA});
        try {
            parent.createChildInjector(new Module[]{this.bindsA});
            Assert.fail((String)"Created the same explicit binding on both parent and child");
        }
        catch (CreationException e) {
            Asserts.assertContains(e.getMessage(), "ParentInjectorTest$A was bound multiple times.", "1  : ParentInjectorTest$9.configure", "2  : ParentInjectorTest$9.configure");
        }
    }

    @Test
    public void testParentJitBindingWontClobberChildBinding() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        parent.createChildInjector(new Module[]{this.bindsA});
        try {
            parent.getInstance(A.class);
            Assert.fail((String)"Created a just-in-time binding on the parent that's the same as a child's binding");
        }
        catch (ConfigurationException e) {
            Asserts.assertContains(e.getMessage(), "Unable to create binding for ParentInjectorTest$A because it was already configured on one or more child injectors or private modules.", "ParentInjectorTest$9.configure");
        }
    }

    @Test
    public void testChildCannotBindToAParentJitBinding() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        parent.getInstance(A.class);
        try {
            parent.createChildInjector(new Module[]{this.bindsA});
            Assert.fail();
        }
        catch (CreationException ce) {
            Asserts.assertContains(((Message)Iterables.getOnlyElement((Iterable)ce.getErrorMessages())).getMessage(), "A just-in-time binding to " + A.class.getName() + " was already configured on a parent injector.");
        }
    }

    @Test
    public void testJustInTimeBindingsAreSharedWithParentIfPossible() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector child = parent.createChildInjector(new Module[0]);
        Assert.assertSame((Object)child.getInstance(A.class), (Object)parent.getInstance(A.class));
        Injector anotherChild = parent.createChildInjector(new Module[0]);
        Assert.assertSame((Object)anotherChild.getInstance(A.class), (Object)parent.getInstance(A.class));
        Injector grandchild = child.createChildInjector(new Module[0]);
        Assert.assertSame((Object)grandchild.getInstance(A.class), (Object)parent.getInstance(A.class));
    }

    @Test
    public void testBindingsInherited() {
        Injector parent = Guice.createInjector((Module[])new Module[]{this.bindsB});
        Injector child = parent.createChildInjector(new Module[0]);
        Assert.assertSame(RealB.class, ((B)child.getInstance(B.class)).getClass());
    }

    @Test
    public void testGetParent() {
        Injector top = Guice.createInjector((Module[])new Module[]{this.bindsA});
        Injector middle = top.createChildInjector(new Module[]{this.bindsB});
        Injector bottom = middle.createChildInjector(new Module[0]);
        Assert.assertSame((Object)middle, (Object)bottom.getParent());
        Assert.assertSame((Object)top, (Object)middle.getParent());
        Assert.assertNull((Object)top.getParent());
    }

    @Test
    public void testChildBindingsNotVisibleToParent() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        parent.createChildInjector(new Module[]{this.bindsB});
        try {
            parent.getBinding(B.class);
            Assert.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @Test
    public void testScopesInherited() {
        Injector parent = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindScope(MyScope.class, Scopes.SINGLETON);
            }
        }});
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(A.class).in(MyScope.class);
            }
        }});
        Assert.assertSame((Object)child.getInstance(A.class), (Object)child.getInstance(A.class));
    }

    @Test
    public void testInterceptorsInherited() {
        Assume.assumeTrue((boolean)InternalFlags.isBytecodeGenEnabled());
        Injector parent = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                super.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.identicalTo(A.class)), new MethodInterceptor[]{ParentInjectorTest.this.returnNullInterceptor});
            }
        }});
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(C.class);
            }
        }});
        Assert.assertNull((Object)((C)child.getInstance(C.class)).interceptedMethod());
    }

    @Test
    public void testTypeConvertersInherited() {
        Injector parent = Guice.createInjector((Module[])new Module[]{this.bindListConverterModule});
        Injector child = parent.createChildInjector(new Module[]{this.bindStringNamedB});
        Assert.assertEquals((Object)ImmutableList.of(), (Object)child.getInstance(Key.get(List.class, (Annotation)Names.named((String)"B"))));
    }

    @Test
    public void testTypeConvertersConflicting() {
        Injector parent = Guice.createInjector((Module[])new Module[]{this.bindListConverterModule});
        Injector child = parent.createChildInjector(new Module[]{this.bindListConverterModule, this.bindStringNamedB});
        try {
            child.getInstance(Key.get(List.class, (Annotation)Names.named((String)"B")));
            Assert.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Multiple converters can convert");
        }
    }

    @Test
    public void testInjectorInjectionSpanningInjectors() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(D.class);
            }
        }});
        D d = (D)child.getInstance(D.class);
        Assert.assertSame((Object)d.injector, (Object)child);
        E e = (E)child.getInstance(E.class);
        Assert.assertSame((Object)e.injector, (Object)parent);
    }

    @Test
    public void testSeveralLayersOfHierarchy() {
        Injector top = Guice.createInjector((Module[])new Module[]{this.bindsA});
        Injector left = top.createChildInjector(new Module[0]);
        Injector leftLeft = left.createChildInjector(new Module[]{this.bindsD});
        Injector right = top.createChildInjector(new Module[]{this.bindsD});
        Assert.assertSame((Object)leftLeft, (Object)((D)leftLeft.getInstance(D.class)).injector);
        Assert.assertSame((Object)right, (Object)((D)right.getInstance(D.class)).injector);
        Assert.assertSame((Object)top, (Object)((E)leftLeft.getInstance(E.class)).injector);
        Assert.assertSame((Object)top.getInstance(A.class), (Object)leftLeft.getInstance(A.class));
        Injector leftRight = left.createChildInjector(new Module[]{this.bindsD});
        Assert.assertSame((Object)leftRight, (Object)((D)leftRight.getInstance(D.class)).injector);
        try {
            top.getInstance(D.class);
            Assert.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            left.getInstance(D.class);
            Assert.fail();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @Test
    public void testScopeBoundInChildInjectorOnly() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector child = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindScope(MyScope.class, Scopes.SINGLETON);
            }
        }});
        try {
            parent.getProvider(F.class);
            Assert.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "No scope is bound to ParentInjectorTest$MyScope.", "ParentInjectorTest$F.class", "while locating ParentInjectorTest$F");
        }
        Assert.assertNotNull((Object)child.getProvider(F.class).get());
    }

    @Test
    public void testErrorInParentButOkayInChild() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector childInjector = parent.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindScope(MyScope.class, Scopes.SINGLETON);
                this.bind(Object.class).to(F.class);
            }
        }});
        Object one = childInjector.getInstance(Object.class);
        Object two = childInjector.getInstance(Object.class);
        Assert.assertSame((Object)one, (Object)two);
    }

    @Test
    public void testErrorInParentAndChild() {
        Injector parent = Guice.createInjector((Module[])new Module[0]);
        Injector childInjector = parent.createChildInjector(new Module[0]);
        try {
            childInjector.getInstance(G.class);
            Assert.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "No scope is bound to ParentInjectorTest$MyScope.", "ParentInjectorTest$F.class", "at ParentInjectorTest$G.class", "while locating ParentInjectorTest$G");
        }
    }

    @ImplementedBy(value=F.class)
    static interface G {
    }

    @MyScope
    static class F
    implements G {
        F() {
        }
    }

    static class E {
        @Inject
        Injector injector;

        E() {
        }
    }

    static class D {
        @Inject
        Injector injector;

        D() {
        }
    }

    public static class C {
        public A interceptedMethod() {
            return new A();
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ScopeAnnotation
    public static @interface MyScope {
    }

    static class RealB
    implements B {
        RealB() {
        }
    }

    static interface B {
    }

    @Singleton
    static class A {
        A() {
        }
    }
}

