/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Asserts;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.List;
import junit.framework.TestCase;

public class TypeLiteralInjectionTest
extends TestCase {
    public void testBindingToRawTypeLiteralIsNotAllowed() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(TypeLiteral.class).toInstance((Object)TypeLiteral.get(String.class));
                }
            }});
            TypeLiteralInjectionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Binding to core guice framework type is not allowed: TypeLiteral");
        }
    }

    public void testBindingToParameterizedTypeLiteralIsNotAllowed() {
        try {
            Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind((TypeLiteral)new TypeLiteral<TypeLiteral<String>>(){}).toInstance((Object)TypeLiteral.get(String.class));
                }
            }});
            TypeLiteralInjectionTest.fail();
        }
        catch (CreationException expected) {
            Asserts.assertContains(expected.getMessage(), "Binding to core guice framework type is not allowed: TypeLiteral");
        }
    }

    public void testInjectTypeLiteralWithRawTypes() {
        C c = (C)Guice.createInjector((Module[])new Module[0]).getInstance(C.class);
        TypeLiteralInjectionTest.assertEquals((Object)TypeLiteral.get(String.class), c.string);
        TypeLiteralInjectionTest.assertEquals((Object)TypeLiteral.get(A.class), c.a);
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(B.class);
            TypeLiteralInjectionTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "TypeLiteral<List<T>> cannot be used as a key; It is not fully specified.");
        }
    }

    public void testInjectTypeLiteralWithClassTypes() {
        B b = (B)Guice.createInjector((Module[])new Module[0]).getInstance((Key)new Key<B<Integer>>(){});
        TypeLiteralInjectionTest.assertEquals((Object)TypeLiteral.get(String.class), (Object)b.string);
        TypeLiteralInjectionTest.assertEquals((Object)TypeLiteral.get(Integer.class), b.t);
        TypeLiteralInjectionTest.assertEquals((Object)TypeLiteral.get((Type)Types.listOf(Integer.class)), (Object)b.listOfT);
        TypeLiteralInjectionTest.assertEquals((Object)TypeLiteral.get((Type)Types.listOf((Type)Types.subtypeOf(Integer.class))), (Object)b.listOfWildcardT);
    }

    public void testInjectRawTypeLiteral() {
        try {
            Guice.createInjector((Module[])new Module[0]).getInstance(TypeLiteral.class);
            TypeLiteralInjectionTest.fail();
        }
        catch (ConfigurationException expected) {
            Asserts.assertContains(expected.getMessage(), "Cannot inject a TypeLiteral that has no type parameter");
        }
    }

    static class C<T> {
        @Inject
        TypeLiteral<String> string;
        @Inject
        TypeLiteral<A> a;
        T t;

        C() {
        }
    }

    static class B<T>
    extends A<T> {
        @Inject
        TypeLiteral<T> t;

        B() {
        }
    }

    static class A<T> {
        @Inject
        TypeLiteral<String> string;
        @Inject
        TypeLiteral<List<T>> listOfT;
        @Inject
        TypeLiteral<List<? extends T>> listOfWildcardT;

        A() {
        }
    }
}

